/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.marshalling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DoubleArraySerializerDeserializer
implements ISerializerDeserializer<double[]> {
    private static final long serialVersionUID = 1L;
    public static final DoubleArraySerializerDeserializer INSTANCE = new DoubleArraySerializerDeserializer();

    private DoubleArraySerializerDeserializer() {
    }

    public double[] deserialize(DataInput in) throws HyracksDataException {
        return DoubleArraySerializerDeserializer.read(in);
    }

    public void serialize(double[] instance, DataOutput out) throws HyracksDataException {
        DoubleArraySerializerDeserializer.write(instance, out);
    }

    public static double[] read(DataInput in) throws HyracksDataException {
        try {
            int len = in.readInt();
            double[] array = new double[len];
            for (int i = 0; i < array.length; ++i) {
                array[i] = in.readDouble();
            }
            return array;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static void write(double[] instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeInt(instance.length);
            for (int i = 0; i < instance.length; ++i) {
                out.writeDouble(instance[i]);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

