/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomChildNodeMixin
implements AxiomChildNode {
    public final OMContainer getParent() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof OMContainer ? (OMContainer)parent : null;
    }

    public final OMNode getNextOMSibling() {
        try {
            return (OMNode)this.coreGetNextSibling();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final OMNode getPreviousOMSibling() {
        return (OMNode)this.coreGetPreviousSibling();
    }

    public final void insertSiblingAfter(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingAfter(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void insertSiblingBefore(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingBefore(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final OMNode detach() {
        if (!this.coreHasParent()) {
            throw new OMException("Nodes that don't have a parent can not be detached");
        }
        this.coreDetach(AxiomSemantics.INSTANCE);
        return this;
    }
}

