/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketchIterator;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIteratorAPI;

public abstract class KllDoublesSketch
extends KllSketch
implements QuantilesDoublesAPI {
    private DoublesSketchSortedView doublesSV = null;
    static final int ITEM_BYTES = 8;

    KllDoublesSketch(KllSketch.SketchStructure sketchStructure) {
        super(KllSketch.SketchType.KLL_DOUBLES_SKETCH, sketchStructure);
    }

    KllDoublesSketch(KllMemorySegmentValidate segVal) {
        super(segVal);
    }

    public static KllDoublesSketch newHeapInstance() {
        return KllDoublesSketch.newHeapInstance(200);
    }

    public static KllDoublesSketch newHeapInstance(int k) {
        return new KllHeapDoublesSketch(k, 8);
    }

    public static KllDoublesSketch newDirectInstance(MemorySegment dstSeg) {
        return KllDoublesSketch.newDirectInstance(200, dstSeg, null);
    }

    public static KllDoublesSketch newDirectInstance(int k, MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(dstSeg, "Parameter 'dstSeg' must not be null");
        return KllDirectDoublesSketch.newDirectUpdatableInstance(k, 8, dstSeg, mSegReq);
    }

    public static KllDoublesSketch heapify(MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        return KllHeapDoublesSketch.heapifyImpl(srcSeg);
    }

    public static KllDoublesSketch wrap(MemorySegment srcSeg) {
        return KllDoublesSketch.wrap(srcSeg, null);
    }

    public static KllDoublesSketch wrap(MemorySegment srcSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(srcSeg, KllSketch.SketchType.KLL_DOUBLES_SKETCH);
        return new KllDirectDoublesSketch(srcSeg, segVal, mSegReq);
    }

    @Override
    public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getQuantile(rank, searchCrit);
    }

    @Override
    public double[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        double[] quantiles = new double[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.doublesSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public double getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(double[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.doublesSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesDoublesSketchIteratorAPI iterator() {
        return new KllDoublesSketchIterator(this.getDoubleItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (this == other) {
            throw new SketchesArgumentException("A sketch cannot merge with itself. ");
        }
        KllDoublesSketch othDblSk = (KllDoublesSketch)other;
        if (othDblSk.isEmpty()) {
            return;
        }
        KllDoublesHelper.mergeDoubleImpl(this, othDblSk);
        this.doublesSV = null;
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(Double.NaN);
        this.setMaxItem(Double.NaN);
        this.setDoubleItemsArray(new double[k]);
        this.doublesSV = null;
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withLevels, boolean withLevelsAndItems) {
        KllDoublesSketch sketch = this;
        if (withLevelsAndItems && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            MemorySegment seg = this.getMemorySegment();
            assert (seg != null);
            sketch = KllDoublesSketch.heapify(this.getMemorySegment());
        }
        return KllHelper.toStringImpl(sketch, withLevels, withLevelsAndItems);
    }

    @Override
    public void update(double item) {
        if (Double.isNaN(item)) {
            return;
        }
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllDoublesSketch.updateDouble(this, item);
        this.doublesSV = null;
    }

    static void updateDouble(KllDoublesSketch dblSk, double item) {
        dblSk.updateMinMax(item);
        int freeSpace = dblSk.levelsArr[0];
        assert (freeSpace >= 0);
        if (freeSpace == 0) {
            KllDoublesHelper.compressWhileUpdatingSketch(dblSk);
            freeSpace = dblSk.levelsArr[0];
            assert (freeSpace > 0);
        }
        dblSk.incN(1);
        dblSk.setLevelZeroSorted(false);
        int nextPos = freeSpace - 1;
        dblSk.setLevelsArrayAt(0, nextPos);
        dblSk.setDoubleItemsArrayAt(nextPos, item);
    }

    final void updateMinMax(double item) {
        if (this.isEmpty() || Double.isNaN(this.getMinItemInternal())) {
            this.setMinItem(item);
            this.setMaxItem(item);
        } else {
            this.setMinItem(Math.min(this.getMinItemInternal(), item));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), item));
        }
    }

    public void update(double item, long weight) {
        if (Double.isNaN(item)) {
            return;
        }
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (weight < 1L) {
            throw new SketchesArgumentException("Weight is less than one.");
        }
        if (weight == 1L) {
            KllDoublesSketch.updateDouble(this, item);
        } else if (weight < (long)this.levelsArr[0]) {
            for (int i = 0; i < (int)weight; ++i) {
                KllDoublesSketch.updateDouble(this, item);
            }
        } else {
            KllHeapDoublesSketch tmpSk = new KllHeapDoublesSketch(this.getK(), 8, item, weight);
            this.merge(tmpSk);
        }
        this.doublesSV = null;
    }

    public void update(double[] items, int offset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (length == 0) {
            return;
        }
        if (!KllDoublesSketch.hasNaN(items, offset, length)) {
            this.updateDouble(items, offset, length);
            this.doublesSV = null;
            return;
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            double v = items[i];
            if (Double.isNaN(v)) continue;
            KllDoublesSketch.updateDouble(this, v);
            this.doublesSV = null;
        }
    }

    private void updateDouble(double[] srcItems, int srcOffset, int length) {
        int numItemsToCopy;
        if (this.isEmpty() || Double.isNaN(this.getMinItemInternal())) {
            this.setMinItem(srcItems[srcOffset]);
            this.setMaxItem(srcItems[srcOffset]);
        }
        for (int count = 0; count < length; count += numItemsToCopy) {
            if (this.levelsArr[0] == 0) {
                KllDoublesHelper.compressWhileUpdatingSketch(this);
            }
            int spaceNeeded = length - count;
            int freeSpace = this.levelsArr[0];
            assert (freeSpace > 0);
            numItemsToCopy = Math.min(spaceNeeded, freeSpace);
            int dstOffset = freeSpace - numItemsToCopy;
            int localSrcOffset = srcOffset + count;
            this.setDoubleItemsArrayAt(dstOffset, srcItems, localSrcOffset, numItemsToCopy);
            this.updateMinMax(srcItems, localSrcOffset, numItemsToCopy);
            this.incN(numItemsToCopy);
            this.setLevelsArrayAt(0, dstOffset);
        }
        this.setLevelZeroSorted(false);
    }

    private void updateMinMax(double[] srcItems, int srcOffset, int length) {
        int end = srcOffset + length;
        for (int i = srcOffset; i < end; ++i) {
            this.setMinItem(Math.min(this.getMinItemInternal(), srcItems[i]));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), srcItems[i]));
        }
    }

    private static boolean hasNaN(double[] items, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (!Double.isNaN(items[i])) continue;
            return true;
        }
        return false;
    }

    abstract double[] getDoubleItemsArray();

    abstract double[] getDoubleRetainedItemsArray();

    abstract double getDoubleSingleItem();

    abstract double getMaxItemInternal();

    abstract void setMaxItem(double var1);

    abstract double getMinItemInternal();

    abstract void setMinItem(double var1);

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    int getMinMaxSizeBytes() {
        return 16;
    }

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getNumRetained() * 8;
    }

    @Override
    ArrayOfItemsSerDe<?> getSerDe() {
        return null;
    }

    @Override
    final byte[] getSingleItemByteArr() {
        byte[] bytes = new byte[8];
        ByteArrayUtil.putDoubleLE(bytes, 0, this.getDoubleSingleItem());
        return bytes;
    }

    @Override
    int getSingleItemSizeBytes() {
        return 8;
    }

    @Override
    abstract byte[] getTotalItemsByteArr();

    @Override
    int getTotalItemsNumBytes() {
        return this.levelsArr[this.getNumLevels()] * 8;
    }

    abstract void setDoubleItemsArray(double[] var1);

    abstract void setDoubleItemsArrayAt(int var1, double var2);

    abstract void setDoubleItemsArrayAt(int var1, double[] var2, int var3, int var4);

    @Override
    public DoublesSketchSortedView getSortedView() {
        this.refreshSortedView();
        return this.doublesSV;
    }

    private final DoublesSketchSortedView refreshSortedView() {
        if (this.doublesSV == null) {
            CreateSortedView csv = new CreateSortedView(this);
            this.doublesSV = csv.getSV();
        }
        return this.doublesSV;
    }

    private static void blockyTandemMergeSort(double[] quantiles, long[] weights, int[] levels, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        double[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllDoublesSketch.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels);
    }

    private static void blockyTandemMergeSortRecursion(double[] quantilesSrc, long[] weightsSrc, double[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllDoublesSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1);
        KllDoublesSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2);
        KllDoublesSketch.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2);
    }

    private static void tandemMerge(double[] quantilesSrc, long[] weightsSrc, double[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (quantilesSrc[iSrc1] < quantilesSrc[iSrc2]) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    private final class CreateSortedView {
        double[] quantiles;
        long[] cumWeights;
        final /* synthetic */ KllDoublesSketch this$0;

        private CreateSortedView(KllDoublesSketch kllDoublesSketch) {
            KllDoublesSketch kllDoublesSketch2 = kllDoublesSketch;
            Objects.requireNonNull(kllDoublesSketch2);
            this.this$0 = kllDoublesSketch2;
        }

        DoublesSketchSortedView getSV() {
            if (this.this$0.isEmpty()) {
                throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
            }
            double[] srcQuantiles = this.this$0.getDoubleItemsArray();
            int[] srcLevels = this.this$0.levelsArr;
            int srcNumLevels = this.this$0.getNumLevels();
            if (!this.this$0.isLevelZeroSorted()) {
                Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1]);
                if (!this.this$0.hasMemorySegment()) {
                    this.this$0.setLevelZeroSorted(true);
                }
            }
            int numQuantiles = this.this$0.getNumRetained();
            this.quantiles = new double[numQuantiles];
            this.cumWeights = new long[numQuantiles];
            this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
            return new DoublesSketchSortedView(this.quantiles, this.cumWeights, this.this$0);
        }

        private void populateFromSketch(double[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
            int[] myLevels = new int[srcNumLevels + 1];
            int offset = srcLevels[0];
            System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
            int srcLevel = 0;
            int dstLevel = 0;
            long weight = 1L;
            while (srcLevel < srcNumLevels) {
                int fromIndex = srcLevels[srcLevel] - offset;
                int toIndex = srcLevels[srcLevel + 1] - offset;
                if (fromIndex < toIndex) {
                    Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                    myLevels[dstLevel] = fromIndex;
                    myLevels[dstLevel + 1] = toIndex;
                    ++dstLevel;
                }
                ++srcLevel;
                weight *= 2L;
            }
            int numLevels = dstLevel;
            KllDoublesSketch.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels);
            KllHelper.convertToCumulative(this.cumWeights);
        }
    }
}

