/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInThetaSketchedSets;

public final class JaccardSimilarity {
    private static final double[] ZEROS = new double[]{0.0, 0.0, 0.0};
    private static final double[] ONES = new double[]{1.0, 1.0, 1.0};

    private JaccardSimilarity() {
    }

    public static double[] jaccard(ThetaSketch sketchA, ThetaSketch sketchB) {
        if (sketchA == null || sketchB == null) {
            return (double[])ZEROS.clone();
        }
        if (sketchA == sketchB) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return (double[])ONES.clone();
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return (double[])ZEROS.clone();
        }
        int countA = sketchA.getRetainedEntries(true);
        int countB = sketchB.getRetainedEntries(true);
        int minK = 16;
        int maxK = 0x4000000;
        int newK = Math.max(Math.min(Util.ceilingPowerOf2(countA + countB), 0x4000000), 16);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(newK).buildUnion();
        union.union(sketchA);
        union.union(sketchB);
        CompactThetaSketch unionAB = union.getResult(false, null);
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = unionAB.getRetainedEntries(true);
        if (countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB) {
            return (double[])ONES.clone();
        }
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect(sketchA);
        inter.intersect(sketchB);
        inter.intersect(unionAB);
        CompactThetaSketch interABU = inter.getResult(false, null);
        double lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA(unionAB, interABU);
        double est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA(unionAB, interABU);
        double ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA(unionAB, interABU);
        return new double[]{lb, est, ub};
    }

    public static boolean exactlyEqual(ThetaSketch sketchA, ThetaSketch sketchB) {
        if (sketchA == null || sketchB == null) {
            return false;
        }
        if (sketchA == sketchB) {
            return true;
        }
        if (sketchA.isEmpty() && sketchB.isEmpty()) {
            return true;
        }
        if (sketchA.isEmpty() || sketchB.isEmpty()) {
            return false;
        }
        int countA = sketchA.getRetainedEntries(true);
        int countB = sketchB.getRetainedEntries(true);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(Util.ceilingPowerOf2(countA + countB)).buildUnion();
        union.union(sketchA);
        union.union(sketchB);
        CompactThetaSketch unionAB = union.getResult();
        long thetaLongUAB = unionAB.getThetaLong();
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        int countUAB = unionAB.getRetainedEntries(true);
        return countUAB == countA && countUAB == countB && thetaLongUAB == thetaLongA && thetaLongUAB == thetaLongB;
    }

    public static boolean similarityTest(ThetaSketch measured, ThetaSketch expected, double threshold) {
        double jRatioLB = JaccardSimilarity.jaccard(measured, expected)[0];
        return jRatioLB >= threshold;
    }

    public static boolean dissimilarityTest(ThetaSketch measured, ThetaSketch expected, double threshold) {
        double jRatioUB = JaccardSimilarity.jaccard(measured, expected)[2];
        return jRatioUB <= threshold;
    }
}

