/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.felix.framework.util.SecureAction;

public final class PropertiesCache {
    private final File m_file;
    private final File m_tmp;
    private final SecureAction m_action;

    public PropertiesCache(File store, File tmp, SecureAction action) {
        this.m_action = action;
        this.m_file = store;
        this.m_tmp = tmp;
    }

    public void write(Map data) throws IOException {
        File tmp2;
        block22: {
            FileOutputStream out = null;
            File tmp = null;
            tmp2 = null;
            try {
                tmp = this.m_action.createTempFile("tmp", null, this.m_tmp);
                tmp2 = this.m_action.createTempFile("tmp", null, this.m_tmp);
                this.m_action.deleteFile(tmp2);
                IOException org = null;
                try {
                    out = this.m_action.getFileOutputStream(tmp);
                    Properties store = new Properties();
                    int count = 0;
                    for (Map.Entry entry : data.entrySet()) {
                        store.setProperty(count++ + "-" + (String)entry.getKey(), this.getEncoded(entry.getValue()));
                    }
                    store.store(out, null);
                }
                catch (IOException ex) {
                    org = ex;
                    throw ex;
                }
                finally {
                    block21: {
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException ex) {
                                if (org != null) break block21;
                                throw ex;
                            }
                        }
                    }
                }
                if (this.m_action.fileExists(this.m_file) && !this.m_action.renameFile(this.m_file, tmp2) || !this.m_action.renameFile(tmp, this.m_file)) {
                    throw new IOException("Unable to write permissions");
                }
                if (tmp == null) break block22;
            }
            catch (IOException ex) {
                try {
                    if (!this.m_action.fileExists(this.m_file) && tmp2 != null && this.m_action.fileExists(tmp2)) {
                        this.m_action.renameFile(tmp2, this.m_file);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (tmp != null) {
                        this.m_action.deleteFile(tmp);
                    }
                    if (tmp2 != null) {
                        this.m_action.deleteFile(tmp2);
                    }
                    throw throwable;
                }
            }
            this.m_action.deleteFile(tmp);
        }
        if (tmp2 != null) {
            this.m_action.deleteFile(tmp2);
        }
    }

    public void read(Class target, Map map) throws IOException {
        if (!this.m_file.isFile()) {
            return;
        }
        FileInputStream in = null;
        IOException other = null;
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        try {
            in = this.m_action.getFileInputStream(this.m_file);
            Properties store = new Properties();
            store.load(in);
            for (Map.Entry<Object, Object> entry : store.entrySet()) {
                result.put(entry.getKey(), this.getUnencoded((String)entry.getValue(), target));
            }
        }
        catch (IOException ex) {
            other = ex;
            throw ex;
        }
        finally {
            block14: {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ex) {
                        if (other != null) break block14;
                        throw ex;
                    }
                }
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String key = (String)entry.getKey();
            map.put(key.substring(key.indexOf("-")), entry.getValue());
        }
    }

    private String getEncoded(Object target) throws IOException {
        Properties props = new Properties();
        if (target.getClass().isArray()) {
            Object[] array = (Object[])target;
            for (int i = 0; i < array.length; ++i) {
                props.setProperty(Integer.toString(i), array[i].toString());
            }
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            props.store(tmp, null);
            return new String(tmp.toByteArray());
        }
        return target.toString();
    }

    private Object getUnencoded(String encoded, Class target) throws IOException {
        try {
            if (target.isArray()) {
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(encoded.getBytes()));
                Class<?> componentType = target.getComponentType();
                Constructor constructor = this.m_action.getConstructor(componentType, new Class[]{String.class});
                Object[] params = new Object[1];
                Object[] result = (Object[])Array.newInstance(componentType, props.size());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    params[0] = entry.getValue();
                    result[Integer.parseInt((String)((String)entry.getKey()))] = constructor.newInstance(params);
                }
                return result;
            }
            return this.m_action.invoke(this.m_action.getConstructor(target, new Class[]{String.class}), new Object[]{encoded});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }
}

