/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseMessage
implements Message {
    private final Object contentHolder;
    private final AtomicReference<ByteString> serializedData = new AtomicReference();
    private final Logger logger = LoggerFactory.getLogger(ResponseMessage.class);

    ResponseMessage(Object content) {
        this.contentHolder = content;
    }

    Object getContentHolder() {
        return this.contentHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteString getContent() {
        if (this.serializedData.get() == null) {
            ResponseMessage responseMessage = this;
            synchronized (responseMessage) {
                if (this.serializedData.get() == null) {
                    assert (this.contentHolder instanceof TSStatus);
                    TSStatus status = (TSStatus)this.contentHolder;
                    try {
                        this.serializedData.set(ByteString.copyFrom((ByteBuffer)Utils.serializeTSStatus(status)));
                    }
                    catch (TException e) {
                        this.logger.warn("serialize TSStatus failed {}", (Object)status);
                    }
                }
            }
        }
        return this.serializedData.get();
    }
}

