/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.StatusResult;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ProgramDiagnosticDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=894");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=895");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=896");
    private final NodeId createSessionId;
    private final String createClientName;
    private final DateTime invocationCreationTime;
    private final DateTime lastTransitionTime;
    private final String lastMethodCall;
    private final NodeId lastMethodSessionId;
    private final Argument[] lastMethodInputArguments;
    private final Argument[] lastMethodOutputArguments;
    private final DateTime lastMethodCallTime;
    private final StatusResult lastMethodReturnStatus;

    public ProgramDiagnosticDataType(NodeId createSessionId, String createClientName, DateTime invocationCreationTime, DateTime lastTransitionTime, String lastMethodCall, NodeId lastMethodSessionId, Argument[] lastMethodInputArguments, Argument[] lastMethodOutputArguments, DateTime lastMethodCallTime, StatusResult lastMethodReturnStatus) {
        this.createSessionId = createSessionId;
        this.createClientName = createClientName;
        this.invocationCreationTime = invocationCreationTime;
        this.lastTransitionTime = lastTransitionTime;
        this.lastMethodCall = lastMethodCall;
        this.lastMethodSessionId = lastMethodSessionId;
        this.lastMethodInputArguments = lastMethodInputArguments;
        this.lastMethodOutputArguments = lastMethodOutputArguments;
        this.lastMethodCallTime = lastMethodCallTime;
        this.lastMethodReturnStatus = lastMethodReturnStatus;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getCreateSessionId() {
        return this.createSessionId;
    }

    public String getCreateClientName() {
        return this.createClientName;
    }

    public DateTime getInvocationCreationTime() {
        return this.invocationCreationTime;
    }

    public DateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public String getLastMethodCall() {
        return this.lastMethodCall;
    }

    public NodeId getLastMethodSessionId() {
        return this.lastMethodSessionId;
    }

    public Argument[] getLastMethodInputArguments() {
        return this.lastMethodInputArguments;
    }

    public Argument[] getLastMethodOutputArguments() {
        return this.lastMethodOutputArguments;
    }

    public DateTime getLastMethodCallTime() {
        return this.lastMethodCallTime;
    }

    public StatusResult getLastMethodReturnStatus() {
        return this.lastMethodReturnStatus;
    }

    protected ProgramDiagnosticDataType(ProgramDiagnosticDataTypeBuilder<?, ?> b) {
        super(b);
        this.createSessionId = ((ProgramDiagnosticDataTypeBuilder)b).createSessionId;
        this.createClientName = ((ProgramDiagnosticDataTypeBuilder)b).createClientName;
        this.invocationCreationTime = ((ProgramDiagnosticDataTypeBuilder)b).invocationCreationTime;
        this.lastTransitionTime = ((ProgramDiagnosticDataTypeBuilder)b).lastTransitionTime;
        this.lastMethodCall = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodCall;
        this.lastMethodSessionId = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodSessionId;
        this.lastMethodInputArguments = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodInputArguments;
        this.lastMethodOutputArguments = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodOutputArguments;
        this.lastMethodCallTime = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodCallTime;
        this.lastMethodReturnStatus = ((ProgramDiagnosticDataTypeBuilder)b).lastMethodReturnStatus;
    }

    public static ProgramDiagnosticDataTypeBuilder<?, ?> builder() {
        return new ProgramDiagnosticDataTypeBuilderImpl();
    }

    public ProgramDiagnosticDataTypeBuilder<?, ?> toBuilder() {
        return new ProgramDiagnosticDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgramDiagnosticDataType)) {
            return false;
        }
        ProgramDiagnosticDataType other = (ProgramDiagnosticDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$createSessionId = this.getCreateSessionId();
        NodeId other$createSessionId = other.getCreateSessionId();
        if (this$createSessionId == null ? other$createSessionId != null : !((Object)this$createSessionId).equals(other$createSessionId)) {
            return false;
        }
        String this$createClientName = this.getCreateClientName();
        String other$createClientName = other.getCreateClientName();
        if (this$createClientName == null ? other$createClientName != null : !this$createClientName.equals(other$createClientName)) {
            return false;
        }
        DateTime this$invocationCreationTime = this.getInvocationCreationTime();
        DateTime other$invocationCreationTime = other.getInvocationCreationTime();
        if (this$invocationCreationTime == null ? other$invocationCreationTime != null : !((Object)this$invocationCreationTime).equals(other$invocationCreationTime)) {
            return false;
        }
        DateTime this$lastTransitionTime = this.getLastTransitionTime();
        DateTime other$lastTransitionTime = other.getLastTransitionTime();
        if (this$lastTransitionTime == null ? other$lastTransitionTime != null : !((Object)this$lastTransitionTime).equals(other$lastTransitionTime)) {
            return false;
        }
        String this$lastMethodCall = this.getLastMethodCall();
        String other$lastMethodCall = other.getLastMethodCall();
        if (this$lastMethodCall == null ? other$lastMethodCall != null : !this$lastMethodCall.equals(other$lastMethodCall)) {
            return false;
        }
        NodeId this$lastMethodSessionId = this.getLastMethodSessionId();
        NodeId other$lastMethodSessionId = other.getLastMethodSessionId();
        if (this$lastMethodSessionId == null ? other$lastMethodSessionId != null : !((Object)this$lastMethodSessionId).equals(other$lastMethodSessionId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLastMethodInputArguments(), other.getLastMethodInputArguments())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLastMethodOutputArguments(), other.getLastMethodOutputArguments())) {
            return false;
        }
        DateTime this$lastMethodCallTime = this.getLastMethodCallTime();
        DateTime other$lastMethodCallTime = other.getLastMethodCallTime();
        if (this$lastMethodCallTime == null ? other$lastMethodCallTime != null : !((Object)this$lastMethodCallTime).equals(other$lastMethodCallTime)) {
            return false;
        }
        StatusResult this$lastMethodReturnStatus = this.getLastMethodReturnStatus();
        StatusResult other$lastMethodReturnStatus = other.getLastMethodReturnStatus();
        return !(this$lastMethodReturnStatus == null ? other$lastMethodReturnStatus != null : !((Object)this$lastMethodReturnStatus).equals(other$lastMethodReturnStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProgramDiagnosticDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $createSessionId = this.getCreateSessionId();
        result = result * 59 + ($createSessionId == null ? 43 : ((Object)$createSessionId).hashCode());
        String $createClientName = this.getCreateClientName();
        result = result * 59 + ($createClientName == null ? 43 : $createClientName.hashCode());
        DateTime $invocationCreationTime = this.getInvocationCreationTime();
        result = result * 59 + ($invocationCreationTime == null ? 43 : ((Object)$invocationCreationTime).hashCode());
        DateTime $lastTransitionTime = this.getLastTransitionTime();
        result = result * 59 + ($lastTransitionTime == null ? 43 : ((Object)$lastTransitionTime).hashCode());
        String $lastMethodCall = this.getLastMethodCall();
        result = result * 59 + ($lastMethodCall == null ? 43 : $lastMethodCall.hashCode());
        NodeId $lastMethodSessionId = this.getLastMethodSessionId();
        result = result * 59 + ($lastMethodSessionId == null ? 43 : ((Object)$lastMethodSessionId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLastMethodInputArguments());
        result = result * 59 + Arrays.deepHashCode(this.getLastMethodOutputArguments());
        DateTime $lastMethodCallTime = this.getLastMethodCallTime();
        result = result * 59 + ($lastMethodCallTime == null ? 43 : ((Object)$lastMethodCallTime).hashCode());
        StatusResult $lastMethodReturnStatus = this.getLastMethodReturnStatus();
        result = result * 59 + ($lastMethodReturnStatus == null ? 43 : ((Object)$lastMethodReturnStatus).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProgramDiagnosticDataType(createSessionId=" + this.getCreateSessionId() + ", createClientName=" + this.getCreateClientName() + ", invocationCreationTime=" + this.getInvocationCreationTime() + ", lastTransitionTime=" + this.getLastTransitionTime() + ", lastMethodCall=" + this.getLastMethodCall() + ", lastMethodSessionId=" + this.getLastMethodSessionId() + ", lastMethodInputArguments=" + Arrays.deepToString(this.getLastMethodInputArguments()) + ", lastMethodOutputArguments=" + Arrays.deepToString(this.getLastMethodOutputArguments()) + ", lastMethodCallTime=" + this.getLastMethodCallTime() + ", lastMethodReturnStatus=" + this.getLastMethodReturnStatus() + ")";
    }

    private static final class ProgramDiagnosticDataTypeBuilderImpl
    extends ProgramDiagnosticDataTypeBuilder<ProgramDiagnosticDataType, ProgramDiagnosticDataTypeBuilderImpl> {
        private ProgramDiagnosticDataTypeBuilderImpl() {
        }

        @Override
        protected ProgramDiagnosticDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ProgramDiagnosticDataType build() {
            return new ProgramDiagnosticDataType(this);
        }
    }

    public static abstract class ProgramDiagnosticDataTypeBuilder<C extends ProgramDiagnosticDataType, B extends ProgramDiagnosticDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId createSessionId;
        private String createClientName;
        private DateTime invocationCreationTime;
        private DateTime lastTransitionTime;
        private String lastMethodCall;
        private NodeId lastMethodSessionId;
        private Argument[] lastMethodInputArguments;
        private Argument[] lastMethodOutputArguments;
        private DateTime lastMethodCallTime;
        private StatusResult lastMethodReturnStatus;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProgramDiagnosticDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProgramDiagnosticDataType instance, ProgramDiagnosticDataTypeBuilder<?, ?> b) {
            b.createSessionId(instance.createSessionId);
            b.createClientName(instance.createClientName);
            b.invocationCreationTime(instance.invocationCreationTime);
            b.lastTransitionTime(instance.lastTransitionTime);
            b.lastMethodCall(instance.lastMethodCall);
            b.lastMethodSessionId(instance.lastMethodSessionId);
            b.lastMethodInputArguments(instance.lastMethodInputArguments);
            b.lastMethodOutputArguments(instance.lastMethodOutputArguments);
            b.lastMethodCallTime(instance.lastMethodCallTime);
            b.lastMethodReturnStatus(instance.lastMethodReturnStatus);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B createSessionId(NodeId createSessionId) {
            this.createSessionId = createSessionId;
            return (B)this.self();
        }

        public B createClientName(String createClientName) {
            this.createClientName = createClientName;
            return (B)this.self();
        }

        public B invocationCreationTime(DateTime invocationCreationTime) {
            this.invocationCreationTime = invocationCreationTime;
            return (B)this.self();
        }

        public B lastTransitionTime(DateTime lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
            return (B)this.self();
        }

        public B lastMethodCall(String lastMethodCall) {
            this.lastMethodCall = lastMethodCall;
            return (B)this.self();
        }

        public B lastMethodSessionId(NodeId lastMethodSessionId) {
            this.lastMethodSessionId = lastMethodSessionId;
            return (B)this.self();
        }

        public B lastMethodInputArguments(Argument[] lastMethodInputArguments) {
            this.lastMethodInputArguments = lastMethodInputArguments;
            return (B)this.self();
        }

        public B lastMethodOutputArguments(Argument[] lastMethodOutputArguments) {
            this.lastMethodOutputArguments = lastMethodOutputArguments;
            return (B)this.self();
        }

        public B lastMethodCallTime(DateTime lastMethodCallTime) {
            this.lastMethodCallTime = lastMethodCallTime;
            return (B)this.self();
        }

        public B lastMethodReturnStatus(StatusResult lastMethodReturnStatus) {
            this.lastMethodReturnStatus = lastMethodReturnStatus;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProgramDiagnosticDataType.ProgramDiagnosticDataTypeBuilder(super=" + super.toString() + ", createSessionId=" + this.createSessionId + ", createClientName=" + this.createClientName + ", invocationCreationTime=" + this.invocationCreationTime + ", lastTransitionTime=" + this.lastTransitionTime + ", lastMethodCall=" + this.lastMethodCall + ", lastMethodSessionId=" + this.lastMethodSessionId + ", lastMethodInputArguments=" + Arrays.deepToString(this.lastMethodInputArguments) + ", lastMethodOutputArguments=" + Arrays.deepToString(this.lastMethodOutputArguments) + ", lastMethodCallTime=" + this.lastMethodCallTime + ", lastMethodReturnStatus=" + this.lastMethodReturnStatus + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ProgramDiagnosticDataType> {
        @Override
        public Class<ProgramDiagnosticDataType> getType() {
            return ProgramDiagnosticDataType.class;
        }

        @Override
        public ProgramDiagnosticDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId createSessionId = decoder.readNodeId("CreateSessionId");
            String createClientName = decoder.readString("CreateClientName");
            DateTime invocationCreationTime = decoder.readDateTime("InvocationCreationTime");
            DateTime lastTransitionTime = decoder.readDateTime("LastTransitionTime");
            String lastMethodCall = decoder.readString("LastMethodCall");
            NodeId lastMethodSessionId = decoder.readNodeId("LastMethodSessionId");
            Argument[] lastMethodInputArguments = (Argument[])decoder.readStructArray("LastMethodInputArguments", Argument.TYPE_ID);
            Argument[] lastMethodOutputArguments = (Argument[])decoder.readStructArray("LastMethodOutputArguments", Argument.TYPE_ID);
            DateTime lastMethodCallTime = decoder.readDateTime("LastMethodCallTime");
            StatusResult lastMethodReturnStatus = (StatusResult)decoder.readStruct("LastMethodReturnStatus", StatusResult.TYPE_ID);
            return new ProgramDiagnosticDataType(createSessionId, createClientName, invocationCreationTime, lastTransitionTime, lastMethodCall, lastMethodSessionId, lastMethodInputArguments, lastMethodOutputArguments, lastMethodCallTime, lastMethodReturnStatus);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ProgramDiagnosticDataType value) {
            encoder.writeNodeId("CreateSessionId", value.getCreateSessionId());
            encoder.writeString("CreateClientName", value.getCreateClientName());
            encoder.writeDateTime("InvocationCreationTime", value.getInvocationCreationTime());
            encoder.writeDateTime("LastTransitionTime", value.getLastTransitionTime());
            encoder.writeString("LastMethodCall", value.getLastMethodCall());
            encoder.writeNodeId("LastMethodSessionId", value.getLastMethodSessionId());
            encoder.writeStructArray("LastMethodInputArguments", (Object[])value.getLastMethodInputArguments(), Argument.TYPE_ID);
            encoder.writeStructArray("LastMethodOutputArguments", (Object[])value.getLastMethodOutputArguments(), Argument.TYPE_ID);
            encoder.writeDateTime("LastMethodCallTime", value.getLastMethodCallTime());
            encoder.writeStruct("LastMethodReturnStatus", (Object)value.getLastMethodReturnStatus(), StatusResult.TYPE_ID);
        }
    }
}

