/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoredItemNotification
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=806");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=808");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=807");
    private final UInteger clientHandle;
    private final DataValue value;

    public MonitoredItemNotification(UInteger clientHandle, DataValue value) {
        this.clientHandle = clientHandle;
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public DataValue getValue() {
        return this.value;
    }

    protected MonitoredItemNotification(MonitoredItemNotificationBuilder<?, ?> b) {
        super(b);
        this.clientHandle = ((MonitoredItemNotificationBuilder)b).clientHandle;
        this.value = ((MonitoredItemNotificationBuilder)b).value;
    }

    public static MonitoredItemNotificationBuilder<?, ?> builder() {
        return new MonitoredItemNotificationBuilderImpl();
    }

    public MonitoredItemNotificationBuilder<?, ?> toBuilder() {
        return new MonitoredItemNotificationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoredItemNotification)) {
            return false;
        }
        MonitoredItemNotification other = (MonitoredItemNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$clientHandle = this.getClientHandle();
        UInteger other$clientHandle = other.getClientHandle();
        if (this$clientHandle == null ? other$clientHandle != null : !((Object)this$clientHandle).equals(other$clientHandle)) {
            return false;
        }
        DataValue this$value = this.getValue();
        DataValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoredItemNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $clientHandle = this.getClientHandle();
        result = result * 59 + ($clientHandle == null ? 43 : ((Object)$clientHandle).hashCode());
        DataValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoredItemNotification(clientHandle=" + this.getClientHandle() + ", value=" + this.getValue() + ")";
    }

    private static final class MonitoredItemNotificationBuilderImpl
    extends MonitoredItemNotificationBuilder<MonitoredItemNotification, MonitoredItemNotificationBuilderImpl> {
        private MonitoredItemNotificationBuilderImpl() {
        }

        @Override
        protected MonitoredItemNotificationBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoredItemNotification build() {
            return new MonitoredItemNotification(this);
        }
    }

    public static abstract class MonitoredItemNotificationBuilder<C extends MonitoredItemNotification, B extends MonitoredItemNotificationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger clientHandle;
        private DataValue value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoredItemNotificationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoredItemNotification instance, MonitoredItemNotificationBuilder<?, ?> b) {
            b.clientHandle(instance.clientHandle);
            b.value(instance.value);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B clientHandle(UInteger clientHandle) {
            this.clientHandle = clientHandle;
            return (B)this.self();
        }

        public B value(DataValue value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoredItemNotification.MonitoredItemNotificationBuilder(super=" + super.toString() + ", clientHandle=" + this.clientHandle + ", value=" + this.value + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoredItemNotification> {
        @Override
        public Class<MonitoredItemNotification> getType() {
            return MonitoredItemNotification.class;
        }

        @Override
        public MonitoredItemNotification decode(SerializationContext context, UaDecoder decoder) {
            UInteger clientHandle = decoder.readUInt32("ClientHandle");
            DataValue value = decoder.readDataValue("Value");
            return new MonitoredItemNotification(clientHandle, value);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoredItemNotification value) {
            encoder.writeUInt32("ClientHandle", value.getClientHandle());
            encoder.writeDataValue("Value", value.getValue());
        }
    }
}

