/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.quota.PostgresQuotaCurrentValueDAO;
import org.apache.james.backends.postgres.quota.PostgresQuotaDataDefinition;
import org.apache.james.backends.postgres.quota.PostgresQuotaLimitDAO;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.postgres.PostgresDomainList;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class PostgresQuotaGuiceModule
extends AbstractModule {
    public void configure() {
        this.bind(PostgresQuotaCurrentValueDAO.class).in(Scopes.SINGLETON);
        this.bind(PostgresQuotaLimitDAO.class).in(Scopes.SINGLETON);
        Multibinder postgresDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class);
        postgresDataDefinitions.addBinding().toInstance((Object)PostgresQuotaDataDefinition.MODULE);
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration configuration, PostgresDomainList postgresDomainList) {
        return InitilizationOperationBuilder.forClass(PostgresDomainList.class).init(() -> postgresDomainList.configure(configuration));
    }
}

