/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SoftDeletedEntryAccessRequestControl
extends Control {
    @NotNull
    public static final String SOFT_DELETED_ENTRY_ACCESS_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.24";
    private static final byte TYPE_INCLUDE_NON_SOFT_DELETED_ENTRIES = -128;
    private static final byte TYPE_RETURN_ENTRIES_IN_UNDELETED_FORM = -127;
    @NotNull
    private static final String JSON_FIELD_INCLUDE_NON_SOFT_DELETED_ENTRIES = "include-non-soft-deleted-entries";
    @NotNull
    private static final String JSON_FIELD_RETURN_ENTRIES_IN_UNDELETED_FORM = "return-entries-in-undeleted-form";
    private static final long serialVersionUID = -3633807543861389512L;
    private final boolean includeNonSoftDeletedEntries;
    private final boolean returnEntriesInUndeletedForm;

    public SoftDeletedEntryAccessRequestControl() {
        this(false, true, false);
    }

    public SoftDeletedEntryAccessRequestControl(boolean isCritical, boolean includeNonSoftDeletedEntries, boolean returnEntriesInUndeletedForm) {
        super(SOFT_DELETED_ENTRY_ACCESS_REQUEST_OID, isCritical, SoftDeletedEntryAccessRequestControl.encodeValue(includeNonSoftDeletedEntries, returnEntriesInUndeletedForm));
        this.includeNonSoftDeletedEntries = includeNonSoftDeletedEntries;
        this.returnEntriesInUndeletedForm = returnEntriesInUndeletedForm;
    }

    public SoftDeletedEntryAccessRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        boolean includeNonSoftDeleted = true;
        boolean returnAsUndeleted = false;
        if (control.hasValue()) {
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(control.getValue().getValue());
                block7: for (ASN1Element e : valueSequence.elements()) {
                    switch (e.getType()) {
                        case -128: {
                            includeNonSoftDeleted = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                            continue block7;
                        }
                        case -127: {
                            returnAsUndeleted = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                            continue block7;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETED_ACCESS_REQUEST_UNSUPPORTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                        }
                    }
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETED_ACCESS_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.includeNonSoftDeletedEntries = includeNonSoftDeleted;
        this.returnEntriesInUndeletedForm = returnAsUndeleted;
    }

    @Nullable
    private static ASN1OctetString encodeValue(boolean includeNonSoftDeletedEntries, boolean returnEntriesInUndeletedForm) {
        if (includeNonSoftDeletedEntries && !returnEntriesInUndeletedForm) {
            return null;
        }
        ArrayList<ASN1Boolean> elements = new ArrayList<ASN1Boolean>(2);
        if (!includeNonSoftDeletedEntries) {
            elements.add(new ASN1Boolean(-128, false));
        }
        if (returnEntriesInUndeletedForm) {
            elements.add(new ASN1Boolean(-127, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public boolean includeNonSoftDeletedEntries() {
        return this.includeNonSoftDeletedEntries;
    }

    public boolean returnEntriesInUndeletedForm() {
        return this.returnEntriesInUndeletedForm;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SOFT_DELETED_ACCESS_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", SOFT_DELETED_ENTRY_ACCESS_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SOFT_DELETED_ACCESS_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_INCLUDE_NON_SOFT_DELETED_ENTRIES, this.includeNonSoftDeletedEntries), new JSONField(JSON_FIELD_RETURN_ENTRIES_IN_UNDELETED_FORM, this.returnEntriesInUndeletedForm))));
    }

    @NotNull
    public static SoftDeletedEntryAccessRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new SoftDeletedEntryAccessRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Boolean includeNonSoftDeletedEntries = valueObject.getFieldAsBoolean(JSON_FIELD_INCLUDE_NON_SOFT_DELETED_ENTRIES);
        if (includeNonSoftDeletedEntries == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETED_ACCESS_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_INCLUDE_NON_SOFT_DELETED_ENTRIES));
        }
        Boolean returnEntriesInUndeletedForm = valueObject.getFieldAsBoolean(JSON_FIELD_RETURN_ENTRIES_IN_UNDELETED_FORM);
        if (returnEntriesInUndeletedForm == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETED_ACCESS_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_RETURN_ENTRIES_IN_UNDELETED_FORM));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_INCLUDE_NON_SOFT_DELETED_ENTRIES, JSON_FIELD_RETURN_ENTRIES_IN_UNDELETED_FORM)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETED_ACCESS_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new SoftDeletedEntryAccessRequestControl(jsonControl.getCriticality(), (boolean)includeNonSoftDeletedEntries, returnEntriesInUndeletedForm);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SoftDeletedEntryAccessRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", includeNonSoftDeletedEntries=");
        buffer.append(this.includeNonSoftDeletedEntries);
        buffer.append(", returnEntriesInUndeletedForm=");
        buffer.append(this.returnEntriesInUndeletedForm);
        buffer.append(')');
    }
}

