/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;

public enum SubtreeAccessibilityState {
    ACCESSIBLE(0, "accessible"),
    READ_ONLY_BIND_ALLOWED(1, "read-only-bind-allowed"),
    READ_ONLY_BIND_DENIED(2, "read-only-bind-denied"),
    HIDDEN(3, "hidden"),
    TO_BE_DELETED(4, "to-be-deleted");

    private final int intValue;
    @NotNull
    private final String stateName;

    private SubtreeAccessibilityState(int intValue, String stateName) {
        this.intValue = intValue;
        this.stateName = stateName;
    }

    public int intValue() {
        return this.intValue;
    }

    @NotNull
    public String getStateName() {
        return this.stateName;
    }

    public boolean isAccessible() {
        return this == ACCESSIBLE;
    }

    public boolean isHidden() {
        return this == HIDDEN || this == TO_BE_DELETED;
    }

    public boolean isReadOnly() {
        return this == READ_ONLY_BIND_ALLOWED || this == READ_ONLY_BIND_DENIED;
    }

    public boolean isToBeDeleted() {
        return this == TO_BE_DELETED;
    }

    public boolean isMoreRestrictiveThan(@NotNull SubtreeAccessibilityState state) {
        switch (this) {
            case TO_BE_DELETED: {
                return state != TO_BE_DELETED;
            }
            case HIDDEN: {
                return state != TO_BE_DELETED && state != HIDDEN;
            }
            case READ_ONLY_BIND_DENIED: {
                return state != TO_BE_DELETED && state != HIDDEN && state != READ_ONLY_BIND_DENIED;
            }
            case READ_ONLY_BIND_ALLOWED: {
                return state != TO_BE_DELETED && state != HIDDEN && state != READ_ONLY_BIND_DENIED && state != READ_ONLY_BIND_ALLOWED;
            }
        }
        return false;
    }

    @Nullable
    public static SubtreeAccessibilityState valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return ACCESSIBLE;
            }
            case 1: {
                return READ_ONLY_BIND_ALLOWED;
            }
            case 2: {
                return READ_ONLY_BIND_DENIED;
            }
            case 3: {
                return HIDDEN;
            }
            case 4: {
                return TO_BE_DELETED;
            }
        }
        return null;
    }

    @Nullable
    public static SubtreeAccessibilityState forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "accessible": {
                return ACCESSIBLE;
            }
            case "readonlybindallowed": 
            case "read-only-bind-allowed": 
            case "read_only_bind_allowed": {
                return READ_ONLY_BIND_ALLOWED;
            }
            case "readonlybinddenied": 
            case "read-only-bind-denied": 
            case "read_only_bind_denied": {
                return READ_ONLY_BIND_DENIED;
            }
            case "hidden": {
                return HIDDEN;
            }
            case "tobedeleted": 
            case "to-be-deleted": 
            case "to_be_deleted": {
                return TO_BE_DELETED;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.stateName;
    }
}

