/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.retry;

import apache.rocketmq.v2.ExponentialBackoff;
import apache.rocketmq.v2.RetryPolicy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import org.apache.rocketmq.client.java.retry.RetryPolicy;

public class ExponentialBackoffRetryPolicy
implements RetryPolicy {
    private final int maxAttempts;
    private final java.time.Duration initialBackoff;
    private final java.time.Duration maxBackoff;
    private final double backoffMultiplier;

    public ExponentialBackoffRetryPolicy(int maxAttempts, java.time.Duration initialBackoff, java.time.Duration maxBackoff, double backoffMultiplier) {
        this.maxAttempts = maxAttempts;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.backoffMultiplier = backoffMultiplier;
    }

    public static ExponentialBackoffRetryPolicy immediatelyRetryPolicy(int maxAttempts) {
        return new ExponentialBackoffRetryPolicy(maxAttempts, java.time.Duration.ZERO, java.time.Duration.ZERO, 1.0);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public java.time.Duration getNextAttemptDelay(int attempt) {
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt must be positive");
        double delayNanos = Math.min((double)this.initialBackoff.toNanos() * Math.pow(this.backoffMultiplier, 1.0 * (double)(attempt - 1)), (double)this.maxBackoff.toNanos());
        if (delayNanos <= 0.0) {
            return java.time.Duration.ZERO;
        }
        return java.time.Duration.ofNanos((long)delayNanos);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxAttempts", this.maxAttempts).add("initialBackoff", (Object)this.initialBackoff).add("maxBackoff", (Object)this.maxBackoff).add("backoffMultiplier", this.backoffMultiplier).toString();
    }

    public static ExponentialBackoffRetryPolicy fromProtobuf(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.EXPONENTIAL_BACKOFF.equals((Object)retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException();
        }
        ExponentialBackoff exponentialBackoff = retryPolicy.getExponentialBackoff();
        return new ExponentialBackoffRetryPolicy(retryPolicy.getMaxAttempts(), java.time.Duration.ofNanos(Durations.toNanos((Duration)exponentialBackoff.getInitial())), java.time.Duration.ofNanos(Durations.toNanos((Duration)exponentialBackoff.getMax())), exponentialBackoff.getMultiplier());
    }

    @Override
    public RetryPolicy updateBackoff(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.EXPONENTIAL_BACKOFF.equals((Object)retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException("strategy must be exponential backoff");
        }
        return this.updateBackoff(retryPolicy.getExponentialBackoff());
    }

    private RetryPolicy updateBackoff(ExponentialBackoff backoff) {
        return new ExponentialBackoffRetryPolicy(this.maxAttempts, java.time.Duration.ofNanos(Durations.toNanos((Duration)backoff.getInitial())), java.time.Duration.ofNanos(Durations.toNanos((Duration)backoff.getMax())), backoff.getMultiplier());
    }

    @Override
    public apache.rocketmq.v2.RetryPolicy toProtobuf() {
        ExponentialBackoff exponentialBackoff = ExponentialBackoff.newBuilder().setMultiplier((float)this.backoffMultiplier).setMax(Durations.fromNanos((long)this.maxBackoff.toNanos())).setInitial(Durations.fromNanos((long)this.initialBackoff.toNanos())).build();
        return apache.rocketmq.v2.RetryPolicy.newBuilder().setMaxAttempts(this.maxAttempts).setExponentialBackoff(exponentialBackoff).build();
    }
}

