/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.retry;

import apache.rocketmq.v2.CustomizedBackoff;
import apache.rocketmq.v2.RetryPolicy;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Durations;

public class CustomizedBackoffRetryPolicy
implements RetryPolicy {
    private final List<Duration> durations;
    private final int maxAttempts;

    public CustomizedBackoffRetryPolicy(List<Duration> durations, int maxAttempts) {
        Preconditions.checkArgument(!durations.isEmpty(), "durations must not be empty");
        this.durations = durations;
        this.maxAttempts = maxAttempts;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    List<Duration> getDurations() {
        return this.durations;
    }

    @Override
    public Duration getNextAttemptDelay(int attempt) {
        Preconditions.checkArgument(attempt > 0, "attempt must be positive");
        return attempt > this.durations.size() ? this.durations.get(this.durations.size() - 1) : this.durations.get(attempt - 1);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("durations", this.durations).add("maxAttempts", this.maxAttempts).toString();
    }

    public static CustomizedBackoffRetryPolicy fromProtobuf(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.CUSTOMIZED_BACKOFF.equals(retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException();
        }
        CustomizedBackoff customizedBackoff = retryPolicy.getCustomizedBackoff();
        List<Duration> durations = customizedBackoff.getNextList().stream().map(duration -> Duration.ofNanos(Durations.toNanos(duration))).collect(Collectors.toList());
        return new CustomizedBackoffRetryPolicy(durations, retryPolicy.getMaxAttempts());
    }

    @Override
    public RetryPolicy inheritBackoff(apache.rocketmq.v2.RetryPolicy retryPolicy) {
        if (!RetryPolicy.StrategyCase.CUSTOMIZED_BACKOFF.equals(retryPolicy.getStrategyCase())) {
            throw new IllegalArgumentException("strategy must be customized backoff");
        }
        return this.inheritBackoff(retryPolicy.getCustomizedBackoff());
    }

    private RetryPolicy inheritBackoff(CustomizedBackoff backoff) {
        List<Duration> durations = backoff.getNextList().stream().map(duration -> Duration.ofNanos(Durations.toNanos(duration))).collect(Collectors.toList());
        return new CustomizedBackoffRetryPolicy(durations, this.maxAttempts);
    }

    @Override
    public apache.rocketmq.v2.RetryPolicy toProtobuf() {
        CustomizedBackoff customizedBackoff = CustomizedBackoff.newBuilder().addAllNext(this.durations.stream().map(duration -> Durations.fromNanos(duration.toNanos())).collect(Collectors.toList())).build();
        return apache.rocketmq.v2.RetryPolicy.newBuilder().setMaxAttempts(this.maxAttempts).setCustomizedBackoff(customizedBackoff).build();
    }
}

