/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.exception;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.ForbiddenException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.NotFoundException;
import org.apache.rocketmq.client.java.exception.PayloadTooLargeException;
import org.apache.rocketmq.client.java.exception.PaymentRequiredException;
import org.apache.rocketmq.client.java.exception.ProxyTimeoutException;
import org.apache.rocketmq.client.java.exception.RequestHeaderFieldsTooLargeException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.exception.UnauthorizedException;
import org.apache.rocketmq.client.java.exception.UnsupportedException;
import org.apache.rocketmq.client.java.misc.MetadataUtils;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class StatusChecker {
    private static final Logger log = LoggerFactory.getLogger(StatusChecker.class);

    private StatusChecker() {
    }

    public static void check(Status status, RpcFuture<?, ?> future) throws ClientException {
        String requestId = future.getContext().getRequestId();
        Code code = status.getCode();
        int codeNumber = code.getNumber();
        String statusMessage = status.getMessage();
        switch (code) {
            case OK: 
            case MULTIPLE_RESULTS: {
                return;
            }
            case BAD_REQUEST: 
            case ILLEGAL_ACCESS_POINT: 
            case ILLEGAL_TOPIC: 
            case ILLEGAL_CONSUMER_GROUP: 
            case ILLEGAL_MESSAGE_TAG: 
            case ILLEGAL_MESSAGE_KEY: 
            case ILLEGAL_MESSAGE_GROUP: 
            case ILLEGAL_MESSAGE_PROPERTY_KEY: 
            case INVALID_TRANSACTION_ID: 
            case ILLEGAL_MESSAGE_ID: 
            case ILLEGAL_FILTER_EXPRESSION: 
            case ILLEGAL_INVISIBLE_TIME: 
            case ILLEGAL_DELIVERY_TIME: 
            case INVALID_RECEIPT_HANDLE: 
            case MESSAGE_PROPERTY_CONFLICT_WITH_TYPE: 
            case UNRECOGNIZED_CLIENT_TYPE: 
            case MESSAGE_CORRUPTED: 
            case CLIENT_ID_REQUIRED: 
            case ILLEGAL_POLLING_TIME: {
                throw new BadRequestException(codeNumber, requestId, statusMessage);
            }
            case UNAUTHORIZED: {
                throw new UnauthorizedException(codeNumber, requestId, statusMessage);
            }
            case PAYMENT_REQUIRED: {
                throw new PaymentRequiredException(codeNumber, requestId, statusMessage);
            }
            case FORBIDDEN: {
                throw new ForbiddenException(codeNumber, requestId, statusMessage);
            }
            case MESSAGE_NOT_FOUND: {
                if (future.getRequest() instanceof ReceiveMessageRequest) {
                    return;
                }
            }
            case NOT_FOUND: 
            case TOPIC_NOT_FOUND: 
            case CONSUMER_GROUP_NOT_FOUND: {
                throw new NotFoundException(codeNumber, requestId, statusMessage);
            }
            case PAYLOAD_TOO_LARGE: 
            case MESSAGE_BODY_TOO_LARGE: {
                throw new PayloadTooLargeException(codeNumber, requestId, statusMessage);
            }
            case TOO_MANY_REQUESTS: {
                throw new TooManyRequestsException(codeNumber, requestId, statusMessage);
            }
            case REQUEST_HEADER_FIELDS_TOO_LARGE: 
            case MESSAGE_PROPERTIES_TOO_LARGE: {
                throw new RequestHeaderFieldsTooLargeException(codeNumber, requestId, statusMessage);
            }
            case INTERNAL_ERROR: 
            case INTERNAL_SERVER_ERROR: 
            case HA_NOT_AVAILABLE: {
                throw new InternalErrorException(codeNumber, requestId, statusMessage);
            }
            case PROXY_TIMEOUT: 
            case MASTER_PERSISTENCE_TIMEOUT: 
            case SLAVE_PERSISTENCE_TIMEOUT: {
                throw new ProxyTimeoutException(codeNumber, requestId, statusMessage);
            }
            case UNSUPPORTED: 
            case VERSION_UNSUPPORTED: 
            case VERIFY_FIFO_MESSAGE_UNSUPPORTED: {
                throw new UnsupportedException(codeNumber, requestId, statusMessage);
            }
        }
        log.warn("Unrecognized status code={}, requestId={}, statusMessage={}, clientVersion={}", codeNumber, requestId, statusMessage, MetadataUtils.getVersion());
        throw new UnsupportedException(codeNumber, requestId, statusMessage);
    }
}

