/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl.engine;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.JakartaAuthenticationFeedbackHandler;
import org.apache.sling.engine.auth.AuthenticationHandler;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.osgi.framework.ServiceReference;

public final class EngineAuthenticationHandlerHolder
extends AbstractAuthenticationHandlerHolder {
    private final AuthenticationHandler handler;

    public EngineAuthenticationHandlerHolder(String fullPath, AuthenticationHandler handler, ServiceReference<?> serviceReference) {
        super(fullPath, serviceReference);
        this.handler = handler;
    }

    @Override
    protected JakartaAuthenticationFeedbackHandler getFeedbackHandler() {
        if (this.handler instanceof AuthenticationFeedbackHandler) {
            return new JakartaAuthenticationFeedbackHandler(){

                @Override
                public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, org.apache.sling.auth.core.spi.AuthenticationInfo authInfo) {
                    ((AuthenticationFeedbackHandler)((Object)EngineAuthenticationHandlerHolder.this.handler)).authenticationFailed(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response), authInfo);
                }

                @Override
                public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, org.apache.sling.auth.core.spi.AuthenticationInfo authInfo) {
                    return ((AuthenticationFeedbackHandler)((Object)EngineAuthenticationHandlerHolder.this.handler)).authenticationSucceeded(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response), authInfo);
                }
            };
        }
        return null;
    }

    @Override
    public org.apache.sling.auth.core.spi.AuthenticationInfo doExtractCredentials(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo engineAuthInfo = this.handler.authenticate(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response));
        if (engineAuthInfo == null) {
            return null;
        }
        if (engineAuthInfo == AuthenticationInfo.DOING_AUTH) {
            return org.apache.sling.auth.core.spi.AuthenticationInfo.DOING_AUTH;
        }
        org.apache.sling.auth.core.spi.AuthenticationInfo info = new org.apache.sling.auth.core.spi.AuthenticationInfo(engineAuthInfo.getAuthType());
        info.put("user.jcr.credentials", (Object)engineAuthInfo.getCredentials());
        info.put("user.jcr.workspace", (Object)engineAuthInfo.getWorkspaceName());
        return info;
    }

    @Override
    public boolean doRequestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.handler.requestAuthentication(JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((HttpServletResponse)response));
    }

    @Override
    public void doDropCredentials(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.handler);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EngineAuthenticationHandlerHolder other = (EngineAuthenticationHandlerHolder)obj;
        return Objects.equals(this.handler, other.handler);
    }

    public String toString() {
        return this.handler.toString() + " (Legacy API Handler)";
    }
}

