/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.ScriptCacheImplConfiguration;
import org.apache.sling.scripting.core.impl.helper.CachingMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ScriptCache.class})
@Designate(ocd=ScriptCacheImplConfiguration.class)
public class ScriptCacheImpl
implements ScriptCache {
    private final Logger logger = LoggerFactory.getLogger(ScriptCacheImpl.class);
    public static final int DEFAULT_CACHE_SIZE = 65536;
    private final Map<String, SoftReference<CachedScript>> internalMap;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();

    @Activate
    public ScriptCacheImpl(ScriptCacheImplConfiguration configuration) {
        this.internalMap = new CachingMap<CachedScript>(configuration.org_apache_sling_scripting_cache_size());
    }

    public CachedScript getScript(String scriptPath) {
        this.readLock.lock();
        SoftReference<CachedScript> reference = null;
        try {
            reference = this.internalMap.get(scriptPath);
        }
        finally {
            this.readLock.unlock();
        }
        return reference != null ? reference.get() : null;
    }

    public void putScript(CachedScript script) {
        this.writeLock.lock();
        try {
            SoftReference<CachedScript> reference = new SoftReference<CachedScript>(script);
            this.internalMap.put(script.getScriptPath(), reference);
            this.logger.debug("Added script {} to script cache.", (Object)script.getScriptPath());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.internalMap.clear();
            this.logger.debug("Cleared script cache.");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeScript(String scriptPath) {
        this.writeLock.lock();
        try {
            boolean result;
            boolean bl = result = this.internalMap.remove(scriptPath) != null;
            if (result) {
                this.logger.debug("Removed script {} from script cache.", (Object)scriptPath);
            } else {
                String prefix = scriptPath.concat("/");
                HashSet<String> removal = new HashSet<String>();
                for (Map.Entry<String, SoftReference<CachedScript>> entry : this.internalMap.entrySet()) {
                    if (!entry.getKey().startsWith(prefix)) continue;
                    removal.add(entry.getKey());
                }
                for (String key : removal) {
                    this.internalMap.remove(key);
                    this.logger.debug("Detected removal for {} - removed entry {} from the cache.", (Object)scriptPath, (Object)key);
                    result = true;
                }
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected List<String> getCachedScripts() {
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.internalMap.keySet());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

