/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.net.URL;
import java.util.Hashtable;
import org.apache.stylebook.BasicParameters;
import org.apache.stylebook.ComponentFactory;
import org.apache.stylebook.Engine;
import org.apache.stylebook.InitializationException;
import org.apache.stylebook.Logger;
import org.apache.stylebook.NodeListParameters;
import org.apache.stylebook.Parser;
import org.apache.stylebook.Printer;
import org.apache.stylebook.Processor;
import org.apache.stylebook.Producer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicEngine
implements Engine {
    private Parser parser = null;
    private Hashtable producers = new Hashtable();
    private Hashtable processors = new Hashtable();
    private Hashtable printers = new Hashtable();
    private Logger logger = null;
    private boolean debug = false;

    public BasicEngine(String string, URL uRL, Logger logger) throws InitializationException {
        if (logger == null) {
            throw new InitializationException("No Logger instance specified");
        }
        this.logger = logger;
        Parser parser = ComponentFactory.getParser(string);
        parser.init(this, new BasicParameters());
        Document document = null;
        try {
            document = parser.parse(uRL);
            if (document == null) {
                throw new InitializationException("Parser returned null doc");
            }
        }
        catch (Exception exception) {
            throw new InitializationException("Cannot parse configurations \"" + uRL + "\"");
        }
        this.logger.log(this, "Initializing");
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("engine")) {
            throw new InitializationException("Conf don't begin with <engine>");
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                Element element2 = (Element)nodeList.item(n);
                String string2 = element2.getTagName();
                if (string2.equals("debug")) {
                    this.debug = element2.getAttribute("enabled").equalsIgnoreCase("true");
                } else if (string2.equals("parser")) {
                    this.configureParser(element2);
                } else if (string2.equals("producer")) {
                    this.configureProducer(element2);
                } else if (string2.equals("processor")) {
                    this.configureProcessor(element2);
                } else if (string2.equals("printer")) {
                    this.configurePrinter(element2);
                } else {
                    throw new InitializationException("Unknown Element <" + string2 + ">");
                }
            }
            ++n;
        }
        if (this.parser == null) {
            this.parser = parser;
        }
    }

    private void configureParser(Element element) throws InitializationException {
        if (this.parser != null) {
            throw new InitializationException("Parser already configured");
        }
        String string = element.getAttribute("class");
        this.parser = ComponentFactory.getParser(string);
        this.parser.init(this, new NodeListParameters(element.getChildNodes()));
    }

    private void configurePrinter(Element element) throws InitializationException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("class");
        if (string.length() == 0) {
            throw new InitializationException("No name specified for Printer");
        }
        Printer printer = ComponentFactory.getPrinter(string2);
        printer.init(this, new NodeListParameters(element.getChildNodes()));
        if (this.printers.put(string, printer) != null) {
            throw new InitializationException("Duplucate Printer \"" + string + "\"");
        }
    }

    private void configureProcessor(Element element) throws InitializationException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("class");
        if (string.length() == 0) {
            throw new InitializationException("No name specified for Processor");
        }
        Processor processor = ComponentFactory.getProcessor(string2);
        processor.init(this, new NodeListParameters(element.getChildNodes()));
        if (this.processors.put(string, processor) != null) {
            throw new InitializationException("Duplucate Processor \"" + string + "\"");
        }
    }

    private void configureProducer(Element element) throws InitializationException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("class");
        if (string.length() == 0) {
            throw new InitializationException("No name specified for Producer");
        }
        Producer producer = ComponentFactory.getProducer(string2);
        producer.init(this, new NodeListParameters(element.getChildNodes()));
        if (this.producers.put(string, producer) != null) {
            throw new InitializationException("Duplucate Producer \"" + string + "\"");
        }
    }

    public void debug(Object object, String string) {
        if (this.debug) {
            this.logger.log(object, string);
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    public Printer getPrinter(String string) {
        return (Printer)this.printers.get(string);
    }

    public Processor getProcessor(String string) {
        return (Processor)this.processors.get(string);
    }

    public Producer getProducer(String string) {
        return (Producer)this.producers.get(string);
    }

    public void log(Object object, String string) {
        this.logger.log(object, string);
    }
}

