# v2.12 to 2.13

## Upgraded Helm Version

Note that bundled Helm version has been upgraded from 3.15.2 to 3.15.4.

## Custom Resource Actions for Flux Resources

[`Custom Resource Actions`](../resource_actions.md#Custom-Resource-Actions) have been added for Flux Resources.  
The following actions are now available:

| Custom Resource       | Supported Actions                |
|-----------------------|----------------------------------|
| HelmRelease           | `Suspend`, `Resume`, `Reconcile` |
| ImageRepository       | `Suspend`, `Resume`, `Reconcile` |
| ImageUpdateAutomation | `Suspend`, `Resume`, `Reconcile` |
| Kustomization         | `Suspend`, `Resume`, `Reconcile` |
| Alert                 | `Suspend`, `Resume`              |
| Provider              | `Suspend`, `Resume`              |
| Receiver              | `Suspend`, `Resume`, `Reconcile` |
| Bucket                | `Suspend`, `Resume`, `Reconcile` |
| GitRepository         | `Suspend`, `Resume`, `Reconcile` |
| HelmChart             | `Suspend`, `Resume`, `Reconcile` |
| HelmRepository        | `Suspend`, `Resume`, `Reconcile` |
| OCIRepository         | `Suspend`, `Resume`, `Reconcile` |

If you want to use these actions do not forget to update the permissions (RBAC) for your Argo CD instance.

## Custom Resource Health for Flux Resources

[`Custom Resource Health`](../health.md#custom-health-checks) has been added for Flux Resources.  
The following Flux resources now support health checks:
- HelmRelease
- ImagePolicy
- ImageRepository
- ImageUpdateAutomation
- Kustomization
- Receiver
- Bucket
- GitRepository
- HelmChart
- HelmRepository
- OCIRepository

## Upgraded Dex Version

Dex [v2.39.0](https://github.com/dexidp/dex/releases/tag/v2.39.0) included a breaking change for the LDAP connector:

> The validation of username and password in the LDAP connector is much more strict now.
> As of today, Dex uses the EscapeFilter function to check for special characters in credentials and prevent injections by denying such requests.

## Updated Job name for manually started CronJob jobs

The naming of Jobs that are manually started from CronJobs (using Argo CD) was changed. Instead of the previous postfix `-YYYYMMDDHHmm` (4-digit year), manually started Jobs now receive postfix `-YYMMDDHHmm` (2-digit year).

The format of Jobs that are started from a CronJob on schedule (by Kubernetes) is not handled by Argo CD and remains unchanged.

## Change in Log File Extension for Downloaded Logs

The default extension for log files generated by Argo CD when using the "Download Logs" feature has been changed from `.txt` to `.log`. This change aligns with industry standards and improves compatibility with various log management tools and IDEs that offer enhanced features for `.log` files.

**Impact:**
- Users and systems that rely on the `.txt` extension will need to adjust their workflows.
- Automated scripts and processes that specifically target `.txt` log files should be updated to handle `.log` files.

**Benefits:**
- Improved readability and parsing in IDEs and log management tools.
- Consistency with standard log file conventions.

If you have any custom scripts or tools that depend on the `.txt` extension, please update them accordingly.
## Added proxy to kustomize

Proxy config set on repository credentials / repository templates is now passed down to the `kustomize build` command. 
