// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetHealthParams creates a new GetHealthParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetHealthParams() *GetHealthParams {
	return &GetHealthParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetHealthParamsWithTimeout creates a new GetHealthParams object
// with the ability to set a timeout on a request.
func NewGetHealthParamsWithTimeout(timeout time.Duration) *GetHealthParams {
	return &GetHealthParams{
		timeout: timeout,
	}
}

// NewGetHealthParamsWithContext creates a new GetHealthParams object
// with the ability to set a context for a request.
func NewGetHealthParamsWithContext(ctx context.Context) *GetHealthParams {
	return &GetHealthParams{
		Context: ctx,
	}
}

// NewGetHealthParamsWithHTTPClient creates a new GetHealthParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetHealthParamsWithHTTPClient(client *http.Client) *GetHealthParams {
	return &GetHealthParams{
		HTTPClient: client,
	}
}

/*
GetHealthParams contains all the parameters to send to the API endpoint

	for the get health operation.

	Typically these are written to a http.Request.
*/
type GetHealthParams struct {

	/* Brief.

	   Brief is a brief representation of the Cilium status.

	*/
	Brief *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get health params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHealthParams) WithDefaults() *GetHealthParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get health params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHealthParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get health params
func (o *GetHealthParams) WithTimeout(timeout time.Duration) *GetHealthParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get health params
func (o *GetHealthParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get health params
func (o *GetHealthParams) WithContext(ctx context.Context) *GetHealthParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get health params
func (o *GetHealthParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get health params
func (o *GetHealthParams) WithHTTPClient(client *http.Client) *GetHealthParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get health params
func (o *GetHealthParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBrief adds the brief to the get health params
func (o *GetHealthParams) WithBrief(brief *bool) *GetHealthParams {
	o.SetBrief(brief)
	return o
}

// SetBrief adds the brief to the get health params
func (o *GetHealthParams) SetBrief(brief *bool) {
	o.Brief = brief
}

// WriteToRequest writes these params to a swagger request
func (o *GetHealthParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Brief != nil {

		// header param brief
		if err := r.SetHeaderParam("brief", swag.FormatBool(*o.Brief)); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
