// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumL2AnnouncementPoliciesGetter has a method to return a CiliumL2AnnouncementPolicyInterface.
// A group's client should implement this interface.
type CiliumL2AnnouncementPoliciesGetter interface {
	CiliumL2AnnouncementPolicies() CiliumL2AnnouncementPolicyInterface
}

// CiliumL2AnnouncementPolicyInterface has methods to work with CiliumL2AnnouncementPolicy resources.
type CiliumL2AnnouncementPolicyInterface interface {
	Create(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.CreateOptions) (*v2alpha1.CiliumL2AnnouncementPolicy, error)
	Update(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.UpdateOptions) (*v2alpha1.CiliumL2AnnouncementPolicy, error)
	UpdateStatus(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.UpdateOptions) (*v2alpha1.CiliumL2AnnouncementPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumL2AnnouncementPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumL2AnnouncementPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error)
	CiliumL2AnnouncementPolicyExpansion
}

// ciliumL2AnnouncementPolicies implements CiliumL2AnnouncementPolicyInterface
type ciliumL2AnnouncementPolicies struct {
	client rest.Interface
}

// newCiliumL2AnnouncementPolicies returns a CiliumL2AnnouncementPolicies
func newCiliumL2AnnouncementPolicies(c *CiliumV2alpha1Client) *ciliumL2AnnouncementPolicies {
	return &ciliumL2AnnouncementPolicies{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumL2AnnouncementPolicy, and returns the corresponding ciliumL2AnnouncementPolicy object, and an error if there is any.
func (c *ciliumL2AnnouncementPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error) {
	result = &v2alpha1.CiliumL2AnnouncementPolicy{}
	err = c.client.Get().
		Resource("ciliuml2announcementpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumL2AnnouncementPolicies that match those selectors.
func (c *ciliumL2AnnouncementPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumL2AnnouncementPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumL2AnnouncementPolicyList{}
	err = c.client.Get().
		Resource("ciliuml2announcementpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumL2AnnouncementPolicies.
func (c *ciliumL2AnnouncementPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliuml2announcementpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumL2AnnouncementPolicy and creates it.  Returns the server's representation of the ciliumL2AnnouncementPolicy, and an error, if there is any.
func (c *ciliumL2AnnouncementPolicies) Create(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.CreateOptions) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error) {
	result = &v2alpha1.CiliumL2AnnouncementPolicy{}
	err = c.client.Post().
		Resource("ciliuml2announcementpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumL2AnnouncementPolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumL2AnnouncementPolicy and updates it. Returns the server's representation of the ciliumL2AnnouncementPolicy, and an error, if there is any.
func (c *ciliumL2AnnouncementPolicies) Update(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.UpdateOptions) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error) {
	result = &v2alpha1.CiliumL2AnnouncementPolicy{}
	err = c.client.Put().
		Resource("ciliuml2announcementpolicies").
		Name(ciliumL2AnnouncementPolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumL2AnnouncementPolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ciliumL2AnnouncementPolicies) UpdateStatus(ctx context.Context, ciliumL2AnnouncementPolicy *v2alpha1.CiliumL2AnnouncementPolicy, opts v1.UpdateOptions) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error) {
	result = &v2alpha1.CiliumL2AnnouncementPolicy{}
	err = c.client.Put().
		Resource("ciliuml2announcementpolicies").
		Name(ciliumL2AnnouncementPolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumL2AnnouncementPolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumL2AnnouncementPolicy and deletes it. Returns an error if one occurs.
func (c *ciliumL2AnnouncementPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliuml2announcementpolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumL2AnnouncementPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliuml2announcementpolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumL2AnnouncementPolicy.
func (c *ciliumL2AnnouncementPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumL2AnnouncementPolicy, err error) {
	result = &v2alpha1.CiliumL2AnnouncementPolicy{}
	err = c.client.Patch(pt).
		Resource("ciliuml2announcementpolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
