// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v3.21.12
// source: envoy/config/listener/v3/listener_components.proto

package listenerv3

import (
	_ "github.com/cilium/proxy/go/envoy/annotations"
	v3 "github.com/cilium/proxy/go/envoy/config/core/v3"
	v31 "github.com/cilium/proxy/go/envoy/type/v3"
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type FilterChainMatch_ConnectionSourceType int32

const (
	// Any connection source matches.
	FilterChainMatch_ANY FilterChainMatch_ConnectionSourceType = 0
	// Match a connection originating from the same host.
	FilterChainMatch_SAME_IP_OR_LOOPBACK FilterChainMatch_ConnectionSourceType = 1
	// Match a connection originating from a different host.
	FilterChainMatch_EXTERNAL FilterChainMatch_ConnectionSourceType = 2
)

// Enum value maps for FilterChainMatch_ConnectionSourceType.
var (
	FilterChainMatch_ConnectionSourceType_name = map[int32]string{
		0: "ANY",
		1: "SAME_IP_OR_LOOPBACK",
		2: "EXTERNAL",
	}
	FilterChainMatch_ConnectionSourceType_value = map[string]int32{
		"ANY":                 0,
		"SAME_IP_OR_LOOPBACK": 1,
		"EXTERNAL":            2,
	}
)

func (x FilterChainMatch_ConnectionSourceType) Enum() *FilterChainMatch_ConnectionSourceType {
	p := new(FilterChainMatch_ConnectionSourceType)
	*p = x
	return p
}

func (x FilterChainMatch_ConnectionSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterChainMatch_ConnectionSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_listener_v3_listener_components_proto_enumTypes[0].Descriptor()
}

func (FilterChainMatch_ConnectionSourceType) Type() protoreflect.EnumType {
	return &file_envoy_config_listener_v3_listener_components_proto_enumTypes[0]
}

func (x FilterChainMatch_ConnectionSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterChainMatch_ConnectionSourceType.Descriptor instead.
func (FilterChainMatch_ConnectionSourceType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{1, 0}
}

// [#next-free-field: 6]
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the filter configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to ConfigType:
	//
	//	*Filter_TypedConfig
	//	*Filter_ConfigDiscovery
	ConfigType isFilter_ConfigType `protobuf_oneof:"config_type"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{0}
}

func (x *Filter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Filter) GetConfigType() isFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (x *Filter) GetTypedConfig() *anypb.Any {
	if x, ok := x.GetConfigType().(*Filter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

func (x *Filter) GetConfigDiscovery() *v3.ExtensionConfigSource {
	if x, ok := x.GetConfigType().(*Filter_ConfigDiscovery); ok {
		return x.ConfigDiscovery
	}
	return nil
}

type isFilter_ConfigType interface {
	isFilter_ConfigType()
}

type Filter_TypedConfig struct {
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	// [#extension-category: envoy.filters.network]
	TypedConfig *anypb.Any `protobuf:"bytes,4,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

type Filter_ConfigDiscovery struct {
	// Configuration source specifier for an extension configuration discovery
	// service. In case of a failure and without the default configuration, the
	// listener closes the connections.
	// [#not-implemented-hide:]
	ConfigDiscovery *v3.ExtensionConfigSource `protobuf:"bytes,5,opt,name=config_discovery,json=configDiscovery,proto3,oneof"`
}

func (*Filter_TypedConfig) isFilter_ConfigType() {}

func (*Filter_ConfigDiscovery) isFilter_ConfigType() {}

// Specifies the match criteria for selecting a specific filter chain for a
// listener.
//
// In order for a filter chain to be selected, *ALL* of its criteria must be
// fulfilled by the incoming connection, properties of which are set by the
// networking stack and/or listener filters.
//
// The following order applies:
//
//  1. Destination port.
//  2. Destination IP address.
//  3. Server name (e.g. SNI for TLS protocol),
//  4. Transport protocol.
//  5. Application protocols (e.g. ALPN for TLS protocol).
//  6. Directly connected source IP address (this will only be different from the source IP address
//     when using a listener filter that overrides the source address, such as the :ref:`Proxy Protocol
//     listener filter <config_listener_filters_proxy_protocol>`).
//  7. Source type (e.g. any, local or external network).
//  8. Source IP address.
//  9. Source port.
//
// For criteria that allow ranges or wildcards, the most specific value in any
// of the configured filter chains that matches the incoming connection is going
// to be used (e.g. for SNI “www.example.com“ the most specific match would be
// “www.example.com“, then “*.example.com“, then “*.com“, then any filter
// chain without “server_names“ requirements).
//
// A different way to reason about the filter chain matches:
// Suppose there exists N filter chains. Prune the filter chain set using the above 8 steps.
// In each step, filter chains which most specifically matches the attributes continue to the next step.
// The listener guarantees at most 1 filter chain is left after all of the steps.
//
// Example:
//
// For destination port, filter chains specifying the destination port of incoming traffic are the
// most specific match. If none of the filter chains specifies the exact destination port, the filter
// chains which do not specify ports are the most specific match. Filter chains specifying the
// wrong port can never be the most specific match.
//
// [#comment: Implemented rules are kept in the preference order, with deprecated fields
// listed at the end, because that's how we want to list them in the docs.
//
// [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
// [#next-free-field: 14]
type FilterChainMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional destination port to consider when use_original_dst is set on the
	// listener in determining a filter chain match.
	DestinationPort *wrapperspb.UInt32Value `protobuf:"bytes,8,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// If non-empty, an IP address and prefix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	PrefixRanges []*v3.CidrRange `protobuf:"bytes,3,rep,name=prefix_ranges,json=prefixRanges,proto3" json:"prefix_ranges,omitempty"`
	// If non-empty, an IP address and suffix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	// [#not-implemented-hide:]
	AddressSuffix string `protobuf:"bytes,4,opt,name=address_suffix,json=addressSuffix,proto3" json:"address_suffix,omitempty"`
	// [#not-implemented-hide:]
	SuffixLen *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=suffix_len,json=suffixLen,proto3" json:"suffix_len,omitempty"`
	// The criteria is satisfied if the directly connected source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the parameter is not
	// specified or the list is empty, the directly connected source IP address is ignored.
	DirectSourcePrefixRanges []*v3.CidrRange `protobuf:"bytes,13,rep,name=direct_source_prefix_ranges,json=directSourcePrefixRanges,proto3" json:"direct_source_prefix_ranges,omitempty"`
	// Specifies the connection source IP match type. Can be any, local or external network.
	SourceType FilterChainMatch_ConnectionSourceType `protobuf:"varint,12,opt,name=source_type,json=sourceType,proto3,enum=envoy.config.listener.v3.FilterChainMatch_ConnectionSourceType" json:"source_type,omitempty"`
	// The criteria is satisfied if the source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the
	// parameter is not specified or the list is empty, the source IP address is
	// ignored.
	SourcePrefixRanges []*v3.CidrRange `protobuf:"bytes,6,rep,name=source_prefix_ranges,json=sourcePrefixRanges,proto3" json:"source_prefix_ranges,omitempty"`
	// The criteria is satisfied if the source port of the downstream connection
	// is contained in at least one of the specified ports. If the parameter is
	// not specified, the source port is ignored.
	SourcePorts []uint32 `protobuf:"varint,7,rep,packed,name=source_ports,json=sourcePorts,proto3" json:"source_ports,omitempty"`
	// If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
	// a filter chain match. Those values will be compared against the server names of a new
	// connection, when detected by one of the listener filters.
	//
	// The server name will be matched against all wildcard domains, i.e. “www.example.com“
	// will be first matched against “www.example.com“, then “*.example.com“, then “*.com“.
	//
	// Note that partial wildcards are not supported, and values like “*w.example.com“ are invalid.
	// The value “*“ is also not supported, and “server_names“ should be omitted instead.
	//
	// .. attention::
	//
	//	See the :ref:`FAQ entry <faq_how_to_setup_sni>` on how to configure SNI for more
	//	information.
	ServerNames []string `protobuf:"bytes,11,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// If non-empty, a transport protocol to consider when determining a filter chain match.
	// This value will be compared against the transport protocol of a new connection, when
	// it's detected by one of the listener filters.
	//
	// Suggested values include:
	//
	//   - “raw_buffer“ - default, used when no transport protocol is detected,
	//   - “tls“ - set by :ref:`envoy.filters.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//     when TLS protocol is detected.
	TransportProtocol string `protobuf:"bytes,9,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
	// determining a filter chain match. Those values will be compared against the application
	// protocols of a new connection, when detected by one of the listener filters.
	//
	// Suggested values include:
	//
	//   - “http/1.1“ - set by :ref:`envoy.filters.listener.tls_inspector
	//     <config_listener_filters_tls_inspector>`,
	//   - “h2“ - set by :ref:`envoy.filters.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//
	// .. attention::
	//
	//	Currently, only :ref:`TLS Inspector <config_listener_filters_tls_inspector>` provides
	//	application protocol detection based on the requested
	//	`ALPN <https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation>`_ values.
	//
	//	However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
	//	and matching on values other than ``h2`` is going to lead to a lot of false negatives,
	//	unless all connecting clients are known to use ALPN.
	ApplicationProtocols []string `protobuf:"bytes,10,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
}

func (x *FilterChainMatch) Reset() {
	*x = FilterChainMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterChainMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterChainMatch) ProtoMessage() {}

func (x *FilterChainMatch) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterChainMatch.ProtoReflect.Descriptor instead.
func (*FilterChainMatch) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{1}
}

func (x *FilterChainMatch) GetDestinationPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.DestinationPort
	}
	return nil
}

func (x *FilterChainMatch) GetPrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.PrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetAddressSuffix() string {
	if x != nil {
		return x.AddressSuffix
	}
	return ""
}

func (x *FilterChainMatch) GetSuffixLen() *wrapperspb.UInt32Value {
	if x != nil {
		return x.SuffixLen
	}
	return nil
}

func (x *FilterChainMatch) GetDirectSourcePrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.DirectSourcePrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetSourceType() FilterChainMatch_ConnectionSourceType {
	if x != nil {
		return x.SourceType
	}
	return FilterChainMatch_ANY
}

func (x *FilterChainMatch) GetSourcePrefixRanges() []*v3.CidrRange {
	if x != nil {
		return x.SourcePrefixRanges
	}
	return nil
}

func (x *FilterChainMatch) GetSourcePorts() []uint32 {
	if x != nil {
		return x.SourcePorts
	}
	return nil
}

func (x *FilterChainMatch) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *FilterChainMatch) GetTransportProtocol() string {
	if x != nil {
		return x.TransportProtocol
	}
	return ""
}

func (x *FilterChainMatch) GetApplicationProtocols() []string {
	if x != nil {
		return x.ApplicationProtocols
	}
	return nil
}

// A filter chain wraps a set of match criteria, an option TLS context, a set of filters, and
// various other parameters.
// [#next-free-field: 10]
type FilterChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The criteria to use when matching a connection to this filter chain.
	FilterChainMatch *FilterChainMatch `protobuf:"bytes,1,opt,name=filter_chain_match,json=filterChainMatch,proto3" json:"filter_chain_match,omitempty"`
	// A list of individual network filters that make up the filter chain for
	// connections established with the listener. Order matters as the filters are
	// processed sequentially as connection events happen. Note: If the filter
	// list is empty, the connection will close by default.
	//
	// For QUIC listeners, network filters other than HTTP Connection Manager (HCM)
	// can be created, but due to differences in the connection implementation compared
	// to TCP, the onData() method will never be called. Therefore, network filters
	// for QUIC listeners should only expect to do work at the start of a new connection
	// (i.e. in onNewConnection()). HCM must be the last (or only) filter in the chain.
	Filters []*Filter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
	// Whether the listener should expect a PROXY protocol V1 header on new
	// connections. If this option is enabled, the listener will assume that that
	// remote address of the connection is the one specified in the header. Some
	// load balancers including the AWS ELB support this option. If the option is
	// absent or set to false, Envoy will use the physical peer address of the
	// connection as the remote address.
	//
	// This field is deprecated. Add a
	// :ref:`PROXY protocol listener filter <config_listener_filters_proxy_protocol>`
	// explicitly instead.
	//
	// Deprecated: Do not use.
	UseProxyProto *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=use_proxy_proto,json=useProxyProto,proto3" json:"use_proxy_proto,omitempty"`
	// [#not-implemented-hide:] filter chain metadata.
	Metadata *v3.Metadata `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Optional custom transport socket implementation to use for downstream connections.
	// To setup TLS, set a transport socket with name “envoy.transport_sockets.tls“ and
	// :ref:`DownstreamTlsContext <envoy_v3_api_msg_extensions.transport_sockets.tls.v3.DownstreamTlsContext>` in the “typed_config“.
	// If no transport socket configuration is specified, new connections
	// will be set up with plaintext.
	// [#extension-category: envoy.transport_sockets.downstream]
	TransportSocket *v3.TransportSocket `protobuf:"bytes,6,opt,name=transport_socket,json=transportSocket,proto3" json:"transport_socket,omitempty"`
	// If present and nonzero, the amount of time to allow incoming connections to complete any
	// transport socket negotiations. If this expires before the transport reports connection
	// establishment, the connection is summarily closed.
	TransportSocketConnectTimeout *durationpb.Duration `protobuf:"bytes,9,opt,name=transport_socket_connect_timeout,json=transportSocketConnectTimeout,proto3" json:"transport_socket_connect_timeout,omitempty"`
	// The unique name (or empty) by which this filter chain is known.
	// Note: :ref:`filter_chain_matcher
	// <envoy_v3_api_field_config.listener.v3.Listener.filter_chain_matcher>`
	// requires that filter chains are uniquely named within a listener.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// [#not-implemented-hide:] The configuration to specify whether the filter chain will be built on-demand.
	// If this field is not empty, the filter chain will be built on-demand.
	// Otherwise, the filter chain will be built normally and block listener warming.
	OnDemandConfiguration *FilterChain_OnDemandConfiguration `protobuf:"bytes,8,opt,name=on_demand_configuration,json=onDemandConfiguration,proto3" json:"on_demand_configuration,omitempty"`
}

func (x *FilterChain) Reset() {
	*x = FilterChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterChain) ProtoMessage() {}

func (x *FilterChain) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterChain.ProtoReflect.Descriptor instead.
func (*FilterChain) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{2}
}

func (x *FilterChain) GetFilterChainMatch() *FilterChainMatch {
	if x != nil {
		return x.FilterChainMatch
	}
	return nil
}

func (x *FilterChain) GetFilters() []*Filter {
	if x != nil {
		return x.Filters
	}
	return nil
}

// Deprecated: Do not use.
func (x *FilterChain) GetUseProxyProto() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseProxyProto
	}
	return nil
}

func (x *FilterChain) GetMetadata() *v3.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *FilterChain) GetTransportSocket() *v3.TransportSocket {
	if x != nil {
		return x.TransportSocket
	}
	return nil
}

func (x *FilterChain) GetTransportSocketConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.TransportSocketConnectTimeout
	}
	return nil
}

func (x *FilterChain) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FilterChain) GetOnDemandConfiguration() *FilterChain_OnDemandConfiguration {
	if x != nil {
		return x.OnDemandConfiguration
	}
	return nil
}

// Listener filter chain match configuration. This is a recursive structure which allows complex
// nested match configurations to be built using various logical operators.
//
// Examples:
//
// * Matches if the destination port is 3306.
//
// .. code-block:: yaml
//
//	destination_port_range:
//	 start: 3306
//	 end: 3307
//
// * Matches if the destination port is 3306 or 15000.
//
// .. code-block:: yaml
//
//	or_match:
//	  rules:
//	    - destination_port_range:
//	        start: 3306
//	        end: 3307
//	    - destination_port_range:
//	        start: 15000
//	        end: 15001
//
// [#next-free-field: 6]
type ListenerFilterChainMatchPredicate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Rule:
	//
	//	*ListenerFilterChainMatchPredicate_OrMatch
	//	*ListenerFilterChainMatchPredicate_AndMatch
	//	*ListenerFilterChainMatchPredicate_NotMatch
	//	*ListenerFilterChainMatchPredicate_AnyMatch
	//	*ListenerFilterChainMatchPredicate_DestinationPortRange
	Rule isListenerFilterChainMatchPredicate_Rule `protobuf_oneof:"rule"`
}

func (x *ListenerFilterChainMatchPredicate) Reset() {
	*x = ListenerFilterChainMatchPredicate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenerFilterChainMatchPredicate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilterChainMatchPredicate) ProtoMessage() {}

func (x *ListenerFilterChainMatchPredicate) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilterChainMatchPredicate.ProtoReflect.Descriptor instead.
func (*ListenerFilterChainMatchPredicate) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{3}
}

func (m *ListenerFilterChainMatchPredicate) GetRule() isListenerFilterChainMatchPredicate_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetOrMatch() *ListenerFilterChainMatchPredicate_MatchSet {
	if x, ok := x.GetRule().(*ListenerFilterChainMatchPredicate_OrMatch); ok {
		return x.OrMatch
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetAndMatch() *ListenerFilterChainMatchPredicate_MatchSet {
	if x, ok := x.GetRule().(*ListenerFilterChainMatchPredicate_AndMatch); ok {
		return x.AndMatch
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetNotMatch() *ListenerFilterChainMatchPredicate {
	if x, ok := x.GetRule().(*ListenerFilterChainMatchPredicate_NotMatch); ok {
		return x.NotMatch
	}
	return nil
}

func (x *ListenerFilterChainMatchPredicate) GetAnyMatch() bool {
	if x, ok := x.GetRule().(*ListenerFilterChainMatchPredicate_AnyMatch); ok {
		return x.AnyMatch
	}
	return false
}

func (x *ListenerFilterChainMatchPredicate) GetDestinationPortRange() *v31.Int32Range {
	if x, ok := x.GetRule().(*ListenerFilterChainMatchPredicate_DestinationPortRange); ok {
		return x.DestinationPortRange
	}
	return nil
}

type isListenerFilterChainMatchPredicate_Rule interface {
	isListenerFilterChainMatchPredicate_Rule()
}

type ListenerFilterChainMatchPredicate_OrMatch struct {
	// A set that describes a logical OR. If any member of the set matches, the match configuration
	// matches.
	OrMatch *ListenerFilterChainMatchPredicate_MatchSet `protobuf:"bytes,1,opt,name=or_match,json=orMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_AndMatch struct {
	// A set that describes a logical AND. If all members of the set match, the match configuration
	// matches.
	AndMatch *ListenerFilterChainMatchPredicate_MatchSet `protobuf:"bytes,2,opt,name=and_match,json=andMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_NotMatch struct {
	// A negation match. The match configuration will match if the negated match condition matches.
	NotMatch *ListenerFilterChainMatchPredicate `protobuf:"bytes,3,opt,name=not_match,json=notMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_AnyMatch struct {
	// The match configuration will always match.
	AnyMatch bool `protobuf:"varint,4,opt,name=any_match,json=anyMatch,proto3,oneof"`
}

type ListenerFilterChainMatchPredicate_DestinationPortRange struct {
	// Match destination port. Particularly, the match evaluation must use the recovered local port if
	// the owning listener filter is after :ref:`an original_dst listener filter <config_listener_filters_original_dst>`.
	DestinationPortRange *v31.Int32Range `protobuf:"bytes,5,opt,name=destination_port_range,json=destinationPortRange,proto3,oneof"`
}

func (*ListenerFilterChainMatchPredicate_OrMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_AndMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_NotMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_AnyMatch) isListenerFilterChainMatchPredicate_Rule() {}

func (*ListenerFilterChainMatchPredicate_DestinationPortRange) isListenerFilterChainMatchPredicate_Rule() {
}

// [#next-free-field: 6]
type ListenerFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the filter configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to ConfigType:
	//
	//	*ListenerFilter_TypedConfig
	//	*ListenerFilter_ConfigDiscovery
	ConfigType isListenerFilter_ConfigType `protobuf_oneof:"config_type"`
	// Optional match predicate used to disable the filter. The filter is enabled when this field is empty.
	// See :ref:`ListenerFilterChainMatchPredicate <envoy_v3_api_msg_config.listener.v3.ListenerFilterChainMatchPredicate>`
	// for further examples.
	FilterDisabled *ListenerFilterChainMatchPredicate `protobuf:"bytes,4,opt,name=filter_disabled,json=filterDisabled,proto3" json:"filter_disabled,omitempty"`
}

func (x *ListenerFilter) Reset() {
	*x = ListenerFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenerFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilter) ProtoMessage() {}

func (x *ListenerFilter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilter.ProtoReflect.Descriptor instead.
func (*ListenerFilter) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{4}
}

func (x *ListenerFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *ListenerFilter) GetConfigType() isListenerFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (x *ListenerFilter) GetTypedConfig() *anypb.Any {
	if x, ok := x.GetConfigType().(*ListenerFilter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

func (x *ListenerFilter) GetConfigDiscovery() *v3.ExtensionConfigSource {
	if x, ok := x.GetConfigType().(*ListenerFilter_ConfigDiscovery); ok {
		return x.ConfigDiscovery
	}
	return nil
}

func (x *ListenerFilter) GetFilterDisabled() *ListenerFilterChainMatchPredicate {
	if x != nil {
		return x.FilterDisabled
	}
	return nil
}

type isListenerFilter_ConfigType interface {
	isListenerFilter_ConfigType()
}

type ListenerFilter_TypedConfig struct {
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	// [#extension-category: envoy.filters.listener,envoy.filters.udp_listener]
	TypedConfig *anypb.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

type ListenerFilter_ConfigDiscovery struct {
	// Configuration source specifier for an extension configuration discovery
	// service. In case of a failure and without the default configuration, the
	// listener closes the connections.
	ConfigDiscovery *v3.ExtensionConfigSource `protobuf:"bytes,5,opt,name=config_discovery,json=configDiscovery,proto3,oneof"`
}

func (*ListenerFilter_TypedConfig) isListenerFilter_ConfigType() {}

func (*ListenerFilter_ConfigDiscovery) isListenerFilter_ConfigType() {}

// The configuration for on-demand filter chain. If this field is not empty in FilterChain message,
// a filter chain will be built on-demand.
// On-demand filter chains help speedup the warming up of listeners since the building and initialization of
// an on-demand filter chain will be postponed to the arrival of new connection requests that require this filter chain.
// Filter chains that are not often used can be set as on-demand.
type FilterChain_OnDemandConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timeout to wait for filter chain placeholders to complete rebuilding.
	// 1. If this field is set to 0, timeout is disabled.
	// 2. If not specified, a default timeout of 15s is used.
	// Rebuilding will wait until dependencies are ready, have failed, or this timeout is reached.
	// Upon failure or timeout, all connections related to this filter chain will be closed.
	// Rebuilding will start again on the next new connection.
	RebuildTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=rebuild_timeout,json=rebuildTimeout,proto3" json:"rebuild_timeout,omitempty"`
}

func (x *FilterChain_OnDemandConfiguration) Reset() {
	*x = FilterChain_OnDemandConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterChain_OnDemandConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterChain_OnDemandConfiguration) ProtoMessage() {}

func (x *FilterChain_OnDemandConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterChain_OnDemandConfiguration.ProtoReflect.Descriptor instead.
func (*FilterChain_OnDemandConfiguration) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{2, 0}
}

func (x *FilterChain_OnDemandConfiguration) GetRebuildTimeout() *durationpb.Duration {
	if x != nil {
		return x.RebuildTimeout
	}
	return nil
}

// A set of match configurations used for logical operations.
type ListenerFilterChainMatchPredicate_MatchSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rules that make up the set.
	Rules []*ListenerFilterChainMatchPredicate `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) Reset() {
	*x = ListenerFilterChainMatchPredicate_MatchSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerFilterChainMatchPredicate_MatchSet) ProtoMessage() {}

func (x *ListenerFilterChainMatchPredicate_MatchSet) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_components_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerFilterChainMatchPredicate_MatchSet.ProtoReflect.Descriptor instead.
func (*ListenerFilterChainMatchPredicate_MatchSet) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ListenerFilterChainMatchPredicate_MatchSet) GetRules() []*ListenerFilterChainMatchPredicate {
	if x != nil {
		return x.Rules
	}
	return nil
}

var File_envoy_config_listener_v3_listener_components_proto protoreflect.FileDescriptor

var file_envoy_config_listener_v3_listener_components_proto_rawDesc = []byte{
	0x0a, 0x32, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x1a, 0x22,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x82, 0x02, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42,
	0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0c, 0x74,
	0x79, 0x70, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x3a, 0x23, 0x9a, 0xc5, 0x88, 0x1e, 0x1e, 0x0a, 0x1c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0d, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xea, 0x06, 0x0a, 0x10, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x54, 0x0a,
	0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x2a, 0x06, 0x18, 0xff, 0xff, 0x03,
	0x28, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x72, 0x74, 0x12, 0x44, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x33, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78,
	0x12, 0x3b, 0x0a, 0x0a, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x09, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x12, 0x5e, 0x0a,
	0x1b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x18, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x6a, 0x0a,
	0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x14, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x43,
	0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x0c,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0d, 0x42, 0x10, 0xfa, 0x42, 0x0d, 0x92, 0x01, 0x0a, 0x22, 0x08, 0x2a, 0x06, 0x18, 0xff,
	0xff, 0x03, 0x28, 0x01, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x12, 0x33, 0x0a, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x22, 0x46, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x41, 0x4d,
	0x45, 0x5f, 0x49, 0x50, 0x5f, 0x4f, 0x52, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x42, 0x41, 0x43, 0x4b,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02,
	0x3a, 0x2d, 0x9a, 0xc5, 0x88, 0x1e, 0x28, 0x0a, 0x26, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4a,
	0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0x89, 0x06, 0x0a, 0x0b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x58, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x10, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x3a, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x75,
	0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x0b, 0x18, 0x01, 0x92, 0xc7, 0x86, 0xd8, 0x04, 0x03, 0x33, 0x2e, 0x30, 0x52, 0x0d, 0x75,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3a, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x50, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x62, 0x0a, 0x20, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x1d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x73, 0x0a, 0x17, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x4f, 0x6e, 0x44, 0x65, 0x6d,
	0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x15, 0x6f, 0x6e, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x5b, 0x0a, 0x15, 0x4f, 0x6e, 0x44, 0x65, 0x6d,
	0x61, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x0a, 0x0f, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x3a, 0x28, 0x9a, 0xc5, 0x88, 0x1e, 0x23, 0x0a, 0x21, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4a, 0x04,
	0x08, 0x02, 0x10, 0x03, 0x52, 0x0b, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x22, 0xc2, 0x05, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x61, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x74, 0x48,
	0x00, 0x52, 0x07, 0x6f, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x63, 0x0a, 0x09, 0x61, 0x6e,
	0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x5a, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x26, 0x0a, 0x09, 0x61,
	0x6e, 0x79, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x6a, 0x02, 0x08, 0x01, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x79, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x51, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72,
	0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0xb0, 0x01, 0x0a, 0x08, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x65, 0x74, 0x12, 0x5b, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x3a, 0x47, 0x9a, 0xc5, 0x88, 0x1e, 0x42, 0x0a, 0x40, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61,
	0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x74, 0x3a, 0x3e, 0x9a, 0xc5, 0x88, 0x1e, 0x39,
	0x0a, 0x37, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x0b, 0x0a, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xf2, 0x02, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0c, 0x74, 0x79, 0x70, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x58, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x0f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x3a, 0x2b, 0x9a, 0xc5, 0x88, 0x1e, 0x26, 0x0a, 0x24, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0d,
	0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x4a, 0x04, 0x08,
	0x02, 0x10, 0x03, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x97, 0x01, 0x0a, 0x26,
	0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x42, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2f,
	0x76, 0x33, 0x3b, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x76, 0x33, 0xba, 0x80, 0xc8,
	0xd1, 0x06, 0x02, 0x10, 0x02, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_config_listener_v3_listener_components_proto_rawDescOnce sync.Once
	file_envoy_config_listener_v3_listener_components_proto_rawDescData = file_envoy_config_listener_v3_listener_components_proto_rawDesc
)

func file_envoy_config_listener_v3_listener_components_proto_rawDescGZIP() []byte {
	file_envoy_config_listener_v3_listener_components_proto_rawDescOnce.Do(func() {
		file_envoy_config_listener_v3_listener_components_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_config_listener_v3_listener_components_proto_rawDescData)
	})
	return file_envoy_config_listener_v3_listener_components_proto_rawDescData
}

var file_envoy_config_listener_v3_listener_components_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_config_listener_v3_listener_components_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_envoy_config_listener_v3_listener_components_proto_goTypes = []interface{}{
	(FilterChainMatch_ConnectionSourceType)(0), // 0: envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType
	(*Filter)(nil),                                     // 1: envoy.config.listener.v3.Filter
	(*FilterChainMatch)(nil),                           // 2: envoy.config.listener.v3.FilterChainMatch
	(*FilterChain)(nil),                                // 3: envoy.config.listener.v3.FilterChain
	(*ListenerFilterChainMatchPredicate)(nil),          // 4: envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	(*ListenerFilter)(nil),                             // 5: envoy.config.listener.v3.ListenerFilter
	(*FilterChain_OnDemandConfiguration)(nil),          // 6: envoy.config.listener.v3.FilterChain.OnDemandConfiguration
	(*ListenerFilterChainMatchPredicate_MatchSet)(nil), // 7: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	(*anypb.Any)(nil),                                  // 8: google.protobuf.Any
	(*v3.ExtensionConfigSource)(nil),                   // 9: envoy.config.core.v3.ExtensionConfigSource
	(*wrapperspb.UInt32Value)(nil),                     // 10: google.protobuf.UInt32Value
	(*v3.CidrRange)(nil),                               // 11: envoy.config.core.v3.CidrRange
	(*wrapperspb.BoolValue)(nil),                       // 12: google.protobuf.BoolValue
	(*v3.Metadata)(nil),                                // 13: envoy.config.core.v3.Metadata
	(*v3.TransportSocket)(nil),                         // 14: envoy.config.core.v3.TransportSocket
	(*durationpb.Duration)(nil),                        // 15: google.protobuf.Duration
	(*v31.Int32Range)(nil),                             // 16: envoy.type.v3.Int32Range
}
var file_envoy_config_listener_v3_listener_components_proto_depIdxs = []int32{
	8,  // 0: envoy.config.listener.v3.Filter.typed_config:type_name -> google.protobuf.Any
	9,  // 1: envoy.config.listener.v3.Filter.config_discovery:type_name -> envoy.config.core.v3.ExtensionConfigSource
	10, // 2: envoy.config.listener.v3.FilterChainMatch.destination_port:type_name -> google.protobuf.UInt32Value
	11, // 3: envoy.config.listener.v3.FilterChainMatch.prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	10, // 4: envoy.config.listener.v3.FilterChainMatch.suffix_len:type_name -> google.protobuf.UInt32Value
	11, // 5: envoy.config.listener.v3.FilterChainMatch.direct_source_prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	0,  // 6: envoy.config.listener.v3.FilterChainMatch.source_type:type_name -> envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType
	11, // 7: envoy.config.listener.v3.FilterChainMatch.source_prefix_ranges:type_name -> envoy.config.core.v3.CidrRange
	2,  // 8: envoy.config.listener.v3.FilterChain.filter_chain_match:type_name -> envoy.config.listener.v3.FilterChainMatch
	1,  // 9: envoy.config.listener.v3.FilterChain.filters:type_name -> envoy.config.listener.v3.Filter
	12, // 10: envoy.config.listener.v3.FilterChain.use_proxy_proto:type_name -> google.protobuf.BoolValue
	13, // 11: envoy.config.listener.v3.FilterChain.metadata:type_name -> envoy.config.core.v3.Metadata
	14, // 12: envoy.config.listener.v3.FilterChain.transport_socket:type_name -> envoy.config.core.v3.TransportSocket
	15, // 13: envoy.config.listener.v3.FilterChain.transport_socket_connect_timeout:type_name -> google.protobuf.Duration
	6,  // 14: envoy.config.listener.v3.FilterChain.on_demand_configuration:type_name -> envoy.config.listener.v3.FilterChain.OnDemandConfiguration
	7,  // 15: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.or_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	7,  // 16: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.and_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet
	4,  // 17: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.not_match:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	16, // 18: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.destination_port_range:type_name -> envoy.type.v3.Int32Range
	8,  // 19: envoy.config.listener.v3.ListenerFilter.typed_config:type_name -> google.protobuf.Any
	9,  // 20: envoy.config.listener.v3.ListenerFilter.config_discovery:type_name -> envoy.config.core.v3.ExtensionConfigSource
	4,  // 21: envoy.config.listener.v3.ListenerFilter.filter_disabled:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	15, // 22: envoy.config.listener.v3.FilterChain.OnDemandConfiguration.rebuild_timeout:type_name -> google.protobuf.Duration
	4,  // 23: envoy.config.listener.v3.ListenerFilterChainMatchPredicate.MatchSet.rules:type_name -> envoy.config.listener.v3.ListenerFilterChainMatchPredicate
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_envoy_config_listener_v3_listener_components_proto_init() }
func file_envoy_config_listener_v3_listener_components_proto_init() {
	if File_envoy_config_listener_v3_listener_components_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterChainMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenerFilterChainMatchPredicate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenerFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterChain_OnDemandConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_listener_v3_listener_components_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenerFilterChainMatchPredicate_MatchSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Filter_TypedConfig)(nil),
		(*Filter_ConfigDiscovery)(nil),
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ListenerFilterChainMatchPredicate_OrMatch)(nil),
		(*ListenerFilterChainMatchPredicate_AndMatch)(nil),
		(*ListenerFilterChainMatchPredicate_NotMatch)(nil),
		(*ListenerFilterChainMatchPredicate_AnyMatch)(nil),
		(*ListenerFilterChainMatchPredicate_DestinationPortRange)(nil),
	}
	file_envoy_config_listener_v3_listener_components_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ListenerFilter_TypedConfig)(nil),
		(*ListenerFilter_ConfigDiscovery)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_config_listener_v3_listener_components_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_listener_v3_listener_components_proto_goTypes,
		DependencyIndexes: file_envoy_config_listener_v3_listener_components_proto_depIdxs,
		EnumInfos:         file_envoy_config_listener_v3_listener_components_proto_enumTypes,
		MessageInfos:      file_envoy_config_listener_v3_listener_components_proto_msgTypes,
	}.Build()
	File_envoy_config_listener_v3_listener_components_proto = out.File
	file_envoy_config_listener_v3_listener_components_proto_rawDesc = nil
	file_envoy_config_listener_v3_listener_components_proto_goTypes = nil
	file_envoy_config_listener_v3_listener_components_proto_depIdxs = nil
}
