// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"

	v1 "github.com/cilium/cilium/pkg/k8s/slim/k8s/api/core/v1"
	corev1 "github.com/cilium/cilium/pkg/k8s/slim/k8s/client/clientset/versioned/typed/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
)

// fakePods implements PodInterface
type fakePods struct {
	*gentype.FakeClientWithList[*v1.Pod, *v1.PodList]
	Fake *FakeCoreV1
}

func newFakePods(fake *FakeCoreV1, namespace string) corev1.PodInterface {
	return &fakePods{
		gentype.NewFakeClientWithList[*v1.Pod, *v1.PodList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("pods"),
			v1.SchemeGroupVersion.WithKind("Pod"),
			func() *v1.Pod { return &v1.Pod{} },
			func() *v1.PodList { return &v1.PodList{} },
			func(dst, src *v1.PodList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PodList) []*v1.Pod { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PodList, items []*v1.Pod) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}

// UpdateEphemeralContainers takes the representation of a pod and updates it. Returns the server's representation of the pod, and an error, if there is any.
func (c *fakePods) UpdateEphemeralContainers(ctx context.Context, podName string, pod *v1.Pod, opts metav1.UpdateOptions) (result *v1.Pod, err error) {
	emptyResult := &v1.Pod{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(c.Resource(), "ephemeralcontainers", c.Namespace(), pod, opts), &v1.Pod{})

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.Pod), err
}
