// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2021 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetClusterNodesParams creates a new GetClusterNodesParams object
// with the default values initialized.
func NewGetClusterNodesParams() *GetClusterNodesParams {
	var ()
	return &GetClusterNodesParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewGetClusterNodesParamsWithTimeout creates a new GetClusterNodesParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGetClusterNodesParamsWithTimeout(timeout time.Duration) *GetClusterNodesParams {
	var ()
	return &GetClusterNodesParams{

		timeout: timeout,
	}
}

// NewGetClusterNodesParamsWithContext creates a new GetClusterNodesParams object
// with the default values initialized, and the ability to set a context for a request
func NewGetClusterNodesParamsWithContext(ctx context.Context) *GetClusterNodesParams {
	var ()
	return &GetClusterNodesParams{

		Context: ctx,
	}
}

// NewGetClusterNodesParamsWithHTTPClient creates a new GetClusterNodesParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGetClusterNodesParamsWithHTTPClient(client *http.Client) *GetClusterNodesParams {
	var ()
	return &GetClusterNodesParams{
		HTTPClient: client,
	}
}

/*GetClusterNodesParams contains all the parameters to send to the API endpoint
for the get cluster nodes operation typically these are written to a http.Request
*/
type GetClusterNodesParams struct {

	/*ClientID
	  Client UUID should be used when the client wants to request
	a diff of nodes added and / or removed since the last time
	that client has made a request.


	*/
	ClientID *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the get cluster nodes params
func (o *GetClusterNodesParams) WithTimeout(timeout time.Duration) *GetClusterNodesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get cluster nodes params
func (o *GetClusterNodesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get cluster nodes params
func (o *GetClusterNodesParams) WithContext(ctx context.Context) *GetClusterNodesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get cluster nodes params
func (o *GetClusterNodesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get cluster nodes params
func (o *GetClusterNodesParams) WithHTTPClient(client *http.Client) *GetClusterNodesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get cluster nodes params
func (o *GetClusterNodesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClientID adds the clientID to the get cluster nodes params
func (o *GetClusterNodesParams) WithClientID(clientID *int64) *GetClusterNodesParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the get cluster nodes params
func (o *GetClusterNodesParams) SetClientID(clientID *int64) {
	o.ClientID = clientID
}

// WriteToRequest writes these params to a swagger request
func (o *GetClusterNodesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClientID != nil {

		// header param client-id
		if err := r.SetHeaderParam("client-id", swag.FormatInt64(*o.ClientID)); err != nil {
			return err
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
