// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2021 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetEndpointIDConfigReader is a Reader for the GetEndpointIDConfig structure.
type GetEndpointIDConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEndpointIDConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetEndpointIDConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetEndpointIDConfigNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEndpointIDConfigTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetEndpointIDConfigOK creates a GetEndpointIDConfigOK with default headers values
func NewGetEndpointIDConfigOK() *GetEndpointIDConfigOK {
	return &GetEndpointIDConfigOK{}
}

/*GetEndpointIDConfigOK handles this case with default header values.

Success
*/
type GetEndpointIDConfigOK struct {
	Payload *models.EndpointConfigurationStatus
}

func (o *GetEndpointIDConfigOK) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/config][%d] getEndpointIdConfigOK  %+v", 200, o.Payload)
}

func (o *GetEndpointIDConfigOK) GetPayload() *models.EndpointConfigurationStatus {
	return o.Payload
}

func (o *GetEndpointIDConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EndpointConfigurationStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEndpointIDConfigNotFound creates a GetEndpointIDConfigNotFound with default headers values
func NewGetEndpointIDConfigNotFound() *GetEndpointIDConfigNotFound {
	return &GetEndpointIDConfigNotFound{}
}

/*GetEndpointIDConfigNotFound handles this case with default header values.

Endpoint not found
*/
type GetEndpointIDConfigNotFound struct {
}

func (o *GetEndpointIDConfigNotFound) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/config][%d] getEndpointIdConfigNotFound ", 404)
}

func (o *GetEndpointIDConfigNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetEndpointIDConfigTooManyRequests creates a GetEndpointIDConfigTooManyRequests with default headers values
func NewGetEndpointIDConfigTooManyRequests() *GetEndpointIDConfigTooManyRequests {
	return &GetEndpointIDConfigTooManyRequests{}
}

/*GetEndpointIDConfigTooManyRequests handles this case with default header values.

Rate-limiting too many requests in the given time frame
*/
type GetEndpointIDConfigTooManyRequests struct {
}

func (o *GetEndpointIDConfigTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/config][%d] getEndpointIdConfigTooManyRequests ", 429)
}

func (o *GetEndpointIDConfigTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
