// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
)

func TestFunction_MoveTo(t *testing.T) {
	ms := generateTestFunction()
	dest := NewFunction()
	ms.MoveTo(dest)
	assert.Equal(t, NewFunction(), ms)
	assert.Equal(t, generateTestFunction(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newFunction(&otlpprofiles.Function{}, &sharedState)) })
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).MoveTo(dest) })
}

func TestFunction_CopyTo(t *testing.T) {
	ms := NewFunction()
	orig := NewFunction()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestFunction()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newFunction(&otlpprofiles.Function{}, &sharedState)) })
}

func TestFunction_ID(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, uint64(0), ms.ID())
	ms.SetID(uint64(1))
	assert.Equal(t, uint64(1), ms.ID())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).SetID(uint64(1)) })
}

func TestFunction_Name(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int64(0), ms.Name())
	ms.SetName(int64(1))
	assert.Equal(t, int64(1), ms.Name())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).SetName(int64(1)) })
}

func TestFunction_SystemName(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int64(0), ms.SystemName())
	ms.SetSystemName(int64(1))
	assert.Equal(t, int64(1), ms.SystemName())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).SetSystemName(int64(1)) })
}

func TestFunction_Filename(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int64(0), ms.Filename())
	ms.SetFilename(int64(1))
	assert.Equal(t, int64(1), ms.Filename())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).SetFilename(int64(1)) })
}

func TestFunction_StartLine(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int64(0), ms.StartLine())
	ms.SetStartLine(int64(1))
	assert.Equal(t, int64(1), ms.StartLine())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newFunction(&otlpprofiles.Function{}, &sharedState).SetStartLine(int64(1)) })
}

func generateTestFunction() Function {
	tv := NewFunction()
	fillTestFunction(tv)
	return tv
}

func fillTestFunction(tv Function) {
	tv.orig.Id = uint64(1)
	tv.orig.Name = int64(1)
	tv.orig.SystemName = int64(1)
	tv.orig.Filename = int64(1)
	tv.orig.StartLine = int64(1)
}
