---
name: Vote
about: Vote to make a decision related to an RFC 
title: '[Vote] RFC #XXXX:'
labels: "rfc:vote-needed"
assignees: ''
---

A [vote](https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/rfcs/README.md#voting) has been called for RFC #XXXX following the RFC process.

### Stakeholders

Any person in the community may vote. Votes of the stakeholders are binding. Stakeholders are
encouraged to consider the views from the wider community when casting their vote. As defined in the
RFC, there are N stakeholders for this RFC divided as follows:

| Stakeholders                        | As defined on date | Number of people |
|-------------------------------------|--------------------|------------------|
| @open-telemetry/collector-approvers | yyyy-mm-dd         | N                |

<!--Add additional rows if there are additional stakeholders for the RFC-->

For any stakeholder team, we consider the people that were part of the team at the time the vote is called.

### Voting options

| Option | Description | # Votes (stakeholders) | # Votes (total) |
|--------|-------------|------------------------|-----------------|
| Option 1 | Description of the option | 0 | 0 |

<!--Add additional rows if there are additional options for the RFC-->

### Result

The vote is in progress. A minimum of X votes is required to select an option.

<!--Uncomment the sentence below when the vote has been closed and the result is known.-->
<!--The vote has been closed. X stakeholders voted out of a total of Y. **Option N** has been selected with Z votes from the stakeholders.-->

### Vote process

Please **leave a comment** with your vote and any additional context you would like to provide.
Start your comment with "I vote for **Option N**." and then provide any additional context.

### Related links

Include here any links to the RFC, other PRs and resources that help make an informed vote.

### Checklists

When starting the vote:

- [ ] Announce the vote in the #otel-collector-dev CNCF Slack channel.
- [ ] Add an entry to announce the vote in the next Collector SIG meeting.

For closing the vote:

- [ ] At least five business days have passed since the vote was announced.
- [ ] At least one-third of the stakeholders have voted.
- [ ] The "Voting options" and "Result" sections have been updated reflecting the votes casted.
- [ ] The RFC has been updated reflecting the votes casted.

<sub>**Tip**: [React](https://github.blog/news-insights/product-news/add-reactions-to-pull-requests-issues-and-comments/) with 👍 to help prioritize this issue. Please use comments to provide useful context, avoiding `+1` or `me too`, to help us triage it. Learn more [here](https://opentelemetry.io/community/end-user/issue-participation/).</sub>
