# Memory Limiter Extension

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [development]  |
| Distributions | [] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector?query=is%3Aissue%20is%3Aopen%20label%3Aextension%2Fmemorylimiter%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector/issues?q=is%3Aopen+is%3Aissue+label%3Aextension%2Fmemorylimiter) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector?query=is%3Aissue%20is%3Aclosed%20label%3Aextension%2Fmemorylimiter%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector/issues?q=is%3Aclosed+is%3Aissue+label%3Aextension%2Fmemorylimiter) |

[development]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#development
<!-- end autogenerated section -->

The memory limiter extension is used to prevent out of memory situations on
the collector. The extension will potentially replace the Memory Limiter Processor. 
It provides better guarantees from running out of memory as it will be used by the 
receivers to reject requests before converting them into OTLP. All the configurations 
are the same as Memory Limiter Processor. 


This extension can be used as an extension for all HTTP and gRPC receivers that
are configured through the standard `confighttp` and `configgrpc` libraries. For
example, to configure this extension in the OTLP receiver:

```
receivers:
  otlp:
    protocols:
      grpc:
        middlewares:
          - id: memory_limiter
      http:
        middlewares:
          - id: memory_limiter

extensions:
  memory_limiter:
    check_interval: 1s
    limit_percentage: 1
    spike_limit_percentage: 0.05
```

see [memorylimiterprocessor](../../processor/memorylimiterprocessor/README.md) for additional details
