// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyProfilesDictionary(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesDictionary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewProfilesDictionary()
				CopyProfilesDictionary(dest, src)
				assert.Equal(t, src, dest)
				CopyProfilesDictionary(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyProfilesDictionarySlice(t *testing.T) {
	src := []ProfilesDictionary{}
	dest := []ProfilesDictionary{}
	// Test CopyTo empty
	dest = CopyProfilesDictionarySlice(dest, src)
	assert.Equal(t, []ProfilesDictionary{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesDictionarySlice()
	dest = CopyProfilesDictionarySlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionarySlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesDictionarySlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionarySlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesDictionarySlice(dest, []ProfilesDictionary{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesDictionarySlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionarySlice(), dest)
}

func TestCopyProfilesDictionaryPtrSlice(t *testing.T) {
	src := []*ProfilesDictionary{}
	dest := []*ProfilesDictionary{}
	// Test CopyTo empty
	dest = CopyProfilesDictionaryPtrSlice(dest, src)
	assert.Equal(t, []*ProfilesDictionary{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilesDictionaryPtrSlice()
	dest = CopyProfilesDictionaryPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionaryPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilesDictionaryPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionaryPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilesDictionaryPtrSlice(dest, []*ProfilesDictionary{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilesDictionaryPtrSlice(dest, src)
	assert.Equal(t, GenTestProfilesDictionaryPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesDictionaryUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewProfilesDictionary()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewProfilesDictionary(), dest)
}

func TestMarshalAndUnmarshalJSONProfilesDictionary(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesDictionary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewProfilesDictionary()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteProfilesDictionary(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoProfilesDictionaryFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesProfilesDictionary() {
		t.Run(name, func(t *testing.T) {
			dest := NewProfilesDictionary()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoProfilesDictionaryUnknown(t *testing.T) {
	dest := NewProfilesDictionary()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewProfilesDictionary(), dest)
}

func TestMarshalAndUnmarshalProtoProfilesDictionary(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesDictionary() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewProfilesDictionary()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteProfilesDictionary(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufProfilesDictionary(t *testing.T) {
	for name, src := range genTestEncodingValuesProfilesDictionary() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ProfilesDictionary{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewProfilesDictionary()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesProfilesDictionary() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"MappingTable/wrong_wire_type":   {0xc},
		"MappingTable/missing_value":     {0xa},
		"LocationTable/wrong_wire_type":  {0x14},
		"LocationTable/missing_value":    {0x12},
		"FunctionTable/wrong_wire_type":  {0x1c},
		"FunctionTable/missing_value":    {0x1a},
		"LinkTable/wrong_wire_type":      {0x24},
		"LinkTable/missing_value":        {0x22},
		"StringTable/wrong_wire_type":    {0x2c},
		"StringTable/missing_value":      {0x2a},
		"AttributeTable/wrong_wire_type": {0x34},
		"AttributeTable/missing_value":   {0x32},
		"StackTable/wrong_wire_type":     {0x3c},
		"StackTable/missing_value":       {0x3a},
	}
}

func genTestEncodingValuesProfilesDictionary() map[string]*ProfilesDictionary {
	return map[string]*ProfilesDictionary{
		"empty":               NewProfilesDictionary(),
		"MappingTable/test":   {MappingTable: []*Mapping{{}, GenTestMapping()}},
		"LocationTable/test":  {LocationTable: []*Location{{}, GenTestLocation()}},
		"FunctionTable/test":  {FunctionTable: []*Function{{}, GenTestFunction()}},
		"LinkTable/test":      {LinkTable: []*Link{{}, GenTestLink()}},
		"StringTable/test":    {StringTable: []string{"", "test_stringtable"}},
		"AttributeTable/test": {AttributeTable: []*KeyValueAndUnit{{}, GenTestKeyValueAndUnit()}},
		"StackTable/test":     {StackTable: []*Stack{{}, GenTestStack()}},
	}
}
