// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ScopeMetrics is a collection of metrics from a LibraryInstrumentation.
type ScopeMetrics struct {
	Scope     InstrumentationScope
	Metrics   []*Metric
	SchemaUrl string
}

var (
	protoPoolScopeMetrics = sync.Pool{
		New: func() any {
			return &ScopeMetrics{}
		},
	}
)

func NewScopeMetrics() *ScopeMetrics {
	if !UseProtoPooling.IsEnabled() {
		return &ScopeMetrics{}
	}
	return protoPoolScopeMetrics.Get().(*ScopeMetrics)
}

func DeleteScopeMetrics(orig *ScopeMetrics, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteInstrumentationScope(&orig.Scope, false)
	for i := range orig.Metrics {
		DeleteMetric(orig.Metrics[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolScopeMetrics.Put(orig)
	}
}

func CopyScopeMetrics(dest, src *ScopeMetrics) *ScopeMetrics {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewScopeMetrics()
	}
	CopyInstrumentationScope(&dest.Scope, &src.Scope)

	dest.Metrics = CopyMetricPtrSlice(dest.Metrics, src.Metrics)

	dest.SchemaUrl = src.SchemaUrl

	return dest
}

func CopyScopeMetricsSlice(dest, src []ScopeMetrics) []ScopeMetrics {
	var newDest []ScopeMetrics
	if cap(dest) < len(src) {
		newDest = make([]ScopeMetrics, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeMetrics(&dest[i], false)
		}
	}
	for i := range src {
		CopyScopeMetrics(&newDest[i], &src[i])
	}
	return newDest
}

func CopyScopeMetricsPtrSlice(dest, src []*ScopeMetrics) []*ScopeMetrics {
	var newDest []*ScopeMetrics
	if cap(dest) < len(src) {
		newDest = make([]*ScopeMetrics, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeMetrics()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeMetrics(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeMetrics()
		}
	}
	for i := range src {
		CopyScopeMetrics(newDest[i], src[i])
	}
	return newDest
}

func (orig *ScopeMetrics) Reset() {
	*orig = ScopeMetrics{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ScopeMetrics) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	orig.Scope.MarshalJSON(dest)
	if len(orig.Metrics) > 0 {
		dest.WriteObjectField("metrics")
		dest.WriteArrayStart()
		orig.Metrics[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Metrics); i++ {
			dest.WriteMore()
			orig.Metrics[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ScopeMetrics) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "scope":

			orig.Scope.UnmarshalJSON(iter)
		case "metrics":
			for iter.ReadArray() {
				orig.Metrics = append(orig.Metrics, NewMetric())
				orig.Metrics[len(orig.Metrics)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ScopeMetrics) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Scope.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Metrics {
		l = orig.Metrics[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ScopeMetrics) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Scope.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Metrics) - 1; i >= 0; i-- {
		l = orig.Metrics[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *ScopeMetrics) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Scope.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Metrics = append(orig.Metrics, NewMetric())
			err = orig.Metrics[len(orig.Metrics)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestScopeMetrics() *ScopeMetrics {
	orig := NewScopeMetrics()
	orig.Scope = *GenTestInstrumentationScope()
	orig.Metrics = []*Metric{{}, GenTestMetric()}
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

func GenTestScopeMetricsPtrSlice() []*ScopeMetrics {
	orig := make([]*ScopeMetrics, 5)
	orig[0] = NewScopeMetrics()
	orig[1] = GenTestScopeMetrics()
	orig[2] = NewScopeMetrics()
	orig[3] = GenTestScopeMetrics()
	orig[4] = NewScopeMetrics()
	return orig
}

func GenTestScopeMetricsSlice() []ScopeMetrics {
	orig := make([]ScopeMetrics, 5)
	orig[1] = *GenTestScopeMetrics()
	orig[3] = *GenTestScopeMetrics()
	return orig
}
