// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyValueType(t *testing.T) {
	for name, src := range genTestEncodingValuesValueType() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewValueType()
				CopyValueType(dest, src)
				assert.Equal(t, src, dest)
				CopyValueType(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyValueTypeSlice(t *testing.T) {
	src := []ValueType{}
	dest := []ValueType{}
	// Test CopyTo empty
	dest = CopyValueTypeSlice(dest, src)
	assert.Equal(t, []ValueType{}, dest)

	// Test CopyTo larger slice
	src = GenTestValueTypeSlice()
	dest = CopyValueTypeSlice(dest, src)
	assert.Equal(t, GenTestValueTypeSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyValueTypeSlice(dest, src)
	assert.Equal(t, GenTestValueTypeSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyValueTypeSlice(dest, []ValueType{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyValueTypeSlice(dest, src)
	assert.Equal(t, GenTestValueTypeSlice(), dest)
}

func TestCopyValueTypePtrSlice(t *testing.T) {
	src := []*ValueType{}
	dest := []*ValueType{}
	// Test CopyTo empty
	dest = CopyValueTypePtrSlice(dest, src)
	assert.Equal(t, []*ValueType{}, dest)

	// Test CopyTo larger slice
	src = GenTestValueTypePtrSlice()
	dest = CopyValueTypePtrSlice(dest, src)
	assert.Equal(t, GenTestValueTypePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyValueTypePtrSlice(dest, src)
	assert.Equal(t, GenTestValueTypePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyValueTypePtrSlice(dest, []*ValueType{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyValueTypePtrSlice(dest, src)
	assert.Equal(t, GenTestValueTypePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONValueTypeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewValueType()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewValueType(), dest)
}

func TestMarshalAndUnmarshalJSONValueType(t *testing.T) {
	for name, src := range genTestEncodingValuesValueType() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewValueType()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteValueType(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoValueTypeFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesValueType() {
		t.Run(name, func(t *testing.T) {
			dest := NewValueType()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoValueTypeUnknown(t *testing.T) {
	dest := NewValueType()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewValueType(), dest)
}

func TestMarshalAndUnmarshalProtoValueType(t *testing.T) {
	for name, src := range genTestEncodingValuesValueType() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewValueType()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteValueType(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufValueType(t *testing.T) {
	for name, src := range genTestEncodingValuesValueType() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ValueType{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewValueType()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesValueType() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"TypeStrindex/wrong_wire_type": {0xc},
		"TypeStrindex/missing_value":   {0x8},
		"UnitStrindex/wrong_wire_type": {0x14},
		"UnitStrindex/missing_value":   {0x10},
	}
}

func genTestEncodingValuesValueType() map[string]*ValueType {
	return map[string]*ValueType{
		"empty":             NewValueType(),
		"TypeStrindex/test": {TypeStrindex: int32(13)},
		"UnitStrindex/test": {UnitStrindex: int32(13)},
	}
}
