// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestSum_MoveTo(t *testing.T) {
	ms := generateTestSum()
	dest := NewSum()
	ms.MoveTo(dest)
	assert.Equal(t, NewSum(), ms)
	assert.Equal(t, generateTestSum(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestSum(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newSum(internal.NewSum(), sharedState)) })
	assert.Panics(t, func() { newSum(internal.NewSum(), sharedState).MoveTo(dest) })
}

func TestSum_CopyTo(t *testing.T) {
	ms := NewSum()
	orig := NewSum()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSum()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newSum(internal.NewSum(), sharedState)) })
}

func TestSum_DataPoints(t *testing.T) {
	ms := NewSum()
	assert.Equal(t, NewNumberDataPointSlice(), ms.DataPoints())
	ms.orig.DataPoints = internal.GenTestNumberDataPointPtrSlice()
	assert.Equal(t, generateTestNumberDataPointSlice(), ms.DataPoints())
}

func TestSum_AggregationTemporality(t *testing.T) {
	ms := NewSum()
	assert.Equal(t, AggregationTemporality(internal.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporality(internal.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestSum_IsMonotonic(t *testing.T) {
	ms := NewSum()
	assert.False(t, ms.IsMonotonic())
	ms.SetIsMonotonic(true)
	assert.True(t, ms.IsMonotonic())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSum(internal.NewSum(), sharedState).SetIsMonotonic(true) })
}

func generateTestSum() Sum {
	return newSum(internal.GenTestSum(), internal.NewState())
}
