// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestMapping_MoveTo(t *testing.T) {
	ms := generateTestMapping()
	dest := NewMapping()
	ms.MoveTo(dest)
	assert.Equal(t, NewMapping(), ms)
	assert.Equal(t, generateTestMapping(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestMapping(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newMapping(internal.NewMapping(), sharedState)) })
	assert.Panics(t, func() { newMapping(internal.NewMapping(), sharedState).MoveTo(dest) })
}

func TestMapping_CopyTo(t *testing.T) {
	ms := NewMapping()
	orig := NewMapping()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestMapping()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newMapping(internal.NewMapping(), sharedState)) })
}

func TestMapping_MemoryStart(t *testing.T) {
	ms := NewMapping()
	assert.Equal(t, uint64(0), ms.MemoryStart())
	ms.SetMemoryStart(uint64(13))
	assert.Equal(t, uint64(13), ms.MemoryStart())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMapping(internal.NewMapping(), sharedState).SetMemoryStart(uint64(13)) })
}

func TestMapping_MemoryLimit(t *testing.T) {
	ms := NewMapping()
	assert.Equal(t, uint64(0), ms.MemoryLimit())
	ms.SetMemoryLimit(uint64(13))
	assert.Equal(t, uint64(13), ms.MemoryLimit())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMapping(internal.NewMapping(), sharedState).SetMemoryLimit(uint64(13)) })
}

func TestMapping_FileOffset(t *testing.T) {
	ms := NewMapping()
	assert.Equal(t, uint64(0), ms.FileOffset())
	ms.SetFileOffset(uint64(13))
	assert.Equal(t, uint64(13), ms.FileOffset())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMapping(internal.NewMapping(), sharedState).SetFileOffset(uint64(13)) })
}

func TestMapping_FilenameStrindex(t *testing.T) {
	ms := NewMapping()
	assert.Equal(t, int32(0), ms.FilenameStrindex())
	ms.SetFilenameStrindex(int32(13))
	assert.Equal(t, int32(13), ms.FilenameStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMapping(internal.NewMapping(), sharedState).SetFilenameStrindex(int32(13)) })
}

func TestMapping_AttributeIndices(t *testing.T) {
	ms := NewMapping()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.AttributeIndices())
	ms.orig.AttributeIndices = internal.GenTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenTestInt32SliceWrapper()), ms.AttributeIndices())
}

func generateTestMapping() Mapping {
	return newMapping(internal.GenTestMapping(), internal.NewState())
}
