// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestProfilesData_MoveTo(t *testing.T) {
	ms := generateTestProfilesData()
	dest := NewProfilesData()
	ms.MoveTo(dest)
	assert.Equal(t, NewProfilesData(), ms)
	assert.Equal(t, generateTestProfilesData(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestProfilesData(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newProfilesData(internal.NewProfilesData(), sharedState)) })
	assert.Panics(t, func() { newProfilesData(internal.NewProfilesData(), sharedState).MoveTo(dest) })
}

func TestProfilesData_CopyTo(t *testing.T) {
	ms := NewProfilesData()
	orig := NewProfilesData()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestProfilesData()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newProfilesData(internal.NewProfilesData(), sharedState)) })
}

func TestProfilesData_ResourceProfiles(t *testing.T) {
	ms := NewProfilesData()
	assert.Equal(t, NewResourceProfilesSlice(), ms.ResourceProfiles())
	ms.getOrig().ResourceProfiles = internal.GenTestResourceProfilesPtrSlice()
	assert.Equal(t, generateTestResourceProfilesSlice(), ms.ResourceProfiles())
}

func TestProfilesData_Dictionary(t *testing.T) {
	ms := NewProfilesData()
	assert.Equal(t, NewProfilesDictionary(), ms.Dictionary())
	ms.getOrig().Dictionary = *internal.GenTestProfilesDictionary()
	assert.Equal(t, generateTestProfilesDictionary(), ms.Dictionary())
}

func generateTestProfilesData() ProfilesData {
	return newProfilesData(internal.GenTestProfilesData(), internal.NewState())
}
