// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package entity

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestEntityRef_MoveTo(t *testing.T) {
	ms := generateTestEntityRef()
	dest := NewEntityRef()
	ms.MoveTo(dest)
	assert.Equal(t, NewEntityRef(), ms)
	assert.Equal(t, generateTestEntityRef(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestEntityRef(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newEntityRef(internal.NewEntityRef(), sharedState)) })
	assert.Panics(t, func() { newEntityRef(internal.NewEntityRef(), sharedState).MoveTo(dest) })
}

func TestEntityRef_CopyTo(t *testing.T) {
	ms := NewEntityRef()
	orig := NewEntityRef()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestEntityRef()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newEntityRef(internal.NewEntityRef(), sharedState)) })
}

func TestEntityRef_SchemaUrl(t *testing.T) {
	ms := NewEntityRef()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newEntityRef(internal.NewEntityRef(), sharedState).SetSchemaUrl("test_schemaurl") })
}

func TestEntityRef_Type(t *testing.T) {
	ms := NewEntityRef()
	assert.Empty(t, ms.Type())
	ms.SetType("test_type")
	assert.Equal(t, "test_type", ms.Type())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newEntityRef(internal.NewEntityRef(), sharedState).SetType("test_type") })
}

func TestEntityRef_IdKeys(t *testing.T) {
	ms := NewEntityRef()
	assert.Equal(t, pcommon.NewStringSlice(), ms.IdKeys())
	ms.getOrig().IdKeys = internal.GenTestStringSlice()
	assert.Equal(t, pcommon.StringSlice(internal.GenTestStringSliceWrapper()), ms.IdKeys())
}

func TestEntityRef_DescriptionKeys(t *testing.T) {
	ms := NewEntityRef()
	assert.Equal(t, pcommon.NewStringSlice(), ms.DescriptionKeys())
	ms.getOrig().DescriptionKeys = internal.GenTestStringSlice()
	assert.Equal(t, pcommon.StringSlice(internal.GenTestStringSliceWrapper()), ms.DescriptionKeys())
}

func generateTestEntityRef() EntityRef {
	return newEntityRef(internal.GenTestEntityRef(), internal.NewState())
}
