// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/model/internal/data/protogen/metrics/v1"
)

func TestResourceMetricsSlice(t *testing.T) {
	es := NewResourceMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newResourceMetricsSlice(&[]*otlpmetrics.ResourceMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newResourceMetrics(&otlpmetrics.ResourceMetrics{})
	testVal := generateTestResourceMetrics()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestResourceMetrics(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestResourceMetricsSlice_CopyTo(t *testing.T) {
	dest := NewResourceMetricsSlice()
	// Test CopyTo to empty
	NewResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewResourceMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
}

func TestResourceMetricsSlice_EnsureCapacity(t *testing.T) {
	es := generateTestResourceMetricsSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ResourceMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ResourceMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestResourceMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestResourceMetricsSlice()
	dest := NewResourceMetricsSlice()
	src := generateTestResourceMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestResourceMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestResourceMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewResourceMetricsSlice()
	emptySlice.RemoveIf(func(el ResourceMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestResourceMetricsSlice()
	pos := 0
	filtered.RemoveIf(func(el ResourceMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	generateTestResourceMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestResourceMetrics(), ms)
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	fillTestResource(ms.Resource())
	assert.EqualValues(t, generateTestResource(), ms.Resource())
}

func TestResourceMetrics_SchemaUrl(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, "", ms.SchemaUrl())
	testValSchemaUrl := "https://opentelemetry.io/schemas/1.5.0"
	ms.SetSchemaUrl(testValSchemaUrl)
	assert.EqualValues(t, testValSchemaUrl, ms.SchemaUrl())
}

func TestResourceMetrics_InstrumentationLibraryMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), ms.InstrumentationLibraryMetrics())
	fillTestInstrumentationLibraryMetricsSlice(ms.InstrumentationLibraryMetrics())
	testValInstrumentationLibraryMetrics := generateTestInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, testValInstrumentationLibraryMetrics, ms.InstrumentationLibraryMetrics())
}

func TestInstrumentationLibraryMetricsSlice(t *testing.T) {
	es := NewInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newInstrumentationLibraryMetricsSlice(&[]*otlpmetrics.InstrumentationLibraryMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newInstrumentationLibraryMetrics(&otlpmetrics.InstrumentationLibraryMetrics{})
	testVal := generateTestInstrumentationLibraryMetrics()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestInstrumentationLibraryMetrics(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestInstrumentationLibraryMetricsSlice_CopyTo(t *testing.T) {
	dest := NewInstrumentationLibraryMetricsSlice()
	// Test CopyTo to empty
	NewInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
}

func TestInstrumentationLibraryMetricsSlice_EnsureCapacity(t *testing.T) {
	es := generateTestInstrumentationLibraryMetricsSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestInstrumentationLibraryMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestInstrumentationLibraryMetricsSlice()
	dest := NewInstrumentationLibraryMetricsSlice()
	src := generateTestInstrumentationLibraryMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestInstrumentationLibraryMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestInstrumentationLibraryMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewInstrumentationLibraryMetricsSlice()
	emptySlice.RemoveIf(func(el InstrumentationLibraryMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestInstrumentationLibraryMetricsSlice()
	pos := 0
	filtered.RemoveIf(func(el InstrumentationLibraryMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestInstrumentationLibraryMetrics_CopyTo(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	generateTestInstrumentationLibraryMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetrics(), ms)
}

func TestInstrumentationLibraryMetrics_InstrumentationLibrary(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibrary(ms.InstrumentationLibrary())
	assert.EqualValues(t, generateTestInstrumentationLibrary(), ms.InstrumentationLibrary())
}

func TestInstrumentationLibraryMetrics_SchemaUrl(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	assert.EqualValues(t, "", ms.SchemaUrl())
	testValSchemaUrl := "https://opentelemetry.io/schemas/1.5.0"
	ms.SetSchemaUrl(testValSchemaUrl)
	assert.EqualValues(t, testValSchemaUrl, ms.SchemaUrl())
}

func TestInstrumentationLibraryMetrics_Metrics(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	assert.EqualValues(t, NewMetricSlice(), ms.Metrics())
	fillTestMetricSlice(ms.Metrics())
	testValMetrics := generateTestMetricSlice()
	assert.EqualValues(t, testValMetrics, ms.Metrics())
}

func TestMetricSlice(t *testing.T) {
	es := NewMetricSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newMetricSlice(&[]*otlpmetrics.Metric{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newMetric(&otlpmetrics.Metric{})
	testVal := generateTestMetric()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestMetric(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestMetricSlice_CopyTo(t *testing.T) {
	dest := NewMetricSlice()
	// Test CopyTo to empty
	NewMetricSlice().CopyTo(dest)
	assert.EqualValues(t, NewMetricSlice(), dest)

	// Test CopyTo larger slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)

	// Test CopyTo same size slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
}

func TestMetricSlice_EnsureCapacity(t *testing.T) {
	es := generateTestMetricSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Metric]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Metric]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestMetricSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestMetricSlice()
	dest := NewMetricSlice()
	src := generateTestMetricSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestMetricSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestMetricSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewMetricSlice()
	emptySlice.RemoveIf(func(el Metric) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestMetricSlice()
	pos := 0
	filtered.RemoveIf(func(el Metric) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	generateTestMetric().CopyTo(ms)
	assert.EqualValues(t, generateTestMetric(), ms)
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Name())
	testValName := "test_name"
	ms.SetName(testValName)
	assert.EqualValues(t, testValName, ms.Name())
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Description())
	testValDescription := "test_description"
	ms.SetDescription(testValDescription)
	assert.EqualValues(t, testValDescription, ms.Description())
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Unit())
	testValUnit := "1"
	ms.SetUnit(testValUnit)
	assert.EqualValues(t, testValUnit, ms.Unit())
}

func TestGauge_CopyTo(t *testing.T) {
	ms := NewGauge()
	generateTestGauge().CopyTo(ms)
	assert.EqualValues(t, generateTestGauge(), ms)
}

func TestGauge_DataPoints(t *testing.T) {
	ms := NewGauge()
	assert.EqualValues(t, NewNumberDataPointSlice(), ms.DataPoints())
	fillTestNumberDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestNumberDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestSum_CopyTo(t *testing.T) {
	ms := NewSum()
	generateTestSum().CopyTo(ms)
	assert.EqualValues(t, generateTestSum(), ms)
}

func TestSum_AggregationTemporality(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestSum_IsMonotonic(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestSum_DataPoints(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, NewNumberDataPointSlice(), ms.DataPoints())
	fillTestNumberDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestNumberDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestHistogram_CopyTo(t *testing.T) {
	ms := NewHistogram()
	generateTestHistogram().CopyTo(ms)
	assert.EqualValues(t, generateTestHistogram(), ms)
}

func TestHistogram_AggregationTemporality(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestHistogram_DataPoints(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, NewHistogramDataPointSlice(), ms.DataPoints())
	fillTestHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestSummary_CopyTo(t *testing.T) {
	ms := NewSummary()
	generateTestSummary().CopyTo(ms)
	assert.EqualValues(t, generateTestSummary(), ms)
}

func TestSummary_DataPoints(t *testing.T) {
	ms := NewSummary()
	assert.EqualValues(t, NewSummaryDataPointSlice(), ms.DataPoints())
	fillTestSummaryDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestSummaryDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestNumberDataPointSlice(t *testing.T) {
	es := NewNumberDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newNumberDataPointSlice(&[]*otlpmetrics.NumberDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newNumberDataPoint(&otlpmetrics.NumberDataPoint{})
	testVal := generateTestNumberDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestNumberDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestNumberDataPointSlice_CopyTo(t *testing.T) {
	dest := NewNumberDataPointSlice()
	// Test CopyTo to empty
	NewNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewNumberDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
}

func TestNumberDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestNumberDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.NumberDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.NumberDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestNumberDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestNumberDataPointSlice()
	dest := NewNumberDataPointSlice()
	src := generateTestNumberDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestNumberDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestNumberDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewNumberDataPointSlice()
	emptySlice.RemoveIf(func(el NumberDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestNumberDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el NumberDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestNumberDataPoint_CopyTo(t *testing.T) {
	ms := NewNumberDataPoint()
	generateTestNumberDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestNumberDataPoint(), ms)
}

func TestNumberDataPoint_Attributes(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, NewAttributeMap(), ms.Attributes())
	fillTestAttributeMap(ms.Attributes())
	testValAttributes := generateTestAttributeMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestNumberDataPoint_StartTimestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestNumberDataPoint_Timestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestNumberDataPoint_DoubleVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, float64(0.0), ms.DoubleVal())
	testValDoubleVal := float64(17.13)
	ms.SetDoubleVal(testValDoubleVal)
	assert.EqualValues(t, testValDoubleVal, ms.DoubleVal())
}
func TestNumberDataPoint_IntVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, int64(0), ms.IntVal())
	testValIntVal := int64(17)
	ms.SetIntVal(testValIntVal)
	assert.EqualValues(t, testValIntVal, ms.IntVal())
}

func TestNumberDataPoint_Exemplars(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestHistogramDataPointSlice(t *testing.T) {
	es := NewHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newHistogramDataPointSlice(&[]*otlpmetrics.HistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{})
	testVal := generateTestHistogramDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestHistogramDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewHistogramDataPointSlice()
	// Test CopyTo to empty
	NewHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
}

func TestHistogramDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestHistogramDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.HistogramDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.HistogramDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestHistogramDataPointSlice()
	dest := NewHistogramDataPointSlice()
	src := generateTestHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestHistogramDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewHistogramDataPointSlice()
	emptySlice.RemoveIf(func(el HistogramDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestHistogramDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el HistogramDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewHistogramDataPoint()
	generateTestHistogramDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestHistogramDataPoint(), ms)
}

func TestHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewAttributeMap(), ms.Attributes())
	fillTestAttributeMap(ms.Attributes())
	testValAttributes := generateTestAttributeMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestHistogramDataPoint_Count(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestHistogramDataPoint_Sum(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, []uint64(nil), ms.BucketCounts())
	testValBucketCounts := []uint64{1, 2, 3}
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, []float64(nil), ms.ExplicitBounds())
	testValExplicitBounds := []float64{1, 2, 3}
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestSummaryDataPointSlice(t *testing.T) {
	es := NewSummaryDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newSummaryDataPointSlice(&[]*otlpmetrics.SummaryDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newSummaryDataPoint(&otlpmetrics.SummaryDataPoint{})
	testVal := generateTestSummaryDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestSummaryDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestSummaryDataPointSlice_CopyTo(t *testing.T) {
	dest := NewSummaryDataPointSlice()
	// Test CopyTo to empty
	NewSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewSummaryDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
}

func TestSummaryDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestSummaryDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestSummaryDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestSummaryDataPointSlice()
	dest := NewSummaryDataPointSlice()
	src := generateTestSummaryDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestSummaryDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSummaryDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewSummaryDataPointSlice()
	emptySlice.RemoveIf(func(el SummaryDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestSummaryDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el SummaryDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestSummaryDataPoint_CopyTo(t *testing.T) {
	ms := NewSummaryDataPoint()
	generateTestSummaryDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestSummaryDataPoint(), ms)
}

func TestSummaryDataPoint_Attributes(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewAttributeMap(), ms.Attributes())
	fillTestAttributeMap(ms.Attributes())
	testValAttributes := generateTestAttributeMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestSummaryDataPoint_StartTimestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestSummaryDataPoint_Timestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestSummaryDataPoint_Count(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestSummaryDataPoint_Sum(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestSummaryDataPoint_QuantileValues(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewValueAtQuantileSlice(), ms.QuantileValues())
	fillTestValueAtQuantileSlice(ms.QuantileValues())
	testValQuantileValues := generateTestValueAtQuantileSlice()
	assert.EqualValues(t, testValQuantileValues, ms.QuantileValues())
}

func TestValueAtQuantileSlice(t *testing.T) {
	es := NewValueAtQuantileSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newValueAtQuantileSlice(&[]*otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newValueAtQuantile(&otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	testVal := generateTestValueAtQuantile()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestValueAtQuantile(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestValueAtQuantileSlice_CopyTo(t *testing.T) {
	dest := NewValueAtQuantileSlice()
	// Test CopyTo to empty
	NewValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, NewValueAtQuantileSlice(), dest)

	// Test CopyTo larger slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)

	// Test CopyTo same size slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
}

func TestValueAtQuantileSlice_EnsureCapacity(t *testing.T) {
	es := generateTestValueAtQuantileSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestValueAtQuantileSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestValueAtQuantileSlice()
	dest := NewValueAtQuantileSlice()
	src := generateTestValueAtQuantileSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestValueAtQuantileSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestValueAtQuantileSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewValueAtQuantileSlice()
	emptySlice.RemoveIf(func(el ValueAtQuantile) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestValueAtQuantileSlice()
	pos := 0
	filtered.RemoveIf(func(el ValueAtQuantile) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewValueAtQuantile()
	generateTestValueAtQuantile().CopyTo(ms)
	assert.EqualValues(t, generateTestValueAtQuantile(), ms)
}

func TestValueAtQuantile_Quantile(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Quantile())
	testValQuantile := float64(17.13)
	ms.SetQuantile(testValQuantile)
	assert.EqualValues(t, testValQuantile, ms.Quantile())
}

func TestValueAtQuantile_Value(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestExemplarSlice(t *testing.T) {
	es := NewExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newExemplarSlice(&[]otlpmetrics.Exemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newExemplar(&otlpmetrics.Exemplar{})
	testVal := generateTestExemplar()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestExemplar(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestExemplarSlice_CopyTo(t *testing.T) {
	dest := NewExemplarSlice()
	// Test CopyTo to empty
	NewExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
}

func TestExemplarSlice_EnsureCapacity(t *testing.T) {
	es := generateTestExemplarSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Exemplar]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Exemplar]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
}

func TestExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestExemplarSlice()
	dest := NewExemplarSlice()
	src := generateTestExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExemplarSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExemplarSlice()
	emptySlice.RemoveIf(func(el Exemplar) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestExemplarSlice()
	pos := 0
	filtered.RemoveIf(func(el Exemplar) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestExemplar_CopyTo(t *testing.T) {
	ms := NewExemplar()
	generateTestExemplar().CopyTo(ms)
	assert.EqualValues(t, generateTestExemplar(), ms)
}

func TestExemplar_Timestamp(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestExemplar_DoubleVal(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, float64(0.0), ms.DoubleVal())
	testValDoubleVal := float64(17.13)
	ms.SetDoubleVal(testValDoubleVal)
	assert.EqualValues(t, testValDoubleVal, ms.DoubleVal())
}
func TestExemplar_IntVal(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, int64(0), ms.IntVal())
	testValIntVal := int64(17)
	ms.SetIntVal(testValIntVal)
	assert.EqualValues(t, testValIntVal, ms.IntVal())
}

func TestExemplar_FilteredAttributes(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, NewAttributeMap(), ms.FilteredAttributes())
	fillTestAttributeMap(ms.FilteredAttributes())
	testValFilteredAttributes := generateTestAttributeMap()
	assert.EqualValues(t, testValFilteredAttributes, ms.FilteredAttributes())
}

func generateTestResourceMetricsSlice() ResourceMetricsSlice {
	tv := NewResourceMetricsSlice()
	fillTestResourceMetricsSlice(tv)
	return tv
}

func fillTestResourceMetricsSlice(tv ResourceMetricsSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestResourceMetrics(tv.AppendEmpty())
	}
}

func generateTestResourceMetrics() ResourceMetrics {
	tv := NewResourceMetrics()
	fillTestResourceMetrics(tv)
	return tv
}

func fillTestResourceMetrics(tv ResourceMetrics) {
	fillTestResource(tv.Resource())
	tv.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	fillTestInstrumentationLibraryMetricsSlice(tv.InstrumentationLibraryMetrics())
}

func generateTestInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	tv := NewInstrumentationLibraryMetricsSlice()
	fillTestInstrumentationLibraryMetricsSlice(tv)
	return tv
}

func fillTestInstrumentationLibraryMetricsSlice(tv InstrumentationLibraryMetricsSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestInstrumentationLibraryMetrics(tv.AppendEmpty())
	}
}

func generateTestInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	tv := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibraryMetrics(tv)
	return tv
}

func fillTestInstrumentationLibraryMetrics(tv InstrumentationLibraryMetrics) {
	fillTestInstrumentationLibrary(tv.InstrumentationLibrary())
	tv.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	fillTestMetricSlice(tv.Metrics())
}

func generateTestMetricSlice() MetricSlice {
	tv := NewMetricSlice()
	fillTestMetricSlice(tv)
	return tv
}

func fillTestMetricSlice(tv MetricSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestMetric(tv.AppendEmpty())
	}
}

func generateTestMetric() Metric {
	tv := NewMetric()
	fillTestMetric(tv)
	return tv
}

func fillTestMetric(tv Metric) {
	tv.SetName("test_name")
	tv.SetDescription("test_description")
	tv.SetUnit("1")
	(*tv.orig).Data = &otlpmetrics.Metric_Gauge{Gauge: &otlpmetrics.Gauge{}}
	fillTestGauge(tv.Gauge())
}

func generateTestGauge() Gauge {
	tv := NewGauge()
	fillTestGauge(tv)
	return tv
}

func fillTestGauge(tv Gauge) {
	fillTestNumberDataPointSlice(tv.DataPoints())
}

func generateTestSum() Sum {
	tv := NewSum()
	fillTestSum(tv)
	return tv
}

func fillTestSum(tv Sum) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestNumberDataPointSlice(tv.DataPoints())
}

func generateTestHistogram() Histogram {
	tv := NewHistogram()
	fillTestHistogram(tv)
	return tv
}

func fillTestHistogram(tv Histogram) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	fillTestHistogramDataPointSlice(tv.DataPoints())
}

func generateTestSummary() Summary {
	tv := NewSummary()
	fillTestSummary(tv)
	return tv
}

func fillTestSummary(tv Summary) {
	fillTestSummaryDataPointSlice(tv.DataPoints())
}

func generateTestNumberDataPointSlice() NumberDataPointSlice {
	tv := NewNumberDataPointSlice()
	fillTestNumberDataPointSlice(tv)
	return tv
}

func fillTestNumberDataPointSlice(tv NumberDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestNumberDataPoint(tv.AppendEmpty())
	}
}

func generateTestNumberDataPoint() NumberDataPoint {
	tv := NewNumberDataPoint()
	fillTestNumberDataPoint(tv)
	return tv
}

func fillTestNumberDataPoint(tv NumberDataPoint) {
	fillTestAttributeMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetDoubleVal(float64(17.13))

	fillTestExemplarSlice(tv.Exemplars())
}

func generateTestHistogramDataPointSlice() HistogramDataPointSlice {
	tv := NewHistogramDataPointSlice()
	fillTestHistogramDataPointSlice(tv)
	return tv
}

func fillTestHistogramDataPointSlice(tv HistogramDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestHistogramDataPoint(tv.AppendEmpty())
	}
}

func generateTestHistogramDataPoint() HistogramDataPoint {
	tv := NewHistogramDataPoint()
	fillTestHistogramDataPoint(tv)
	return tv
}

func fillTestHistogramDataPoint(tv HistogramDataPoint) {
	fillTestAttributeMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	tv.SetBucketCounts([]uint64{1, 2, 3})
	tv.SetExplicitBounds([]float64{1, 2, 3})
	fillTestExemplarSlice(tv.Exemplars())
}

func generateTestSummaryDataPointSlice() SummaryDataPointSlice {
	tv := NewSummaryDataPointSlice()
	fillTestSummaryDataPointSlice(tv)
	return tv
}

func fillTestSummaryDataPointSlice(tv SummaryDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestSummaryDataPoint(tv.AppendEmpty())
	}
}

func generateTestSummaryDataPoint() SummaryDataPoint {
	tv := NewSummaryDataPoint()
	fillTestSummaryDataPoint(tv)
	return tv
}

func fillTestSummaryDataPoint(tv SummaryDataPoint) {
	fillTestAttributeMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	fillTestValueAtQuantileSlice(tv.QuantileValues())
}

func generateTestValueAtQuantileSlice() ValueAtQuantileSlice {
	tv := NewValueAtQuantileSlice()
	fillTestValueAtQuantileSlice(tv)
	return tv
}

func fillTestValueAtQuantileSlice(tv ValueAtQuantileSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestValueAtQuantile(tv.AppendEmpty())
	}
}

func generateTestValueAtQuantile() ValueAtQuantile {
	tv := NewValueAtQuantile()
	fillTestValueAtQuantile(tv)
	return tv
}

func fillTestValueAtQuantile(tv ValueAtQuantile) {
	tv.SetQuantile(float64(17.13))
	tv.SetValue(float64(17.13))
}

func generateTestExemplarSlice() ExemplarSlice {
	tv := NewExemplarSlice()
	fillTestExemplarSlice(tv)
	return tv
}

func fillTestExemplarSlice(tv ExemplarSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestExemplar(tv.AppendEmpty())
	}
}

func generateTestExemplar() Exemplar {
	tv := NewExemplar()
	fillTestExemplar(tv)
	return tv
}

func fillTestExemplar(tv Exemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetDoubleVal(float64(17.13))

	fillTestAttributeMap(tv.FilteredAttributes())
}
