import QtQuick
import QtQuick.VirtualKeyboard
import QtQuick.VirtualKeyboard.Styles

KeyPanel {
    id: root

    Rectangle {
        id: keyboardEnterKey
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.rightMargin: 6
        anchors.leftMargin: 6
        anchors.bottomMargin: 6
        anchors.topMargin: 6
        color: "#5E5E5E"
        radius: 24
        border.color: "#222840"
        border.width: 1

        Text {
            id: label
            color: "#ffffff"
            text: "enter"
            anchors.fill: parent
            font.pixelSize: 36
            horizontalAlignment: Text.AlignRight
            verticalAlignment: Text.AlignBottom
            bottomPadding: 13
            rightPadding: 25
            font.family: "Arial"
        }

        GlowRectangle {
            id: rectangle4Outline
            anchors.fill: keyboardEnterKey
            glowRectRadius: 24
            visible: root.control.pressed
        }
    }
}
/*##^##
Designer {
    D{i:0;uuid:"fca4d525-2cac-5d53-a981-4631ef7d7c23"}D{i:1;uuid:"61296e88-d414-53c8-9526-d5547be19bda"}
}
##^##*/

