import QtQuick
import QtQuick3D
import QtQuick3D.Particles3D

ParticleSystem3D {
    id: rainMist

    property bool show: false
    property real showAnimated: show

    Behavior on showAnimated {
        NumberAnimation {
            duration: 1200
            easing.type: Easing.InOutQuad
        }
    }

    y: (1.0 - showAnimated) * 100
    opacity: 0.7
    visible: showAnimated
    paused: !show
    startTime: 10000

    SpriteParticle3D {
        id: rainMistParticle
        color: "#31e3eaf2"
        sortMode: Particle3D.SortDistance
        blendMode: SpriteParticle3D.SourceOver
        colorVariation.w: 0.2
        Texture {
            id: rainMistTexture
            source: "images/smoke2.png"
        }
        SpriteSequence3D {
            id: rainMistSequence
            duration: 4000
            frameCount: 15
        }
        billboard: true
        maxAmount: 80
        fadeOutDuration: 1000
        fadeInDuration: 500
        //sortMode: Particle3D.SortNewest
        spriteSequence: rainMistSequence
        fadeInEffect: Particle3D.FadeOpacity
        sprite: rainMistTexture
    }
    ParticleEmitter3D {
        id: rainMistEmitter
        x: -20
        opacity: 0.59
        scale.x: 1.0
        scale.y: 0.5
        scale.z: 1.0
        shape: ParticleShape3D {
            type: ParticleShape3D.Cube
            fill: true
        }
        particleScale: 12
        particleScaleVariation: 5
        particleEndScale: 20
        particleEndScaleVariation: 10
        lifeSpan: 3500
        emitRate: 20
        lifeSpanVariation: 500
        particle: rainMistParticle
        VectorDirection3D {
            id: rainMistDirection
            direction.x: 40
            direction.y: 0
            direction.z: 0
            directionVariation.x: 10
            directionVariation.y: 10
            directionVariation.z: 10
        }
        velocity: rainMistDirection
        depthBias: 100000
    }

    Node {
        id: __materialLibrary__
    }

}
