
/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Effects
import SimpleEffectComposerDemo
import QtQuick.Studio.Components
import QtQuick3D.Helpers
import QtQuick.Studio.DesignEffects
import Generated.Effects.DisplaceEffect 1.0
import Generated.Effects.SwirlGlowEffect 1.0
import Generated.Effects.NoiseEffect 1.0
import Generated.Effects.ThunderRainEffect 1.0
import Generated.QtQuick3D.MaterialBall1
import QtQuick.Layouts

Rectangle {
    id: root

    property double displaceValue: 0.50
    property double bloomValue: 1.6
    property double blurValue: 0.75
    property double brightnessValue: 0.5
    property double wavelengthValue: 4.5
    property double amplitudeValue: 0.45
    property double phaseValue: 0.3
    property double noiseValue: 0.65
    property double rainLayerValue: 6
    property double windValue: -0.5
    property double strikeValue: 0.4

    anchors.fill: parent
    gradient: Gradient {
        GradientStop {
            position: 0.5
            color: "#00414a"
        }

        GradientStop {
            position: 1
            color: "#001011"
        }
    }

    ThunderRainEffect {
        id: thunderRainEffect

        rainLayers: root.rainLayerValue
        rainWind: root.windValue
        thunderStrikeOccurrence: root.strikeValue
        timeRunning: false
        visible: false
    }

    View3D {
        id: view3D

        anchors.fill: parent
        environment: sceneEnvironment

        SceneEnvironment {
            id: sceneEnvironment

            backgroundMode: SceneEnvironment.Transparent
            lightProbe: basicLights1_4K
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.High
        }

        Node {
            id: scene

            DirectionalLight {
                id: directionalLight

                x: 408
                y: -269
                z: 269
            }

            PerspectiveCamera {
                id: sceneCamera

                x: 0
                y: 70
                z: 360
            }

            MaterialBall1 {
                id: materialBall_Qt

                scale.z: 90
                scale.y: 90
                scale.x: 90
                visible: true
            }
        }

        OrbitCameraController {
            id: orbitCameraController

            yInvert: false
            xInvert: true
            camera: sceneCamera
            origin: materialBall_Qt
        }

        DisplaceEffect {
            id: displaceEffect

            displaceDisplacement: root.displaceValue
            visible: false
        }

        SwirlGlowEffect {
            id: swirlGlowEffect

            glowBloom: root.bloomValue
            glowBlurAmount: root.blurValue
            glowMaxBrightness: root.brightnessValue
            swirlWaveLength: root.wavelengthValue
            swirlAmplitude: root.amplitudeValue
            swirlPhase: root.phaseValue
            visible: false
        }

        NoiseEffect {
            id: noiseEffect

            noiseAmount: root.noiseValue
            timeRunning: false
            visible: false
        }
    }

    Item {
        id: __materialLibrary__

        PrincipledMaterial {
            id: defaultMaterial

            objectName: "Default Material"
            baseColor: "#2cde85"
        }

        Texture {
            id: basicLights1_4K

            source: "images/BasicLights1_4K.hdr"
            objectName: "Basic Lights1 4K"
        }
    }

    ControlOverlay {
        id: controls

        anchors.fill: parent
    }

    WelcomeOverlay {
        id: welcomeOverlay

        anchors.fill: parent
    }

    states: [
        State {
            name: "noEffect"
            when: !controls.displaceButton.checked && !controls.glowAndSwirlButton.checked && !controls.noiseButton.checked && !controls.rainAndThunderButton.checked

            PropertyChanges {
                target: root
                displaceValue: 0
                bloomValue: 0
                blurValue: 0
                brightnessValue: 0
                wavelengthValue: 0
                amplitudeValue: 0
                phaseValue: 0
                noiseValue: 0
                rainLayerValue: 0
                windValue: 0
                strikeValue: 0
            }
        },

        State {
            name: "displace"
            when: controls.displaceButton.checked

            PropertyChanges {
                target: root
                bloomValue: 0
                blurValue: 0
                brightnessValue: 0
                wavelengthValue: 0
                amplitudeValue: 0
                phaseValue: 0
                noiseValue: 0
                rainLayerValue: 0
                windValue: 0
                strikeValue: 0
            }

            PropertyChanges {
                target: swirlGlowEffect
                visible: false
            }

            PropertyChanges {
                target: noiseEffect
                visible: false
            }

            PropertyChanges {
                target: thunderRainEffect
                visible: false
            }

            PropertyChanges {
                target: displaceEffect
                visible: true
            }
        },

        State {
            name: "glowAndSwirl"
            when: controls.glowAndSwirlButton.checked

            PropertyChanges {
                target: root
                displaceValue: 0
                noiseValue: 0
                rainLayerValue: 0
                windValue: 0
                strikeValue: 0
            }

            PropertyChanges {
                target: displaceEffect
                visible: false
            }

            PropertyChanges {
                target: noiseEffect
                visible: false
            }

            PropertyChanges {
                target: thunderRainEffect
                visible: false
            }

            PropertyChanges {
                target: swirlGlowEffect
                visible: true
            }
        },

        State {
            name: "noise"
            when: controls.noiseButton.checked

            PropertyChanges {
                target: root
                displaceValue: 0
                bloomValue: 0
                blurValue: 0
                brightnessValue: 0
                wavelengthValue: 0
                amplitudeValue: 0
                phaseValue: 0
                rainLayerValue: 0
                windValue: 0
                strikeValue: 0
            }

            PropertyChanges {
                target: displaceEffect
                visible: false
            }

            PropertyChanges {
                target: swirlGlowEffect
                visible: false
            }

            PropertyChanges {
                target: thunderRainEffect
                visible: false
            }

            PropertyChanges {
                target: noiseEffect
                visible: true
                timeRunning: true
            }
        },

        State {
            name: "rainAndThunder"
            when: controls.rainAndThunderButton.checked

            PropertyChanges {
                target: root
                displaceValue: 0
                bloomValue: 0
                blurValue: 0
                brightnessValue: 0
                wavelengthValue: 0
                amplitudeValue: 0
                phaseValue: 0
                noiseValue: 0
            }

            PropertyChanges {
                target: displaceEffect
                visible: false
            }

            PropertyChanges {
                target: swirlGlowEffect
                visible: false
            }

            PropertyChanges {
                target: noiseEffect
                visible: false
            }

            PropertyChanges {
                target: thunderRainEffect
                visible: true
                timeRunning: true
            }
        }
    ]

    transitions: [
        Transition {
            id: diplaceTransition

            SequentialAnimation {
                PropertyAnimation {
                    target: root
                    property: "displaceValue"
                    duration: 500
                }
            }
            from: "*"
            to: "displace"
        },

        Transition {
            id: glowTransition

            SequentialAnimation {
                PropertyAnimation {
                    target: root
                    properties: "bloomValue,blurValue,brightnessValue,wavelengthValue,amplitudeValue,phaseValue"
                    duration: 500
                }
            }
            from: "*"
            to: "glowAndSwirl"
        },

        Transition {
            id: noiseTransition

            SequentialAnimation {
                PropertyAnimation {
                    target: root
                    property: "noiseValue"
                    duration: 500
                }
            }
            from: "*"
            to: "noise"
        },

        Transition {
            id: rainTransition

            SequentialAnimation {
                PropertyAnimation {
                    target: root
                    properties: "rainLayerValue,windValue,strikeValue"
                    duration: 500
                }
            }
            from: "*"
            to: "rainAndThunder"
        }
    ]
}

/*##^##
Designer {
    D{i:0;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere"}
D{i:5;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}D{i:7;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/

