// EXchess source code, (c) Daniel C. Homan  1997-2017
// Released under the GNU public license, see file license.txt

/* Header for score.cpp */

#ifndef SCORE_H
#define SCORE_H

#define AVERAGE_SCORE(x,y)  (((x)*(12-MIN(12,gstage))+(y)*MIN(12,gstage))/12)

int SIDE_ON_MOVE_EARLY =  10; //  10;
int SIDE_ON_MOVE_LATE =    0; //   0;

int DOUBLED_PAWN_EARLY =  18;
int DOUBLED_PAWN_LATE  =  18;
int WEAK_PAWN_EARLY =      6;  // 9
int WEAK_PAWN_LATE =       0;  // -5
int BACKWARD_PAWN_EARLY =  4; 
int BACKWARD_PAWN_LATE  = 19;
int PAWN_ISLAND_EARLY =  12;
int PAWN_ISLAND_LATE =   13;
int PAWN_DUO =            3;
int SPACE =              12;
int PASSED_PAWN =        59; // 59;  // 61;
int WRONG_BISHOP =       52; // 44; // 37;  
int CON_PASSED_PAWNS =   65; // 65; // 72;
int OUTSIDE_PASSED_PAWN = 7; //  3; // 10; 
int FREE_PASSED_PAWN =    9; // 21; // 27;

int BISHOP_MOBILITY =    27;  // 28;
int ROOK_MOBILITY =      22; // 19;  // 10;
int QUEEN_MOBILITY =     15;  // 11;
int KNIGHT_MOBILITY =    12;
int BISHOP_PAIR =        46;  
int MINOR_OUTPOST =      40; // 15;   //9
int MINOR_OUTP_UNGUARD = 19; // 6;   //9
int MINOR_BLOCKER =      29; // 41;   //33
int BMINOR_OUTPOST =     21; // 6;   //9
int BMINOR_OUTP_UNGUARD = 0; // 3   //9
int BMINOR_BLOCKER =     34; // 16;   //33

int PAWN_THREAT_MINOR =  35;
int PAWN_THREAT_MAJOR =  35;

int ROOK_OPEN_FILE =     27; // 33;
int ROOK_HALF_OPEN_FILE= 24; // 27;
//int CONNECTED_ROOKS =    20;
int BOXED_IN_ROOK =      87; //164;

int CASTLED =             5;
int NO_POSSIBLE_CASTLE =  3;

int TRADES_EARLY =        5;
int TRADES_LATE =        30;



// Outpost squares and bitmasks for setting which outposts 
// are filled
/*
char white_outpost[12] = { 42,43,44,45,34,35,36,37,26,27,28,29 };
char black_outpost[12] = { 18,19,20,21,26,27,28,29,34,35,36,37 };
uint16_t bitmask[12] = { 1,2,4,8,16,32,64,128,256,512,1024,2048 };
uint16_t outpost_trans[64] =    // from the POV of black, just like piece-sq, see below
{
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    1,    2,    4,    8,    0,    0,
          0,    0,   16,   32,   64,  128,    0,    0,
          0,    0,  256,  512, 1024, 2048,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0,
          0,    0,    0,    0,    0,    0,    0,    0
};
*/

// Value of the pieces
//  -- note if difference between BISHOP and KNIGHT is > 49, then
//     need to make some other changes to margins elsewhere
int value[7] = { 0, 100, 377, 399, 596, 1197, 10000 };

// Scaling of king attack scores
//#define ATTACK_SCALE(x)  MAX(0, (VAR1*sqrt(x) + VAR2*x*x - VAR3))
//#define ATTACK_SCALE(x)  MAX(0, (21.38*sqrt(x) + 3.21*x*x - 89.4))

char attack_scale[16] = { 0, 1, 2, 4, 9, 14, 19, 24, 29, 34, 39, 44, 49, 54, 57, 60 }; 

// Piece square tables
//int piece_sq[2][7][64];

// proto-types for piece square tables, first index is for the stage of
// the game, 2nd index is for piece
// stage 0 = opening
// stage 1 = early middle-game
// stage 2 = late middle-game
// stage 3 = ending


char piece_sq[4][7][64] = {    // note values cannot exceed +127 or -127!

// Reading these is a little tricky.  These tables
// are set up to look like a chess board from white's
// point of view, but they are indexed from black's
// point of view.  The whitef array is used to
// map these values to the right squares for white.
{
// Table for piece =   in stage 0
{
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = PAWN in stage 0
{
 -106,  -106,  -106,  -106,  -106,  -106,  -106,  -106, 
  -59,   -59,   -56,   -52,   -52,   -56,   -59,   -59, 
  -35,   -32,   -29,   -19,   -19,   -29,   -32,   -35, 
  -23,   -17,    -7,     8,     8,    -7,   -17,   -23, 
  -17,   -11,    -1,    13,    13,    -1,   -11,   -17, 
  -14,   -11,    -8,     1,     1,    -8,   -11,   -14, 
  -13,   -13,   -10,    -6,    -6,   -10,   -13,   -13, 
  -11,   -11,   -11,   -11,   -11,   -11,   -11,   -11
},
// Table for piece = KNIGHT in stage 0
{
   -6,    -4,    -2,    -2,    -2,    -2,    -4,    -6, 
   -4,     4,     4,     4,     4,     4,     4,    -4, 
   -2,     4,     9,     9,     9,     9,     4,    -2, 
   -2,     4,     9,    16,    16,     9,     4,    -2, 
   -2,     4,     9,    16,    16,     9,     4,    -2, 
   -2,     4,     9,     9,     9,     9,     4,    -2, 
   -4,     4,     4,     4,     4,     4,     4,    -4, 
   -6,    -4,    -2,    -2,    -2,    -2,    -4,    -6
},
// Table for piece = BISHOP in stage 0
{
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1
},
// Table for piece = ROOK in stage 0
{
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     6,     9,     9,     6,     1,     1
},
// Table for piece = QUEEN in stage 0
{
    2,     2,     2,     2,     2,     2,     2,     2, 
    2,     2,     2,     2,     2,     2,     2,     2, 
    2,     2,     2,     2,     2,     2,     2,     2, 
    4,     2,     3,     2,     2,     3,     2,     4, 
    2,     2,     2,     2,     2,     2,     2,     2, 
    2,     2,     3,     2,     2,     3,     2,     2, 
    2,     2,     5,     5,     5,     5,     2,     2, 
    2,     2,     2,     2,     2,     2,     2,     2
},
// Table for piece = KING in stage 0
{
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
  -10,   -10,   -10,   -10,   -10,   -10,   -10,   -10, 
   -1,     0,   -10,    -9,    -9,   -10,     0,    -1, 
    3,     7,    -1,    -2,    -2,    -1,     7,     3
} },
//-------------- STAGE 1 Below ---------------------
{
// Table for piece =   in stage 1
{
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = PAWN in stage 1
{
  -11,   -11,   -11,   -11,   -11,   -11,   -11,   -11, 
  -10,   -10,    -8,    -6,    -6,    -8,   -10,   -10, 
   -9,    -7,    -6,     0,     0,    -6,    -7,    -9, 
   -9,    -5,     0,     8,     8,     0,    -5,    -9, 
   -9,    -5,     0,     8,     8,     0,    -5,    -9, 
   -9,    -7,    -5,     0,     0,    -5,    -7,    -9, 
   -9,    -9,    -7,    -5,    -5,    -7,    -9,    -9, 
   -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9
},
// Table for piece = KNIGHT in stage 1
{
  -15,   -11,    -8,    -8,    -8,    -8,   -11,   -15, 
  -11,     2,     2,     2,     2,     2,     2,   -11, 
   -8,     2,    11,    11,    11,    11,     2,    -8, 
   -8,     2,    11,    23,    23,    11,     2,    -8, 
   -8,     2,    11,    23,    23,    11,     2,    -8, 
   -8,     2,    11,    11,    11,    11,     2,    -8, 
  -11,     2,     2,     2,     2,     2,     2,   -11, 
  -15,   -11,    -8,    -8,    -8,    -8,   -11,   -15
},
// Table for piece = BISHOP in stage 1
{
   -3,    -2,     0,     0,     0,     0,    -2,    -3, 
   -2,     5,     5,     5,     5,     5,     5,    -2, 
    0,     5,     9,     9,     9,     9,     5,     0, 
    0,     5,     9,    15,    15,     9,     5,     0, 
    0,     5,     9,    15,    15,     9,     5,     0, 
    0,     5,     9,     9,     9,     9,     5,     0, 
   -2,     5,     5,     5,     5,     5,     5,    -2, 
   -3,    -2,     0,     0,     0,     0,    -2,    -3
},
// Table for piece = ROOK in stage 1
{
    4,     7,     4,     4,     4,     4,     7,     4, 
   21,    40,    33,    30,    30,    33,    40,    21, 
    7,     4,     4,     4,     4,     4,     4,     7, 
   14,    14,     7,     9,     9,     7,    14,    14, 
   11,     4,     7,     4,     4,     7,     4,    11, 
    9,    11,     4,     4,     4,     4,    11,     9, 
    4,    11,     4,     0,     0,     4,    11,     4, 
   -2,    16,     9,     7,     7,     9,    16,    -2
},
// Table for piece = QUEEN in stage 1
{
    1,     1,     1,     3,     3,     1,     1,     1, 
    1,     1,     3,     3,     3,     3,     1,     1, 
    1,    13,     3,     3,     3,     3,    13,     1, 
    5,     3,     3,     9,     9,     3,     3,     5, 
    5,     9,    13,    13,    13,    13,     9,     5, 
    1,     1,     1,     9,     9,     1,     1,     1, 
    1,     1,    17,     9,     9,    17,     1,     1, 
    1,     1,     0,    -2,    -2,     0,     1,     1
},
// Table for piece = KING in stage 1
{
  -22,   -22,   -22,   -21,   -21,   -22,   -22,   -22, 
  -22,   -22,   -22,   -22,   -22,   -22,   -22,   -22, 
  -22,   -22,   -22,   -21,   -21,   -22,   -22,   -22, 
  -21,   -22,   -22,   -21,   -21,   -22,   -22,   -21, 
  -22,   -22,   -21,   -21,   -21,   -21,   -22,   -22, 
  -22,   -21,   -21,   -22,   -22,   -21,   -21,   -22, 
    0,     0,   -19,   -24,   -24,   -19,     0,     0, 
    0,    23,    -4,    -6,    -6,    -4,    23,     0
} },
//-------------- STAGE 2 Below ---------------------
{
// Table for piece =   in stage 2
{
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = PAWN in stage 2
{
   84,    84,    84,    84,    84,    84,    84,    84, 
   38,    38,    39,    39,    39,    39,    38,    38, 
   16,    16,    16,    18,    18,    16,    16,    16, 
    4,     5,     6,     8,     8,     6,     5,     4, 
    0,     0,     1,     3,     3,     1,     0,     0, 
   -3,    -3,    -2,    -1,    -1,    -2,    -3,    -3, 
   -5,    -5,    -4,    -4,    -4,    -4,    -5,    -5, 
   -6,    -6,    -6,    -6,    -6,    -6,    -6,    -6
},
// Table for piece = KNIGHT in stage 2
{
  -24,   -19,   -14,   -14,   -14,   -14,   -19,   -24, 
  -19,     0,     0,     0,     0,     0,     0,   -19, 
  -14,     0,    13,    13,    13,    13,     0,   -14, 
  -14,     0,    13,    31,    31,    13,     0,   -14, 
  -14,     0,    13,    31,    31,    13,     0,   -14, 
  -14,     0,    13,    13,    13,    13,     0,   -14, 
  -19,     0,     0,     0,     0,     0,     0,   -19, 
  -24,   -19,   -14,   -14,   -14,   -14,   -19,   -24
},
// Table for piece = BISHOP in stage 2
{
   -8,    -5,    -1,    -1,    -1,    -1,    -5,    -8, 
   -5,     9,     9,     9,     9,     9,     9,    -5, 
   -1,     9,    18,    18,    18,    18,     9,    -1, 
   -1,     9,    18,    30,    30,    18,     9,    -1, 
   -1,     9,    18,    30,    30,    18,     9,    -1, 
   -1,     9,    18,    18,    18,    18,     9,    -1, 
   -5,     9,     9,     9,     9,     9,     9,    -5, 
   -8,    -5,    -1,    -1,    -1,    -1,    -5,    -8
},
// Table for piece = ROOK in stage 2
{
   12,     8,     8,     8,     8,     8,     8,    12, 
   62,    58,    54,    65,    65,    54,    58,    62, 
   16,     8,    12,    12,    12,    12,     8,    16, 
    8,     8,     8,    16,    16,     8,     8,     8, 
    8,     8,     4,     8,     8,     4,     8,     8, 
    0,     8,     4,     0,     0,     4,     8,     0, 
    0,     4,     0,     4,     4,     0,     4,     0, 
  -10,     8,     8,     8,     8,     8,     8,   -10
},
// Table for piece = QUEEN in stage 2
{
    0,     0,     0,     3,     3,     0,     0,     0, 
   25,    35,    31,    28,    28,    31,    35,    25, 
    0,    19,    25,    22,    22,    25,    19,     0, 
    3,    16,    28,    38,    38,    28,    16,     3, 
    0,    16,    31,    31,    31,    31,    16,     0, 
    0,    10,    22,    16,    16,    22,    10,     0, 
   -2,     0,     3,     3,     3,     3,     0,    -2, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = KING in stage 2
{
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     1,     1,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     1,     0,     0,     1,     0,     0, 
    0,     0,     9,     0,     0,     9,     0,     0, 
    0,     0,    -2,     0,     0,    -2,     0,     0
} },
//-------------- STAGE 3 Below ---------------------
{
// Table for piece =   in stage 3
{
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = PAWN in stage 3
{
  127,   127,   127,   127,   127,   127,   127,   127, 
   87,    87,    86,    85,    85,    86,    87,    87, 
   41,    41,    40,    37,    37,    40,    41,    41, 
   19,    17,    14,     9,     9,    14,    17,    19, 
    7,     5,     2,    -2,    -2,     2,     5,     7, 
    1,     0,     0,    -2,    -2,     0,     0,     1, 
   -1,    -1,    -1,    -2,    -2,    -1,    -1,    -1, 
   -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3
},
// Table for piece = KNIGHT in stage 3
{
  -34,   -27,   -20,   -20,   -20,   -20,   -27,   -34, 
  -27,    -1,    -1,    -1,    -1,    -1,    -1,   -27, 
  -20,    -1,    15,    15,    15,    15,    -1,   -20, 
  -20,    -1,    15,    38,    38,    15,    -1,   -20, 
  -20,    -1,    15,    38,    38,    15,    -1,   -20, 
  -20,    -1,    15,    15,    15,    15,    -1,   -20, 
  -27,    -1,    -1,    -1,    -1,    -1,    -1,   -27, 
  -34,   -27,   -20,   -20,   -20,   -20,   -27,   -34
},
// Table for piece = BISHOP in stage 3
{
  -13,    -8,    -3,    -3,    -3,    -3,    -8,   -13, 
   -8,    13,    13,    13,    13,    13,    13,    -8, 
   -3,    13,    26,    26,    26,    26,    13,    -3, 
   -3,    13,    26,    45,    45,    26,    13,    -3, 
   -3,    13,    26,    45,    45,    26,    13,    -3, 
   -3,    13,    26,    26,    26,    26,    13,    -3, 
   -8,    13,    13,    13,    13,    13,    13,    -8, 
  -13,    -8,    -3,    -3,    -3,    -3,    -8,   -13
},
// Table for piece = ROOK in stage 3
{
   22,    12,    12,    12,    12,    12,    12,    22, 
   54,    65,    49,    65,    65,    49,    65,    54, 
   12,    12,    12,    27,    27,    12,    12,    12, 
   12,    17,    12,    12,    12,    12,    17,    12, 
   12,    12,    12,    12,    12,    12,    12,    12, 
   12,    12,     6,    12,    12,     6,    12,    12, 
   12,    12,    12,    12,    12,    12,    12,    12, 
    6,    12,    17,     6,     6,    17,    12,     6
},
// Table for piece = QUEEN in stage 3
{
    8,     4,     0,     8,     8,     0,     4,     8, 
    0,    21,    21,    21,    21,    21,    21,     0, 
    0,    16,    33,    29,    29,    33,    16,     0, 
    8,    25,    33,    58,    58,    33,    25,     8, 
    0,    25,    25,    33,    33,    25,    25,     0, 
    0,     8,    12,    12,    12,    12,     8,     0, 
    0,     0,     8,     4,     4,     8,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0
},
// Table for piece = KING in stage 3
{
  -46,   -28,   -19,    -1,    -1,   -19,   -28,   -46, 
  -26,     2,     6,     4,     4,     6,     2,   -26, 
  -19,     9,    15,    17,    17,    15,     9,   -19, 
   -1,    17,    27,    26,    26,    27,    17,    -1, 
    0,    11,    18,    17,    17,    18,    11,     0, 
  -20,     4,     9,    29,    29,     9,     4,   -20, 
  -24,    -1,     2,    -1,    -1,     2,    -1,   -24, 
  -47,   -28,   -28,    -8,    -8,   -28,   -28,   -47
} },
};


// white reference array to access piece-sq tables
// black can access the arrays directly
int whitef[64] = {
       56, 57, 58, 59, 60, 61, 62, 63,
       48, 49, 50, 51, 52, 53, 54, 55,
       40, 41, 42, 43, 44, 45, 46, 47,
       32, 33, 34, 35, 36, 37, 38, 39,
       24, 25, 26, 27, 28, 29, 30, 31,
       16, 17, 18, 19, 20, 21, 22, 23,
        8,  9, 10, 11, 12, 13, 14, 15,
        0,  1,  2,  3,  4,  5,  6,  7
};

/* -- not currently used below

// reference arrays for pawns when king
// in on the queen side
int qs_whitef[64] = {
       63, 62, 61, 60, 59, 58, 57, 56,
       55, 54, 53, 52, 51, 50, 49, 48,
       47, 46, 45, 44, 43, 42, 41, 40,
       39, 38, 37, 36, 35, 34, 33, 32,
       31, 30, 29, 28, 27, 26, 25, 24,
       23, 22, 21, 20, 19, 18, 17, 16,
       15, 14, 13, 12, 11, 10,  9,  8,
        7,  6,  5,  4,  3,  2,  1,  0
};

int qs_blackf[64] = {
        7,  6,  5,  4,  3,  2,  1,  0,
       15, 14, 13, 12, 11, 10,  9,  8,
       23, 22, 21, 20, 19, 18, 17, 16,
       31, 30, 29, 28, 27, 26, 25, 24,
       39, 38, 37, 36, 35, 34, 33, 32,
       47, 46, 45, 44, 43, 42, 41, 40,
       55, 54, 53, 52, 51, 50, 49, 48,
       63, 62, 61, 60, 59, 58, 57, 56
};

*/

#endif /* SCORE_H */
