/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.readers.AsciiLineReader;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.AbstractColorScale;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.MonocolorScale;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class AttributeManager {
    public static final String GROUP_AUTOSCALE = "AUTOSCALE GROUP";
    public static List<String> defaultTrackAttributes = Arrays.asList("NAME", "DATA FILE", "DATA TYPE");
    private static Logger log = Logger.getLogger(AttributeManager.class);
    private static AttributeManager singleton;
    public static final String ATTRIBUTES_LOADED_PROPERTY = "ATTRIBUTES_LOADED_PROPERTY";
    public static final String ATTRIBUTES_NARROWED_PROPERTY = "ATTRIBUTES_NARROWED_PROPERTY";
    private PropertyChangeSupport propertyChangeSupport;
    Set<ResourceLocator> loadedResources = Collections.synchronizedSet(new HashSet());
    Map<String, Map<String, String>> attributeMap = Collections.synchronizedMap(new LinkedHashMap());
    Map<String, String> trackSampleMappings = Collections.synchronizedMap(new HashMap());
    Map<String, String> attributeNames = Collections.synchronizedMap(new LinkedHashMap());
    Map<String, ColumnMetaData> columnMetaData = Collections.synchronizedMap(new HashMap());
    Map<String, Set<String>> uniqueAttributeValues = Collections.synchronizedMap(new HashMap());
    Map<String, Color> colorMap = Collections.synchronizedMap(new HashMap());
    Map<String, AbstractColorScale> colorScales = new HashMap<String, AbstractColorScale>();
    Map<String, ColorTable> colorTables = new HashMap<String, ColorTable>();
    Map<String, Integer> colorCounter = new HashMap<String, Integer>();
    static Set<String> nonGroupable;

    private AttributeManager() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static synchronized AttributeManager getInstance() {
        if (singleton == null) {
            singleton = new AttributeManager();
        }
        return singleton;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getAttribute(String trackName, String attributeName) {
        String sample;
        String value;
        Map<String, String> attributes = this.attributeMap.get(trackName);
        String key = attributeName.toUpperCase();
        String string = value = attributes == null ? null : attributes.get(key);
        if (value == null && this.trackSampleMappings.containsKey(trackName) && (attributes = this.attributeMap.get(sample = this.trackSampleMappings.get(trackName))) != null) {
            value = attributes.get(key);
        }
        return value;
    }

    public List<String> getAttributeNames() {
        ArrayList<String> attNames = new ArrayList<String>(this.attributeNames.values());
        return attNames;
    }

    public boolean isNumeric(String attributeName) {
        String key = attributeName.toUpperCase();
        ColumnMetaData metaData = this.columnMetaData.get(key);
        return metaData != null && metaData.isNumeric();
    }

    public List<String> getVisibleAttributes() {
        Set<String> hiddenAttributes;
        List<String> visibleAttributes = this.getAttributeNames();
        if (visibleAttributes == null) {
            Collections.emptyList();
        }
        if ((hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes()) != null) {
            visibleAttributes.removeAll(hiddenAttributes);
        }
        return visibleAttributes;
    }

    public void clearAllAttributes() {
        this.attributeMap.clear();
        this.attributeNames.clear();
        this.uniqueAttributeValues.clear();
        this.loadedResources = new HashSet<ResourceLocator>();
    }

    public void addAttribute(String rowId, String attributeName, String attributeValue) {
        if (attributeValue == null || attributeValue.equals("")) {
            return;
        }
        if (this.attributeNames.isEmpty()) {
            this.addAttributeName("NAME");
            this.addAttributeName("DATA TYPE");
            this.addAttributeName("DATA FILE");
        }
        this.addAttributeName(attributeName);
        String key = attributeName.toUpperCase();
        Set<String> uniqueSet = this.uniqueAttributeValues.get(key);
        if (uniqueSet == null) {
            uniqueSet = new HashSet<String>();
            this.uniqueAttributeValues.put(key, uniqueSet);
        }
        uniqueSet.add(attributeValue);
        Map<String, String> attributes = this.attributeMap.get(rowId);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, String>();
            this.attributeMap.put(rowId, attributes);
        }
        attributes.put(key, attributeValue);
        this.updateMetaData(key, attributeValue);
    }

    public void removeAttribute(String rowId, String attributeName) {
        Map<String, String> attributes = this.attributeMap.get(rowId);
        if (attributes != null) {
            attributes.remove(attributeName.toUpperCase());
        }
    }

    private void addAttributeName(String name) {
        String key = name.toUpperCase();
        if (!this.attributeNames.containsKey(key) && !name.startsWith("#")) {
            this.attributeNames.put(key, name);
        }
    }

    private void updateMetaData(String attributeName, String attributeValue) {
        String key = attributeName.toUpperCase();
        ColumnMetaData metaData = this.columnMetaData.get(key);
        if (metaData == null) {
            metaData = new ColumnMetaData(key);
            this.columnMetaData.put(key, metaData);
        }
        metaData.updateMetrics(attributeValue);
    }

    public static boolean isSampleInfoFile(ResourceLocator locator) throws IOException {
        if (!FileUtils.isTabDelimited(locator, 2)) {
            return false;
        }
        int oneMB = 1000000;
        long fileLength = ParsingUtils.getContentLength(locator.getPath());
        if (fileLength > 1000000L) {
            return MessageUtils.confirm("<html>Cannot determine file type of: " + locator.getPath() + "<br>Is this a sample information file?");
        }
        return true;
    }

    public void loadSampleInfo(ResourceLocator locator) {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            this.loadSampleTable(reader, locator.getPath());
            this.loadedResources.add(locator);
            if (!Globals.isHeadless()) {
                IGV.getInstance().resetOverlayTracks();
                IGV.getInstance().repaint();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error loading attribute file", (Throwable)ex);
            throw new DataLoadException("Error reading attribute file", locator.getPath());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            this.firePropertyChange(this, ATTRIBUTES_LOADED_PROPERTY, null, null);
        }
    }

    public List<String> getGroupableAttributes() {
        ArrayList<String> seriesNames = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.uniqueAttributeValues.entrySet()) {
            int cnt = entry.getValue().size();
            String att = entry.getKey();
            if (cnt <= 1 || cnt >= 10 || nonGroupable.contains(att)) continue;
            seriesNames.add(att);
        }
        return seriesNames;
    }

    private void loadSampleTable(AsciiLineReader reader, String path) throws IOException {
        String nextLine;
        String[] colHeadings = null;
        List<String> sections = Arrays.asList("#sampletable", "#samplemapping", "#colors");
        boolean foundAttributes = false;
        int nLines = 0;
        int lineLimit = 100000;
        String section = "#sampletable";
        while ((nextLine = reader.readLine()) != null && nLines++ <= lineLimit) {
            if (nextLine.toLowerCase().startsWith("#")) {
                String tmp = nextLine.toLowerCase().trim();
                if (!sections.contains(tmp)) continue;
                section = tmp;
                continue;
            }
            String[] tokens = nextLine.split("\t");
            if (section.equals("#sampletable")) {
                if (tokens.length < 2) continue;
                if (colHeadings == null) {
                    colHeadings = tokens;
                    continue;
                }
                String sampleName = tokens[0].trim();
                for (int i = 0; i < colHeadings.length; ++i) {
                    String attributeName = colHeadings[i].trim();
                    String attributeValue = i < tokens.length ? tokens[i].trim() : "";
                    this.addAttribute(sampleName, attributeName, attributeValue);
                    foundAttributes = true;
                }
                continue;
            }
            if (section.equals("#samplemapping")) {
                foundAttributes = true;
                if (tokens.length < 2) continue;
                String track = tokens[0];
                String sample = tokens[1];
                this.trackSampleMappings.put(track, sample);
                continue;
            }
            if (!section.equals("#colors")) continue;
            foundAttributes = true;
            this.parseColors(tokens);
        }
        if (!foundAttributes) {
            throw new DataLoadException("Could not determine file type.  Does file have proper extension? ", path);
        }
    }

    private void parseColors(String[] tokens) throws IOException {
        if (tokens.length >= 3) {
            String attKey = tokens[0].toUpperCase();
            if (this.isNumeric(attKey)) {
                String[] tmp;
                ColumnMetaData metaData = this.columnMetaData.get(attKey);
                String rangeString = tokens[1].trim();
                float min = (float)metaData.min;
                float max = (float)metaData.max;
                if (!rangeString.equals("*") && rangeString.length() > 0 && (tmp = rangeString.split(":")).length > 1) {
                    try {
                        min = Float.parseFloat(tmp[0]);
                        max = Float.parseFloat(tmp[1]);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Error parsing range string: " + rangeString), (Throwable)e);
                    }
                }
                AbstractColorScale scale = null;
                if (tokens.length == 3) {
                    Color baseColor = ColorUtilities.stringToColor(tokens[2]);
                    scale = new MonocolorScale(min, max, baseColor);
                    this.colorScales.put(attKey, scale);
                } else {
                    Color color1 = ColorUtilities.stringToColor(tokens[2]);
                    Color color2 = ColorUtilities.stringToColor(tokens[3]);
                    scale = min < 0.0f ? new ContinuousColorScale(min, 0.0, max, color1, Color.white, color2) : new ContinuousColorScale(min, max, color1, color2);
                }
                this.colorScales.put(attKey, scale);
            } else {
                String attValue = tokens[1];
                Color color = ColorUtilities.stringToColor(tokens[2]);
                String key = (attKey + "_" + attValue).toUpperCase();
                this.colorMap.put(key, color);
            }
        }
    }

    public void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    public Comparator getAttributeComparator() {
        return Utilities.getNumericStringComparator();
    }

    public Set<ResourceLocator> getLoadedResources() {
        return this.loadedResources;
    }

    public String getSampleFor(String track) {
        if (this.trackSampleMappings.containsKey(track)) {
            return this.trackSampleMappings.get(track);
        }
        if (AttributeManager.isTCGAName(track)) {
            String sample = track.substring(0, 12);
            this.addAttribute(track, "Sample", sample);
            this.trackSampleMappings.put(track, sample);
            return sample;
        }
        String key = PreferencesManager.getPreferences().get("OVERLAY_ATTRIBUTE_KEY");
        return key == null ? null : this.getAttribute(track, key);
    }

    public static boolean isTCGAName(String name) {
        return name.length() >= 12 && name.toUpperCase().startsWith("TCGA-") && name.charAt(7) == '-';
    }

    public Color getColor(String attKey, String attValue) {
        if (attValue == null || attValue.length() == 0) {
            return Color.gray;
        }
        ColumnMetaData metaData = this.columnMetaData.get(attKey.toUpperCase());
        if (metaData == null) {
            return Color.gray;
        }
        if (metaData.isNumeric()) {
            AbstractColorScale cs = this.colorScales.get(attKey);
            if (cs == null) {
                Color minColor;
                if (metaData.isDiverging()) {
                    minColor = new Color(198, 219, 239);
                    Color midColor = Color.white;
                    Color maxColor = new Color(33, 102, 172);
                    cs = new ContinuousColorScale(metaData.getMin(), 0.0, metaData.getMax(), minColor, midColor, maxColor);
                    this.colorScales.put(attKey, cs);
                } else {
                    minColor = new Color(198, 219, 239);
                    Color maxColor = new Color(8, 69, 148);
                    cs = new ContinuousColorScale(metaData.getMin(), metaData.getMax(), minColor, maxColor);
                    this.colorScales.put(attKey, cs);
                }
            }
            try {
                float x = Float.parseFloat(attValue);
                return cs.getColor(x);
            }
            catch (NumberFormatException e) {
                return Color.lightGray;
            }
        }
        String key = (attKey + "_" + attValue).toUpperCase();
        Color c = this.colorMap.get(key);
        if (c == null && (c = this.colorMap.get(key = ("*_" + attValue).toUpperCase())) == null) {
            key = (attValue + "_*").toUpperCase();
            c = this.colorMap.get(key);
        }
        if (c == null) {
            boolean useColor = true;
            if (useColor) {
                ColorTable ct = this.colorTables.get(attKey);
                if (ct == null) {
                    ColorPalette palette = ColorUtilities.getNextPalette();
                    ct = new PaletteColorTable(palette);
                    this.colorTables.put(attKey, ct);
                }
                c = ct.get(attValue);
            } else {
                c = ColorUtilities.randomDesaturatedColor(0.5f);
                this.colorMap.put(key, c);
            }
        }
        return c;
    }

    public ColumnMetaData getColumnMetaData(String key) {
        return this.columnMetaData.get(key.toUpperCase());
    }

    static {
        nonGroupable = new HashSet<String>(Arrays.asList("DATA FILE", "DATA TYPE", "VITALSTATUS", "VITAL STATUS", "KARNSCORE", "CENSURED"));
    }

    public static class ColumnMetaData {
        String name;
        private double min = Double.MAX_VALUE;
        private double max = -this.min;
        int totalCount = 0;
        public HashSet<String> uniqueAlphaValues = new HashSet();
        public HashSet<String> uniqueNumericValues = new HashSet();

        ColumnMetaData(String name) {
            this.name = name;
        }

        public void updateMetrics(String attributeValue) {
            ++this.totalCount;
            if (attributeValue != null && attributeValue.length() > 0) {
                try {
                    double value = Double.parseDouble(attributeValue);
                    this.uniqueNumericValues.add(attributeValue);
                    this.min = Math.min(this.min, value);
                    this.max = Math.max(this.max, value);
                }
                catch (NumberFormatException e) {
                    this.uniqueAlphaValues.add(attributeValue);
                }
            }
        }

        public boolean isNumeric() {
            return this.uniqueNumericValues.size() > 1 && this.uniqueAlphaValues.size() < 2;
        }

        public boolean isDiverging() {
            return this.min < 0.0;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getUniqueRatio() {
            double totalUnique = this.uniqueAlphaValues.size() + this.uniqueNumericValues.size();
            return totalUnique / (double)this.totalCount;
        }

        public int getUniqueCount() {
            return this.uniqueAlphaValues.size() + this.uniqueNumericValues.size();
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }
}

