/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zzk;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziu;
import java.util.List;

public final class zziv
implements zzk,
AppIndexApi {
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final UsageInfo ... usageInfoArray) {
        final String string2 = googleApiClient.getContext().getPackageName();
        return googleApiClient.zza(new zzc<Status>(googleApiClient){

            @Override
            protected void zza(zziq zziq2) throws RemoteException {
                zziq2.zza((zzir)new zzd(this), string2, usageInfoArray);
            }
        });
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Intent viewIntent, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string2 = apiClient.getContext().getPackageName();
        zziv.zzi(outLinks);
        return this.zza(apiClient, new UsageInfo(string2, viewIntent, title, webUrl, null, outLinks, 1));
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Intent viewIntent) {
        String string2 = apiClient.getContext().getPackageName();
        UsageInfo usageInfo = new UsageInfo.zza().zza(UsageInfo.zza(string2, viewIntent)).zzw(System.currentTimeMillis()).zzal(0).zzam(2).zzkN();
        return this.zza(apiClient, usageInfo);
    }

    public static Intent zza(String string2, Uri uri) {
        zziv.zzb(string2, uri);
        List list = uri.getPathSegments();
        String string3 = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string3);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return new Intent("android.intent.action.VIEW", builder.build());
    }

    private static void zzb(String string2, Uri uri) {
        String string3 = uri.getScheme();
        if (!"android-app".equals(string3)) {
            throw new IllegalArgumentException("AppIndex: The URI scheme must be 'android-app' and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        String string4 = uri.getHost();
        if (string2 != null && !string2.equals(string4)) {
            throw new IllegalArgumentException("AppIndex: The URI host must match the package name and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        List list = uri.getPathSegments();
        if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
            throw new IllegalArgumentException("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
    }

    public static void zzi(List<AppIndexApi.AppIndexingLink> list) {
        if (list == null) {
            return;
        }
        for (AppIndexApi.AppIndexingLink appIndexingLink : list) {
            zziv.zzb(null, appIndexingLink.appIndexingUrl);
        }
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Uri appIndexingUrl, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string2 = apiClient.getContext().getPackageName();
        zziv.zzb(string2, appIndexingUrl);
        Intent intent = zziv.zza(string2, appIndexingUrl);
        return this.view(apiClient, activity, intent, title, webUrl, outLinks);
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Uri appUri) {
        String string2 = apiClient.getContext().getPackageName();
        Intent intent = zziv.zza(string2, appUri);
        return this.viewEnd(apiClient, activity, intent);
    }

    @Override
    public AppIndexApi.ActionResult action(GoogleApiClient apiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(apiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public PendingResult<Status> start(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 1);
    }

    @Override
    public PendingResult<Status> end(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 2);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string2 = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        UsageInfo usageInfo = zziu.zza(action, l, string2, n);
        return this.zza(googleApiClient, usageInfo);
    }

    @Deprecated
    private static final class zza
    implements AppIndexApi.ActionResult {
        private zziv zzNS;
        private PendingResult<Status> zzNT;
        private Action zzNU;

        zza(zziv zziv2, PendingResult<Status> pendingResult, Action action) {
            this.zzNS = zziv2;
            this.zzNT = pendingResult;
            this.zzNU = action;
        }

        @Override
        public PendingResult<Status> end(GoogleApiClient apiClient) {
            String string2 = apiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            UsageInfo usageInfo = zziu.zza(this.zzNU, l, string2, 2);
            return this.zzNS.zza(apiClient, usageInfo);
        }

        @Override
        public PendingResult<Status> getPendingResult() {
            return this.zzNT;
        }
    }

    private static final class zzd
    extends zzis<Status> {
        public zzd(zza.zzb<Status> zzb2) {
            super(zzb2);
        }

        @Override
        public void zza(Status status) {
            this.zzNO.zzm(status);
        }
    }

    private static abstract class zzc<T extends Result>
    extends zzb<Status> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        @Override
        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb<T extends Result>
    extends zza.zza<T, zzit> {
        public zzb(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.appdatasearch.zza.zzMO, googleApiClient);
        }

        @Override
        protected final void zza(zzit zzit2) throws RemoteException {
            this.zza(zzit2.zzkO());
        }

        @Override
        protected abstract void zza(zziq var1) throws RemoteException;
    }
}

