/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.dynamic.zzg;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View zzVZ;
    private View.OnClickListener zzWa = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        zzu.zza(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        zzu.zza(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.zzaf(this.getContext());
    }

    private void zzaf(Context context) {
        if (this.zzVZ != null) {
            this.removeView(this.zzVZ);
        }
        try {
            this.zzVZ = zzx.zzb(context, this.mSize, this.mColor);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzVZ = SignInButton.zza(context, this.mSize, this.mColor);
        }
        this.addView(this.zzVZ);
        this.zzVZ.setEnabled(this.isEnabled());
        this.zzVZ.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2) {
        zzy zzy2 = new zzy(context);
        zzy2.zza(context.getResources(), n, n2);
        return zzy2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.zzWa = listener;
        if (this.zzVZ != null) {
            this.zzVZ.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.zzVZ.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.zzWa != null && view == this.zzVZ) {
            this.zzWa.onClick((View)this);
        }
    }
}

