REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:18
REM  FILENAME: F_CSC_X_N.BAS
REM    SYNTAX: N  = CSC( X )
REM  UNIQUEID: F_CSC_X_N
REM  FUNCTION: CSC
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = CSC( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  1 ,  0 ,  0 
DATA  2 ,  0 ,  1.1884 ,  1 
DATA  3 ,  0 , -1.1884 , -1 
DATA  4 ,  0 ,  2.56793 ,  .4 
DATA  5 ,  0 , -2.56793 , -.4 
DATA  6 ,  0 ,  1.77103 ,  .6 
DATA  7 ,  0 , -1.77103 , -.6 
DATA  8 ,  0 ,  2.21239 ,  254 
DATA  9 ,  0 , -1.97476 ,  255 
DATA  10 ,  0 , -1.00079 ,  256 
DATA  11 ,  0 , -3.84977 ,  32000 
DATA  12 ,  0 , -4.43895 , -.227229 
DATA  13 ,  0 , -4.22148 , -.239157 
DATA  14 ,  0 , -4.71774 , -.213586 
DATA  15 ,  0 ,  3.68685 ,  .274675 
DATA  16 ,  0 ,  5.91885 ,  .169766 
DATA  17 ,  0 ,  3.19086 ,  .318766 
DATA  18 ,  0 ,  48.3926 ,  2.06658E-2 
DATA  19 ,  0 ,  5.34339 ,  .188257 
DATA  20 ,  0 , -3.6498 , -.277537 
DATA  21 ,  0 , -2.16013 , -.481303 
DATA  22 ,  0 ,  2.37013 ,  .43556 
DATA  23 ,  0 , -4.77533 , -.210971 
DATA  24 ,  0 , -2.2745 , -.455216 
DATA  25 ,  0 ,  1.22828 , -110.907 
DATA  26 ,  0 , -1.08059 ,  105.632 
DATA  27 ,  0 , -1.056 , -114.341 
DATA  28 ,  0 ,  4.04605 ,  109.706 
DATA  29 ,  0 ,  1.455 ,  109.198 
DATA  30 ,  0 , -1.15001 ,  85.8773 
DATA  31 ,  0 , -1.02835 , -58.3548 
DATA  32 ,  0 , -1.02148 ,  29.6397 
DATA  33 ,  0 , -1.00031 , -108.36 
DATA  34 ,  0 , -1.76078 , -46.5199 
DATA  35 ,  0 , -1.83501 ,  112.521 
DATA  36 ,  0 ,  1.0096 ,  45.4151 
DATA  37 ,  0 ,  1.77614 ,  101.129 
DATA  38 ,  0 ,  1.25108 ,  65.0473 
DATA  39 ,  0 , -1.04467 ,  48.4012 
DATA  40 ,  0 ,  4.42203 ,  122.294 
DATA  41 ,  0 ,  2.35141 , -56.1094 
DATA  42 ,  0 , -1.00928 , -121.087 
DATA  43 ,  0 ,  1.19233 , -123.517 
DATA  44 ,  0 ,  4.19446 , -97.6301 
DATA  45 ,  0 , -1.08688 , -64.0001 
DATA  46 ,  0 , -1.8945 , -25.6888 
DATA  47 ,  0 ,  1.26922 ,  14.8006 
DATA  48 ,  0 ,  1.01522 , -61.0877 
DATA  49 ,  0 ,  1.62131 , -66.6381 
DATA  50 ,  0 ,  1.54494 , -5476.5 
DATA  51 ,  0 ,  1.0134 , -21210.3 
DATA  52 ,  0 ,  1.23907 , -28757.2 
DATA  53 ,  0 ,  1.38541 , -28732.2 
DATA  54 ,  0 ,  1.8631 ,  12730.3 
DATA  55 ,  0 , -1.32122 , -1830.69 
DATA  56 ,  0 ,  1.08643 ,  5486.39 
DATA  57 ,  0 ,  16.3515 ,  22405.9 
DATA  58 ,  0 , -5.01257 ,  30809.8 
DATA  59 ,  0 , -3.11562 , -28930.6 
DATA  60 ,  0 , -1.00121 , -6014.53 
DATA  61 ,  0 , -1.46404 ,  17414.6 
DATA  62 ,  0 , -1.01507 , -10538.3 
DATA  63 ,  0 ,  14.2583 , -17536.3 
DATA  64 ,  0 ,  2.20672 , -8856.62 
DATA  65 ,  0 , -2.18904 , -5140.12 
DATA  66 ,  0 ,  11.4431 , -8595.31 
DATA  67 ,  0 , -1.70844 , -3382.87 
DATA  68 ,  0 , -1.64269 , -5002.07 
DATA  69 ,  0 , -1.02725 , -5800.72 
DATA  70 ,  0 , -1.00319 ,  29686.4 
DATA  71 ,  0 ,  1.08279 ,  2571. 
DATA  72 ,  0 ,  1.02664 ,  31091. 
DATA  73 ,  0 , -9.32433 ,  14819. 
DATA  74 ,  0 ,  1.18662 ,  3790.9 
DATA  75 ,  0 ,  1.75127 , -4.2981E+9 
DATA  76 ,  0 , -2.38025 , -7.05453E+8 
DATA  77 ,  0 ,  2.44743 , -3.10179E+9 
DATA  78 ,  0 ,  1.02633 , -4.86159E+9 
DATA  79 ,  0 ,  1.34405 , -8.62908E+8 
DATA  80 ,  0 , -2.61997 , -3.4101E+9 
DATA  81 ,  0 , -1.27102 ,  3.3889E+9 
DATA  82 ,  0 ,  1.38197 ,  2.49826E+9 
DATA  83 ,  0 , -1.09619 ,  2.3491E+9 
DATA  84 ,  0 ,  1.59852 ,  1.94745E+8 
DATA  85 ,  0 ,  6.31355 ,  2.02475E+9 
DATA  86 ,  0 , -1.31165 , -2.26748E+9 
DATA  87 ,  0 , -17.8326 , -2.10587E+9 
DATA  88 ,  0 , -1.06092 ,  4.23585E+9 
DATA  89 ,  0 ,  6.0922 , -2.66524E+9 
DATA  90 ,  0 ,  1.36305 ,  4.01052E+9 
DATA  91 ,  0 ,  2.65459 , -4.87912E+9 
DATA  92 ,  0 , -1.00077 ,  1.77556E+9 
DATA  93 ,  0 , -1.7353 ,  2.87705E+8 
DATA  94 ,  0 ,  2.96831 ,  1.99977E+8 
DATA  95 ,  0 , -1.76251 , -3.39941E+9 
DATA  96 ,  0 ,  1.01053 , -3.49119E+9 
DATA  97 ,  0 , -1.00141 , -2.86324E+9 
DATA  98 ,  0 , -1.24706 ,  4.20418E+9 
DATA  99 ,  0 ,  1.31838 , -3.1518E+9 
DATA  100 ,  0 ,  1.43479 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
