// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/dataproc/v1/batches.proto

package dataprocpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The batch state.
type Batch_State int32

const (
	// The batch state is unknown.
	Batch_STATE_UNSPECIFIED Batch_State = 0
	// The batch is created before running.
	Batch_PENDING Batch_State = 1
	// The batch is running.
	Batch_RUNNING Batch_State = 2
	// The batch is cancelling.
	Batch_CANCELLING Batch_State = 3
	// The batch cancellation was successful.
	Batch_CANCELLED Batch_State = 4
	// The batch completed successfully.
	Batch_SUCCEEDED Batch_State = 5
	// The batch is no longer running due to an error.
	Batch_FAILED Batch_State = 6
)

// Enum value maps for Batch_State.
var (
	Batch_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "CANCELLING",
		4: "CANCELLED",
		5: "SUCCEEDED",
		6: "FAILED",
	}
	Batch_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"CANCELLING":        3,
		"CANCELLED":         4,
		"SUCCEEDED":         5,
		"FAILED":            6,
	}
)

func (x Batch_State) Enum() *Batch_State {
	p := new(Batch_State)
	*p = x
	return p
}

func (x Batch_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Batch_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_batches_proto_enumTypes[0].Descriptor()
}

func (Batch_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_batches_proto_enumTypes[0]
}

func (x Batch_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Batch_State.Descriptor instead.
func (Batch_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{5, 0}
}

// A request to create a batch workload.
type CreateBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this batch will be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The batch to create.
	Batch *Batch `protobuf:"bytes,2,opt,name=batch,proto3" json:"batch,omitempty"`
	// Optional. The ID to use for the batch, which will become the final component of
	// the batch's resource name.
	//
	// This value must be 4-63 characters. Valid characters are `/[a-z][0-9]-/`.
	BatchId string `protobuf:"bytes,3,opt,name=batch_id,json=batchId,proto3" json:"batch_id,omitempty"`
	// Optional. A unique ID used to identify the request. If the service
	// receives two
	// [CreateBatchRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateBatchRequest)s
	// with the same request_id, the second request is ignored and the
	// Operation that corresponds to the first Batch created and stored
	// in the backend is returned.
	//
	// Recommendation: Set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The value must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateBatchRequest) Reset() {
	*x = CreateBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBatchRequest) ProtoMessage() {}

func (x *CreateBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBatchRequest.ProtoReflect.Descriptor instead.
func (*CreateBatchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{0}
}

func (x *CreateBatchRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBatchRequest) GetBatch() *Batch {
	if x != nil {
		return x.Batch
	}
	return nil
}

func (x *CreateBatchRequest) GetBatchId() string {
	if x != nil {
		return x.BatchId
	}
	return ""
}

func (x *CreateBatchRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to get the resource representation for a batch workload.
type GetBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the batch to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBatchRequest) Reset() {
	*x = GetBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBatchRequest) ProtoMessage() {}

func (x *GetBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBatchRequest.ProtoReflect.Descriptor instead.
func (*GetBatchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{1}
}

func (x *GetBatchRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list batch workloads in a project.
type ListBatchesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of batches.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of batches to return in each response.
	// The service may return fewer than this value.
	// The default page size is 20; the maximum page size is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token received from a previous `ListBatches` call.
	// Provide this token to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBatchesRequest) Reset() {
	*x = ListBatchesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBatchesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBatchesRequest) ProtoMessage() {}

func (x *ListBatchesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBatchesRequest.ProtoReflect.Descriptor instead.
func (*ListBatchesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{2}
}

func (x *ListBatchesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBatchesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBatchesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A list of batch workloads.
type ListBatchesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The batches from the specified collection.
	Batches []*Batch `protobuf:"bytes,1,rep,name=batches,proto3" json:"batches,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBatchesResponse) Reset() {
	*x = ListBatchesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBatchesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBatchesResponse) ProtoMessage() {}

func (x *ListBatchesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBatchesResponse.ProtoReflect.Descriptor instead.
func (*ListBatchesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{3}
}

func (x *ListBatchesResponse) GetBatches() []*Batch {
	if x != nil {
		return x.Batches
	}
	return nil
}

func (x *ListBatchesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to delete a batch workload.
type DeleteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the batch resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBatchRequest) Reset() {
	*x = DeleteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBatchRequest) ProtoMessage() {}

func (x *DeleteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBatchRequest.ProtoReflect.Descriptor instead.
func (*DeleteBatchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteBatchRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A representation of a batch workload in the service.
type Batch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the batch.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A batch UUID (Unique Universal Identifier). The service
	// generates this value when it creates the batch.
	Uuid string `protobuf:"bytes,2,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// Output only. The time when the batch was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The application/framework-specific portion of the batch configuration.
	//
	// Types that are assignable to BatchConfig:
	//
	//	*Batch_PysparkBatch
	//	*Batch_SparkBatch
	//	*Batch_SparkRBatch
	//	*Batch_SparkSqlBatch
	BatchConfig isBatch_BatchConfig `protobuf_oneof:"batch_config"`
	// Output only. Runtime information about batch execution.
	RuntimeInfo *RuntimeInfo `protobuf:"bytes,8,opt,name=runtime_info,json=runtimeInfo,proto3" json:"runtime_info,omitempty"`
	// Output only. The state of the batch.
	State Batch_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.dataproc.v1.Batch_State" json:"state,omitempty"`
	// Output only. Batch state details, such as a failure
	// description if the state is `FAILED`.
	StateMessage string `protobuf:"bytes,10,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. The time when the batch entered a current state.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. The email address of the user who created the batch.
	Creator string `protobuf:"bytes,12,opt,name=creator,proto3" json:"creator,omitempty"`
	// Optional. The labels to associate with this batch.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a batch.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Runtime configuration for the batch execution.
	RuntimeConfig *RuntimeConfig `protobuf:"bytes,14,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	// Optional. Environment configuration for the batch execution.
	EnvironmentConfig *EnvironmentConfig `protobuf:"bytes,15,opt,name=environment_config,json=environmentConfig,proto3" json:"environment_config,omitempty"`
	// Output only. The resource name of the operation associated with this batch.
	Operation string `protobuf:"bytes,16,opt,name=operation,proto3" json:"operation,omitempty"`
	// Output only. Historical state information for the batch.
	StateHistory []*Batch_StateHistory `protobuf:"bytes,17,rep,name=state_history,json=stateHistory,proto3" json:"state_history,omitempty"`
}

func (x *Batch) Reset() {
	*x = Batch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Batch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Batch) ProtoMessage() {}

func (x *Batch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Batch.ProtoReflect.Descriptor instead.
func (*Batch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{5}
}

func (x *Batch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Batch) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *Batch) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (m *Batch) GetBatchConfig() isBatch_BatchConfig {
	if m != nil {
		return m.BatchConfig
	}
	return nil
}

func (x *Batch) GetPysparkBatch() *PySparkBatch {
	if x, ok := x.GetBatchConfig().(*Batch_PysparkBatch); ok {
		return x.PysparkBatch
	}
	return nil
}

func (x *Batch) GetSparkBatch() *SparkBatch {
	if x, ok := x.GetBatchConfig().(*Batch_SparkBatch); ok {
		return x.SparkBatch
	}
	return nil
}

func (x *Batch) GetSparkRBatch() *SparkRBatch {
	if x, ok := x.GetBatchConfig().(*Batch_SparkRBatch); ok {
		return x.SparkRBatch
	}
	return nil
}

func (x *Batch) GetSparkSqlBatch() *SparkSqlBatch {
	if x, ok := x.GetBatchConfig().(*Batch_SparkSqlBatch); ok {
		return x.SparkSqlBatch
	}
	return nil
}

func (x *Batch) GetRuntimeInfo() *RuntimeInfo {
	if x != nil {
		return x.RuntimeInfo
	}
	return nil
}

func (x *Batch) GetState() Batch_State {
	if x != nil {
		return x.State
	}
	return Batch_STATE_UNSPECIFIED
}

func (x *Batch) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *Batch) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *Batch) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *Batch) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Batch) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

func (x *Batch) GetEnvironmentConfig() *EnvironmentConfig {
	if x != nil {
		return x.EnvironmentConfig
	}
	return nil
}

func (x *Batch) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *Batch) GetStateHistory() []*Batch_StateHistory {
	if x != nil {
		return x.StateHistory
	}
	return nil
}

type isBatch_BatchConfig interface {
	isBatch_BatchConfig()
}

type Batch_PysparkBatch struct {
	// Optional. PySpark batch config.
	PysparkBatch *PySparkBatch `protobuf:"bytes,4,opt,name=pyspark_batch,json=pysparkBatch,proto3,oneof"`
}

type Batch_SparkBatch struct {
	// Optional. Spark batch config.
	SparkBatch *SparkBatch `protobuf:"bytes,5,opt,name=spark_batch,json=sparkBatch,proto3,oneof"`
}

type Batch_SparkRBatch struct {
	// Optional. SparkR batch config.
	SparkRBatch *SparkRBatch `protobuf:"bytes,6,opt,name=spark_r_batch,json=sparkRBatch,proto3,oneof"`
}

type Batch_SparkSqlBatch struct {
	// Optional. SparkSql batch config.
	SparkSqlBatch *SparkSqlBatch `protobuf:"bytes,7,opt,name=spark_sql_batch,json=sparkSqlBatch,proto3,oneof"`
}

func (*Batch_PysparkBatch) isBatch_BatchConfig() {}

func (*Batch_SparkBatch) isBatch_BatchConfig() {}

func (*Batch_SparkRBatch) isBatch_BatchConfig() {}

func (*Batch_SparkSqlBatch) isBatch_BatchConfig() {}

// A configuration for running an
// [Apache
// PySpark](https://spark.apache.org/docs/latest/api/python/getting_started/quickstart.html)
// batch workload.
type PySparkBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The HCFS URI of the main Python file to use as the Spark driver. Must
	// be a .py file.
	MainPythonFileUri string `protobuf:"bytes,1,opt,name=main_python_file_uri,json=mainPythonFileUri,proto3" json:"main_python_file_uri,omitempty"`
	// Optional. The arguments to pass to the driver. Do not include arguments
	// that can be set as batch properties, such as `--conf`, since a collision
	// can occur that causes an incorrect batch submission.
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS file URIs of Python files to pass to the PySpark
	// framework. Supported file types: `.py`, `.egg`, and `.zip`.
	PythonFileUris []string `protobuf:"bytes,3,rep,name=python_file_uris,json=pythonFileUris,proto3" json:"python_file_uris,omitempty"`
	// Optional. HCFS URIs of jar files to add to the classpath of the
	// Spark driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. HCFS URIs of files to be placed in the working directory of
	// each executor.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted into the working directory
	// of each executor. Supported file types:
	// `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
}

func (x *PySparkBatch) Reset() {
	*x = PySparkBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PySparkBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PySparkBatch) ProtoMessage() {}

func (x *PySparkBatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PySparkBatch.ProtoReflect.Descriptor instead.
func (*PySparkBatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{6}
}

func (x *PySparkBatch) GetMainPythonFileUri() string {
	if x != nil {
		return x.MainPythonFileUri
	}
	return ""
}

func (x *PySparkBatch) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *PySparkBatch) GetPythonFileUris() []string {
	if x != nil {
		return x.PythonFileUris
	}
	return nil
}

func (x *PySparkBatch) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *PySparkBatch) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *PySparkBatch) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

// A configuration for running an [Apache Spark](http://spark.apache.org/)
// batch workload.
type SparkBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specification of the main method to call to drive the Spark
	// workload. Specify either the jar file that contains the main class or the
	// main class name. To pass both a main jar and a main class in that jar, add
	// the jar to `jar_file_uris`, and then specify the main class
	// name in `main_class`.
	//
	// Types that are assignable to Driver:
	//
	//	*SparkBatch_MainJarFileUri
	//	*SparkBatch_MainClass
	Driver isSparkBatch_Driver `protobuf_oneof:"driver"`
	// Optional. The arguments to pass to the driver. Do not include arguments
	// that can be set as batch properties, such as `--conf`, since a collision
	// can occur that causes an incorrect batch submission.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS URIs of jar files to add to the classpath of the
	// Spark driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. HCFS URIs of files to be placed in the working directory of
	// each executor.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted into the working directory
	// of each executor. Supported file types:
	// `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
}

func (x *SparkBatch) Reset() {
	*x = SparkBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkBatch) ProtoMessage() {}

func (x *SparkBatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkBatch.ProtoReflect.Descriptor instead.
func (*SparkBatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{7}
}

func (m *SparkBatch) GetDriver() isSparkBatch_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (x *SparkBatch) GetMainJarFileUri() string {
	if x, ok := x.GetDriver().(*SparkBatch_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (x *SparkBatch) GetMainClass() string {
	if x, ok := x.GetDriver().(*SparkBatch_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (x *SparkBatch) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *SparkBatch) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *SparkBatch) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *SparkBatch) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

type isSparkBatch_Driver interface {
	isSparkBatch_Driver()
}

type SparkBatch_MainJarFileUri struct {
	// Optional. The HCFS URI of the jar file that contains the main class.
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type SparkBatch_MainClass struct {
	// Optional. The name of the driver main class. The jar file that contains the class
	// must be in the classpath or specified in `jar_file_uris`.
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,proto3,oneof"`
}

func (*SparkBatch_MainJarFileUri) isSparkBatch_Driver() {}

func (*SparkBatch_MainClass) isSparkBatch_Driver() {}

// A configuration for running an
// [Apache SparkR](https://spark.apache.org/docs/latest/sparkr.html)
// batch workload.
type SparkRBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The HCFS URI of the main R file to use as the driver.
	// Must be a `.R` or `.r` file.
	MainRFileUri string `protobuf:"bytes,1,opt,name=main_r_file_uri,json=mainRFileUri,proto3" json:"main_r_file_uri,omitempty"`
	// Optional. The arguments to pass to the Spark driver. Do not include arguments
	// that can be set as batch properties, such as `--conf`, since a collision
	// can occur that causes an incorrect batch submission.
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS URIs of files to be placed in the working directory of
	// each executor.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted into the working directory
	// of each executor. Supported file types:
	// `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
}

func (x *SparkRBatch) Reset() {
	*x = SparkRBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkRBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkRBatch) ProtoMessage() {}

func (x *SparkRBatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkRBatch.ProtoReflect.Descriptor instead.
func (*SparkRBatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{8}
}

func (x *SparkRBatch) GetMainRFileUri() string {
	if x != nil {
		return x.MainRFileUri
	}
	return ""
}

func (x *SparkRBatch) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *SparkRBatch) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *SparkRBatch) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

// A configuration for running
// [Apache Spark SQL](http://spark.apache.org/sql/) queries as a batch workload.
type SparkSqlBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The HCFS URI of the script that contains Spark SQL queries to execute.
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,proto3" json:"query_file_uri,omitempty"`
	// Optional. Mapping of query variable names to values (equivalent to the
	// Spark SQL command: `SET name="value";`).
	QueryVariables map[string]string `protobuf:"bytes,2,rep,name=query_variables,json=queryVariables,proto3" json:"query_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
	JarFileUris []string `protobuf:"bytes,3,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
}

func (x *SparkSqlBatch) Reset() {
	*x = SparkSqlBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkSqlBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkSqlBatch) ProtoMessage() {}

func (x *SparkSqlBatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkSqlBatch.ProtoReflect.Descriptor instead.
func (*SparkSqlBatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{9}
}

func (x *SparkSqlBatch) GetQueryFileUri() string {
	if x != nil {
		return x.QueryFileUri
	}
	return ""
}

func (x *SparkSqlBatch) GetQueryVariables() map[string]string {
	if x != nil {
		return x.QueryVariables
	}
	return nil
}

func (x *SparkSqlBatch) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

// Historical state information.
type Batch_StateHistory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The state of the batch at this point in history.
	State Batch_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataproc.v1.Batch_State" json:"state,omitempty"`
	// Output only. Details about the state at this point in history.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. The time when the batch entered the historical state.
	StateStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime,proto3" json:"state_start_time,omitempty"`
}

func (x *Batch_StateHistory) Reset() {
	*x = Batch_StateHistory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Batch_StateHistory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Batch_StateHistory) ProtoMessage() {}

func (x *Batch_StateHistory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_batches_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Batch_StateHistory.ProtoReflect.Descriptor instead.
func (*Batch_StateHistory) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Batch_StateHistory) GetState() Batch_State {
	if x != nil {
		return x.State
	}
	return Batch_STATE_UNSPECIFIED
}

func (x *Batch_StateHistory) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *Batch_StateHistory) GetStateStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateStartTime
	}
	return nil
}

var File_google_cloud_dataproc_v1_batches_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_v1_batches_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xd3, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x1e, 0x0a, 0x08, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1f, 0x12, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x78, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x0c, 0x0a, 0x05, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x70, 0x79, 0x73, 0x70,
	0x61, 0x72, 0x6b, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x79, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c,
	0x70, 0x79, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x4c, 0x0a, 0x0b,
	0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a,
	0x73, 0x70, 0x61, 0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x50, 0x0a, 0x0d, 0x73, 0x70,
	0x61, 0x72, 0x6b, 0x5f, 0x72, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x52, 0x42, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0b, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x52, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x56, 0x0a, 0x0f,
	0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x53, 0x71, 0x6c, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x48,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x53, 0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a,
	0x12, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21,
	0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x56, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0xc5, 0x01, 0x0a, 0x0c, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x72, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06,
	0x3a, 0x5b, 0xea, 0x41, 0x58, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x37, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x7d, 0x42, 0x0e, 0x0a,
	0x0c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xff, 0x01,
	0x0a, 0x0c, 0x50, 0x79, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x34,
	0x0a, 0x14, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x46, 0x69, 0x6c,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x2d, 0x0a,
	0x10, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x79,
	0x74, 0x68, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x27, 0x0a, 0x0d,
	0x6a, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6a, 0x61, 0x72, 0x46, 0x69, 0x6c,
	0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x73, 0x22,
	0xfa, 0x01, 0x0a, 0x0a, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x30,
	0x0a, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6a, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x0e, 0x6d, 0x61, 0x69, 0x6e, 0x4a, 0x61, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69,
	0x12, 0x24, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12,
	0x27, 0x0a, 0x0d, 0x6a, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6a, 0x61, 0x72,
	0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72,
	0x69, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x22, 0x9c, 0x01, 0x0a,
	0x0b, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x52, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2a, 0x0a, 0x0f,
	0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x61, 0x69, 0x6e,
	0x52, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67,
	0x73, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x55,
	0x72, 0x69, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x73, 0x22, 0x91, 0x02, 0x0a, 0x0d,
	0x53, 0x70, 0x61, 0x72, 0x6b, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x29, 0x0a,
	0x0e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x12, 0x69, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0d, 0x6a, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x6a, 0x61, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x73, 0x1a, 0x41, 0x0a, 0x13,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x32,
	0x9d, 0x06, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x12, 0xea, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8d, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x3a, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0xda, 0x41, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2c, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x38, 0x0a, 0x05, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x92, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x8f, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x70, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_v1_batches_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_v1_batches_proto_rawDescData = file_google_cloud_dataproc_v1_batches_proto_rawDesc
)

func file_google_cloud_dataproc_v1_batches_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_v1_batches_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_v1_batches_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_v1_batches_proto_rawDescData)
	})
	return file_google_cloud_dataproc_v1_batches_proto_rawDescData
}

var file_google_cloud_dataproc_v1_batches_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dataproc_v1_batches_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_dataproc_v1_batches_proto_goTypes = []interface{}{
	(Batch_State)(0),              // 0: google.cloud.dataproc.v1.Batch.State
	(*CreateBatchRequest)(nil),    // 1: google.cloud.dataproc.v1.CreateBatchRequest
	(*GetBatchRequest)(nil),       // 2: google.cloud.dataproc.v1.GetBatchRequest
	(*ListBatchesRequest)(nil),    // 3: google.cloud.dataproc.v1.ListBatchesRequest
	(*ListBatchesResponse)(nil),   // 4: google.cloud.dataproc.v1.ListBatchesResponse
	(*DeleteBatchRequest)(nil),    // 5: google.cloud.dataproc.v1.DeleteBatchRequest
	(*Batch)(nil),                 // 6: google.cloud.dataproc.v1.Batch
	(*PySparkBatch)(nil),          // 7: google.cloud.dataproc.v1.PySparkBatch
	(*SparkBatch)(nil),            // 8: google.cloud.dataproc.v1.SparkBatch
	(*SparkRBatch)(nil),           // 9: google.cloud.dataproc.v1.SparkRBatch
	(*SparkSqlBatch)(nil),         // 10: google.cloud.dataproc.v1.SparkSqlBatch
	(*Batch_StateHistory)(nil),    // 11: google.cloud.dataproc.v1.Batch.StateHistory
	nil,                           // 12: google.cloud.dataproc.v1.Batch.LabelsEntry
	nil,                           // 13: google.cloud.dataproc.v1.SparkSqlBatch.QueryVariablesEntry
	(*timestamppb.Timestamp)(nil), // 14: google.protobuf.Timestamp
	(*RuntimeInfo)(nil),           // 15: google.cloud.dataproc.v1.RuntimeInfo
	(*RuntimeConfig)(nil),         // 16: google.cloud.dataproc.v1.RuntimeConfig
	(*EnvironmentConfig)(nil),     // 17: google.cloud.dataproc.v1.EnvironmentConfig
	(*longrunning.Operation)(nil), // 18: google.longrunning.Operation
	(*emptypb.Empty)(nil),         // 19: google.protobuf.Empty
}
var file_google_cloud_dataproc_v1_batches_proto_depIdxs = []int32{
	6,  // 0: google.cloud.dataproc.v1.CreateBatchRequest.batch:type_name -> google.cloud.dataproc.v1.Batch
	6,  // 1: google.cloud.dataproc.v1.ListBatchesResponse.batches:type_name -> google.cloud.dataproc.v1.Batch
	14, // 2: google.cloud.dataproc.v1.Batch.create_time:type_name -> google.protobuf.Timestamp
	7,  // 3: google.cloud.dataproc.v1.Batch.pyspark_batch:type_name -> google.cloud.dataproc.v1.PySparkBatch
	8,  // 4: google.cloud.dataproc.v1.Batch.spark_batch:type_name -> google.cloud.dataproc.v1.SparkBatch
	9,  // 5: google.cloud.dataproc.v1.Batch.spark_r_batch:type_name -> google.cloud.dataproc.v1.SparkRBatch
	10, // 6: google.cloud.dataproc.v1.Batch.spark_sql_batch:type_name -> google.cloud.dataproc.v1.SparkSqlBatch
	15, // 7: google.cloud.dataproc.v1.Batch.runtime_info:type_name -> google.cloud.dataproc.v1.RuntimeInfo
	0,  // 8: google.cloud.dataproc.v1.Batch.state:type_name -> google.cloud.dataproc.v1.Batch.State
	14, // 9: google.cloud.dataproc.v1.Batch.state_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.cloud.dataproc.v1.Batch.labels:type_name -> google.cloud.dataproc.v1.Batch.LabelsEntry
	16, // 11: google.cloud.dataproc.v1.Batch.runtime_config:type_name -> google.cloud.dataproc.v1.RuntimeConfig
	17, // 12: google.cloud.dataproc.v1.Batch.environment_config:type_name -> google.cloud.dataproc.v1.EnvironmentConfig
	11, // 13: google.cloud.dataproc.v1.Batch.state_history:type_name -> google.cloud.dataproc.v1.Batch.StateHistory
	13, // 14: google.cloud.dataproc.v1.SparkSqlBatch.query_variables:type_name -> google.cloud.dataproc.v1.SparkSqlBatch.QueryVariablesEntry
	0,  // 15: google.cloud.dataproc.v1.Batch.StateHistory.state:type_name -> google.cloud.dataproc.v1.Batch.State
	14, // 16: google.cloud.dataproc.v1.Batch.StateHistory.state_start_time:type_name -> google.protobuf.Timestamp
	1,  // 17: google.cloud.dataproc.v1.BatchController.CreateBatch:input_type -> google.cloud.dataproc.v1.CreateBatchRequest
	2,  // 18: google.cloud.dataproc.v1.BatchController.GetBatch:input_type -> google.cloud.dataproc.v1.GetBatchRequest
	3,  // 19: google.cloud.dataproc.v1.BatchController.ListBatches:input_type -> google.cloud.dataproc.v1.ListBatchesRequest
	5,  // 20: google.cloud.dataproc.v1.BatchController.DeleteBatch:input_type -> google.cloud.dataproc.v1.DeleteBatchRequest
	18, // 21: google.cloud.dataproc.v1.BatchController.CreateBatch:output_type -> google.longrunning.Operation
	6,  // 22: google.cloud.dataproc.v1.BatchController.GetBatch:output_type -> google.cloud.dataproc.v1.Batch
	4,  // 23: google.cloud.dataproc.v1.BatchController.ListBatches:output_type -> google.cloud.dataproc.v1.ListBatchesResponse
	19, // 24: google.cloud.dataproc.v1.BatchController.DeleteBatch:output_type -> google.protobuf.Empty
	21, // [21:25] is the sub-list for method output_type
	17, // [17:21] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_v1_batches_proto_init() }
func file_google_cloud_dataproc_v1_batches_proto_init() {
	if File_google_cloud_dataproc_v1_batches_proto != nil {
		return
	}
	file_google_cloud_dataproc_v1_shared_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBatchesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBatchesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Batch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PySparkBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkRBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkSqlBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_batches_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Batch_StateHistory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataproc_v1_batches_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Batch_PysparkBatch)(nil),
		(*Batch_SparkBatch)(nil),
		(*Batch_SparkRBatch)(nil),
		(*Batch_SparkSqlBatch)(nil),
	}
	file_google_cloud_dataproc_v1_batches_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*SparkBatch_MainJarFileUri)(nil),
		(*SparkBatch_MainClass)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_v1_batches_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataproc_v1_batches_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_v1_batches_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataproc_v1_batches_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataproc_v1_batches_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_v1_batches_proto = out.File
	file_google_cloud_dataproc_v1_batches_proto_rawDesc = nil
	file_google_cloud_dataproc_v1_batches_proto_goTypes = nil
	file_google_cloud_dataproc_v1_batches_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BatchControllerClient is the client API for BatchController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BatchControllerClient interface {
	// Creates a batch workload that executes asynchronously.
	CreateBatch(ctx context.Context, in *CreateBatchRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets the batch workload resource representation.
	GetBatch(ctx context.Context, in *GetBatchRequest, opts ...grpc.CallOption) (*Batch, error)
	// Lists batch workloads.
	ListBatches(ctx context.Context, in *ListBatchesRequest, opts ...grpc.CallOption) (*ListBatchesResponse, error)
	// Deletes the batch workload resource. If the batch is not in terminal state,
	// the delete fails and the response returns `FAILED_PRECONDITION`.
	DeleteBatch(ctx context.Context, in *DeleteBatchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type batchControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewBatchControllerClient(cc grpc.ClientConnInterface) BatchControllerClient {
	return &batchControllerClient{cc}
}

func (c *batchControllerClient) CreateBatch(ctx context.Context, in *CreateBatchRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.BatchController/CreateBatch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) GetBatch(ctx context.Context, in *GetBatchRequest, opts ...grpc.CallOption) (*Batch, error) {
	out := new(Batch)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.BatchController/GetBatch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) ListBatches(ctx context.Context, in *ListBatchesRequest, opts ...grpc.CallOption) (*ListBatchesResponse, error) {
	out := new(ListBatchesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.BatchController/ListBatches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *batchControllerClient) DeleteBatch(ctx context.Context, in *DeleteBatchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.BatchController/DeleteBatch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BatchControllerServer is the server API for BatchController service.
type BatchControllerServer interface {
	// Creates a batch workload that executes asynchronously.
	CreateBatch(context.Context, *CreateBatchRequest) (*longrunning.Operation, error)
	// Gets the batch workload resource representation.
	GetBatch(context.Context, *GetBatchRequest) (*Batch, error)
	// Lists batch workloads.
	ListBatches(context.Context, *ListBatchesRequest) (*ListBatchesResponse, error)
	// Deletes the batch workload resource. If the batch is not in terminal state,
	// the delete fails and the response returns `FAILED_PRECONDITION`.
	DeleteBatch(context.Context, *DeleteBatchRequest) (*emptypb.Empty, error)
}

// UnimplementedBatchControllerServer can be embedded to have forward compatible implementations.
type UnimplementedBatchControllerServer struct {
}

func (*UnimplementedBatchControllerServer) CreateBatch(context.Context, *CreateBatchRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBatch not implemented")
}
func (*UnimplementedBatchControllerServer) GetBatch(context.Context, *GetBatchRequest) (*Batch, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBatch not implemented")
}
func (*UnimplementedBatchControllerServer) ListBatches(context.Context, *ListBatchesRequest) (*ListBatchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBatches not implemented")
}
func (*UnimplementedBatchControllerServer) DeleteBatch(context.Context, *DeleteBatchRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBatch not implemented")
}

func RegisterBatchControllerServer(s *grpc.Server, srv BatchControllerServer) {
	s.RegisterService(&_BatchController_serviceDesc, srv)
}

func _BatchController_CreateBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).CreateBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.BatchController/CreateBatch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).CreateBatch(ctx, req.(*CreateBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_GetBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).GetBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.BatchController/GetBatch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).GetBatch(ctx, req.(*GetBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_ListBatches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBatchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).ListBatches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.BatchController/ListBatches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).ListBatches(ctx, req.(*ListBatchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BatchController_DeleteBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BatchControllerServer).DeleteBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.BatchController/DeleteBatch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BatchControllerServer).DeleteBatch(ctx, req.(*DeleteBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BatchController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.BatchController",
	HandlerType: (*BatchControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBatch",
			Handler:    _BatchController_CreateBatch_Handler,
		},
		{
			MethodName: "GetBatch",
			Handler:    _BatchController_GetBatch_Handler,
		},
		{
			MethodName: "ListBatches",
			Handler:    _BatchController_ListBatches_Handler,
		},
		{
			MethodName: "DeleteBatch",
			Handler:    _BatchController_DeleteBatch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/batches.proto",
}
