// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package dataproc

import (
	"bytes"
	"context"
	"fmt"
	"io/ioutil"
	"math"
	"net/http"
	"net/url"
	"time"

	dataprocpb "cloud.google.com/go/dataproc/apiv1/dataprocpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/encoding/protojson"
)

var newNodeGroupControllerClientHook clientHook

// NodeGroupControllerCallOptions contains the retry settings for each method of NodeGroupControllerClient.
type NodeGroupControllerCallOptions struct {
	CreateNodeGroup []gax.CallOption
	ResizeNodeGroup []gax.CallOption
	GetNodeGroup    []gax.CallOption
}

func defaultNodeGroupControllerGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("dataproc.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("dataproc.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://dataproc.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultNodeGroupControllerCallOptions() *NodeGroupControllerCallOptions {
	return &NodeGroupControllerCallOptions{
		CreateNodeGroup: []gax.CallOption{},
		ResizeNodeGroup: []gax.CallOption{},
		GetNodeGroup:    []gax.CallOption{},
	}
}

func defaultNodeGroupControllerRESTCallOptions() *NodeGroupControllerCallOptions {
	return &NodeGroupControllerCallOptions{
		CreateNodeGroup: []gax.CallOption{},
		ResizeNodeGroup: []gax.CallOption{},
		GetNodeGroup:    []gax.CallOption{},
	}
}

// internalNodeGroupControllerClient is an interface that defines the methods available from Cloud Dataproc API.
type internalNodeGroupControllerClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateNodeGroup(context.Context, *dataprocpb.CreateNodeGroupRequest, ...gax.CallOption) (*CreateNodeGroupOperation, error)
	CreateNodeGroupOperation(name string) *CreateNodeGroupOperation
	ResizeNodeGroup(context.Context, *dataprocpb.ResizeNodeGroupRequest, ...gax.CallOption) (*ResizeNodeGroupOperation, error)
	ResizeNodeGroupOperation(name string) *ResizeNodeGroupOperation
	GetNodeGroup(context.Context, *dataprocpb.GetNodeGroupRequest, ...gax.CallOption) (*dataprocpb.NodeGroup, error)
}

// NodeGroupControllerClient is a client for interacting with Cloud Dataproc API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The NodeGroupControllerService provides methods to manage node groups
// of Compute Engine managed instances.
type NodeGroupControllerClient struct {
	// The internal transport-dependent client.
	internalClient internalNodeGroupControllerClient

	// The call options for this service.
	CallOptions *NodeGroupControllerCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *NodeGroupControllerClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *NodeGroupControllerClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *NodeGroupControllerClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateNodeGroup creates a node group in a cluster. The returned
// Operation.metadata is
// NodeGroupOperationMetadata (at https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
func (c *NodeGroupControllerClient) CreateNodeGroup(ctx context.Context, req *dataprocpb.CreateNodeGroupRequest, opts ...gax.CallOption) (*CreateNodeGroupOperation, error) {
	return c.internalClient.CreateNodeGroup(ctx, req, opts...)
}

// CreateNodeGroupOperation returns a new CreateNodeGroupOperation from a given name.
// The name must be that of a previously created CreateNodeGroupOperation, possibly from a different process.
func (c *NodeGroupControllerClient) CreateNodeGroupOperation(name string) *CreateNodeGroupOperation {
	return c.internalClient.CreateNodeGroupOperation(name)
}

// ResizeNodeGroup resizes a node group in a cluster. The returned
// Operation.metadata is
// NodeGroupOperationMetadata (at https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
func (c *NodeGroupControllerClient) ResizeNodeGroup(ctx context.Context, req *dataprocpb.ResizeNodeGroupRequest, opts ...gax.CallOption) (*ResizeNodeGroupOperation, error) {
	return c.internalClient.ResizeNodeGroup(ctx, req, opts...)
}

// ResizeNodeGroupOperation returns a new ResizeNodeGroupOperation from a given name.
// The name must be that of a previously created ResizeNodeGroupOperation, possibly from a different process.
func (c *NodeGroupControllerClient) ResizeNodeGroupOperation(name string) *ResizeNodeGroupOperation {
	return c.internalClient.ResizeNodeGroupOperation(name)
}

// GetNodeGroup gets the resource representation for a node group in a
// cluster.
func (c *NodeGroupControllerClient) GetNodeGroup(ctx context.Context, req *dataprocpb.GetNodeGroupRequest, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	return c.internalClient.GetNodeGroup(ctx, req, opts...)
}

// nodeGroupControllerGRPCClient is a client for interacting with Cloud Dataproc API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type nodeGroupControllerGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing NodeGroupControllerClient
	CallOptions **NodeGroupControllerCallOptions

	// The gRPC API client.
	nodeGroupControllerClient dataprocpb.NodeGroupControllerClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewNodeGroupControllerClient creates a new node group controller client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The NodeGroupControllerService provides methods to manage node groups
// of Compute Engine managed instances.
func NewNodeGroupControllerClient(ctx context.Context, opts ...option.ClientOption) (*NodeGroupControllerClient, error) {
	clientOpts := defaultNodeGroupControllerGRPCClientOptions()
	if newNodeGroupControllerClientHook != nil {
		hookOpts, err := newNodeGroupControllerClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := NodeGroupControllerClient{CallOptions: defaultNodeGroupControllerCallOptions()}

	c := &nodeGroupControllerGRPCClient{
		connPool:                  connPool,
		disableDeadlines:          disableDeadlines,
		nodeGroupControllerClient: dataprocpb.NewNodeGroupControllerClient(connPool),
		CallOptions:               &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *nodeGroupControllerGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *nodeGroupControllerGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *nodeGroupControllerGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type nodeGroupControllerRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD

	// Points back to the CallOptions field of the containing NodeGroupControllerClient
	CallOptions **NodeGroupControllerCallOptions
}

// NewNodeGroupControllerRESTClient creates a new node group controller rest client.
//
// The NodeGroupControllerService provides methods to manage node groups
// of Compute Engine managed instances.
func NewNodeGroupControllerRESTClient(ctx context.Context, opts ...option.ClientOption) (*NodeGroupControllerClient, error) {
	clientOpts := append(defaultNodeGroupControllerRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultNodeGroupControllerRESTCallOptions()
	c := &nodeGroupControllerRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &NodeGroupControllerClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultNodeGroupControllerRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://dataproc.googleapis.com"),
		internaloption.WithDefaultMTLSEndpoint("https://dataproc.mtls.googleapis.com"),
		internaloption.WithDefaultAudience("https://dataproc.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *nodeGroupControllerRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *nodeGroupControllerRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *nodeGroupControllerRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *nodeGroupControllerGRPCClient) CreateNodeGroup(ctx context.Context, req *dataprocpb.CreateNodeGroupRequest, opts ...gax.CallOption) (*CreateNodeGroupOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateNodeGroup[0:len((*c.CallOptions).CreateNodeGroup):len((*c.CallOptions).CreateNodeGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.nodeGroupControllerClient.CreateNodeGroup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateNodeGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *nodeGroupControllerGRPCClient) ResizeNodeGroup(ctx context.Context, req *dataprocpb.ResizeNodeGroupRequest, opts ...gax.CallOption) (*ResizeNodeGroupOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ResizeNodeGroup[0:len((*c.CallOptions).ResizeNodeGroup):len((*c.CallOptions).ResizeNodeGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.nodeGroupControllerClient.ResizeNodeGroup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResizeNodeGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *nodeGroupControllerGRPCClient) GetNodeGroup(ctx context.Context, req *dataprocpb.GetNodeGroupRequest, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetNodeGroup[0:len((*c.CallOptions).GetNodeGroup):len((*c.CallOptions).GetNodeGroup)], opts...)
	var resp *dataprocpb.NodeGroup
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.nodeGroupControllerClient.GetNodeGroup(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateNodeGroup creates a node group in a cluster. The returned
// Operation.metadata is
// NodeGroupOperationMetadata (at https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
func (c *nodeGroupControllerRESTClient) CreateNodeGroup(ctx context.Context, req *dataprocpb.CreateNodeGroupRequest, opts ...gax.CallOption) (*CreateNodeGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNodeGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/nodeGroups", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetNodeGroupId() != "" {
		params.Add("nodeGroupId", fmt.Sprintf("%v", req.GetNodeGroupId()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateNodeGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ResizeNodeGroup resizes a node group in a cluster. The returned
// Operation.metadata is
// NodeGroupOperationMetadata (at https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
func (c *nodeGroupControllerRESTClient) ResizeNodeGroup(ctx context.Context, req *dataprocpb.ResizeNodeGroupRequest, opts ...gax.CallOption) (*ResizeNodeGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:resize", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ResizeNodeGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetNodeGroup gets the resource representation for a node group in a
// cluster.
func (c *nodeGroupControllerRESTClient) GetNodeGroup(ctx context.Context, req *dataprocpb.GetNodeGroupRequest, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).GetNodeGroup[0:len((*c.CallOptions).GetNodeGroup):len((*c.CallOptions).GetNodeGroup)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &dataprocpb.NodeGroup{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateNodeGroupOperation manages a long-running operation from CreateNodeGroup.
type CreateNodeGroupOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// CreateNodeGroupOperation returns a new CreateNodeGroupOperation from a given name.
// The name must be that of a previously created CreateNodeGroupOperation, possibly from a different process.
func (c *nodeGroupControllerGRPCClient) CreateNodeGroupOperation(name string) *CreateNodeGroupOperation {
	return &CreateNodeGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateNodeGroupOperation returns a new CreateNodeGroupOperation from a given name.
// The name must be that of a previously created CreateNodeGroupOperation, possibly from a different process.
func (c *nodeGroupControllerRESTClient) CreateNodeGroupOperation(name string) *CreateNodeGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateNodeGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateNodeGroupOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp dataprocpb.NodeGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateNodeGroupOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp dataprocpb.NodeGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateNodeGroupOperation) Metadata() (*dataprocpb.NodeGroupOperationMetadata, error) {
	var meta dataprocpb.NodeGroupOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateNodeGroupOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateNodeGroupOperation) Name() string {
	return op.lro.Name()
}

// ResizeNodeGroupOperation manages a long-running operation from ResizeNodeGroup.
type ResizeNodeGroupOperation struct {
	lro      *longrunning.Operation
	pollPath string
}

// ResizeNodeGroupOperation returns a new ResizeNodeGroupOperation from a given name.
// The name must be that of a previously created ResizeNodeGroupOperation, possibly from a different process.
func (c *nodeGroupControllerGRPCClient) ResizeNodeGroupOperation(name string) *ResizeNodeGroupOperation {
	return &ResizeNodeGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResizeNodeGroupOperation returns a new ResizeNodeGroupOperation from a given name.
// The name must be that of a previously created ResizeNodeGroupOperation, possibly from a different process.
func (c *nodeGroupControllerRESTClient) ResizeNodeGroupOperation(name string) *ResizeNodeGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ResizeNodeGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ResizeNodeGroupOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp dataprocpb.NodeGroup
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ResizeNodeGroupOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*dataprocpb.NodeGroup, error) {
	opts = append([]gax.CallOption{gax.WithPath(op.pollPath)}, opts...)
	var resp dataprocpb.NodeGroup
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ResizeNodeGroupOperation) Metadata() (*dataprocpb.NodeGroupOperationMetadata, error) {
	var meta dataprocpb.NodeGroupOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ResizeNodeGroupOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ResizeNodeGroupOperation) Name() string {
	return op.lro.Name()
}
