/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateSnapshot
extends BaseCmd {
    private static final String[] DESCRIPTION_DESC = new String[]{"An optional description of the snapshot."};

    public CreateSnapshot(String[] args) {
        super("ec2addsnap", "ec2-create-snapshot");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DESCRIPTION");
        OptionBuilder.withDescription((String)CreateSnapshot.joinDescription(DESCRIPTION_DESC));
        options.addOption(OptionBuilder.create((String)"d"));
        return options;
    }

    protected String getOptionString() {
        return "-d DESCRIPTION VOLUME";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a snapshot of a volume.");
        System.out.println("     The VOLUME parameter is the name of an existing volume.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("description");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("volume");
        String volumeId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        String description = this.getOptionValue("description");
        RequestResultPair rsp = jec2.createSnapshot(volumeId, description);
        if (rsp.getResponse() != null) {
            out.output(System.out, (SnapshotDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CreateSnapshot(args).invoke();
    }
}

