/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

final class ArrowButton {
    DefaultButton normal;
    DefaultButton focus;
    DefaultButton pressed;

    public ArrowButton(GtkParser parser, String direction) throws Exception {
        this.normal = GtkUtils.newButton(parser, "arrows", new String[]{"function", "state", "arrow_direction"}, new String[]{"ARROW", "NORMAL", direction});
        this.normal.setCenterFill(1);
        this.focus = GtkUtils.newButton(parser, "arrows", new String[]{"function", "state", "arrow_direction"}, new String[]{"ARROW", "PRELIGHT", direction});
        this.focus.setCenterFill(1);
        this.pressed = GtkUtils.newButton(parser, "arrows", new String[]{"function", "shadow", "arrow_direction"}, new String[]{"ARROW", "IN", direction});
        this.pressed.setCenterFill(1);
    }

    public int getWidth() {
        return this.normal.getWidth();
    }

    public int getHeight() {
        return this.normal.getHeight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void paint(Graphics g, AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!b.isEnabled()) {
            this.normal.paint(g, b);
        } else if (model.isArmed() && model.isPressed()) {
            this.pressed.paint(g, b);
        } else if (model.isRollover() && this.focus != null) {
            this.focus.paint(g, b);
        } else {
            this.normal.paint(g, b);
        }
    }
}

