// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package inkrecognizer

import original "github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v1.0/inkrecognizer"

type Application = original.Application

const (
	Drawing Application = original.Drawing
	Mixed   Application = original.Mixed
	Writing Application = original.Writing
)

type Category = original.Category

const (
	InkBullet     Category = original.InkBullet
	InkDrawing    Category = original.InkDrawing
	InkWord       Category = original.InkWord
	Line          Category = original.Line
	Paragraph     Category = original.Paragraph
	Root          Category = original.Root
	Unknown       Category = original.Unknown
	WritingRegion Category = original.WritingRegion
)

type Class = original.Class

const (
	ClassContainer Class = original.ClassContainer
	ClassLeaf      Class = original.ClassLeaf
)

type Container = original.Container

const (
	ContainerLine          Container = original.ContainerLine
	ContainerParagraph     Container = original.ContainerParagraph
	ContainerRoot          Container = original.ContainerRoot
	ContainerWritingRegion Container = original.ContainerWritingRegion
)

type InputDevice = original.InputDevice

const (
	Armature        InputDevice = original.Armature
	ArticulatedArm  InputDevice = original.ArticulatedArm
	Digitizer       InputDevice = original.Digitizer
	LightPen        InputDevice = original.LightPen
	Pen             InputDevice = original.Pen
	StereoPlotter   InputDevice = original.StereoPlotter
	ThreedDigitizer InputDevice = original.ThreedDigitizer
	TouchPad        InputDevice = original.TouchPad
	TouchScreen     InputDevice = original.TouchScreen
	WhiteBoard      InputDevice = original.WhiteBoard
)

type Kind = original.Kind

const (
	KindInkDrawing Kind = original.KindInkDrawing
	KindInkWriting Kind = original.KindInkWriting
)

type Leaf = original.Leaf

const (
	LeafInkBullet  Leaf = original.LeafInkBullet
	LeafInkDrawing Leaf = original.LeafInkDrawing
	LeafInkWord    Leaf = original.LeafInkWord
	LeafUnknown    Leaf = original.LeafUnknown
)

type RasterOp = original.RasterOp

const (
	CopyPen     RasterOp = original.CopyPen
	MaskPen     RasterOp = original.MaskPen
	NoOperation RasterOp = original.NoOperation
)

type Shape = original.Shape

const (
	ShapeBlockArrow          Shape = original.ShapeBlockArrow
	ShapeCircle              Shape = original.ShapeCircle
	ShapeCloud               Shape = original.ShapeCloud
	ShapeCurve               Shape = original.ShapeCurve
	ShapeDiamond             Shape = original.ShapeDiamond
	ShapeDrawing             Shape = original.ShapeDrawing
	ShapeEllipse             Shape = original.ShapeEllipse
	ShapeEquilateralTriangle Shape = original.ShapeEquilateralTriangle
	ShapeHeart               Shape = original.ShapeHeart
	ShapeHexagon             Shape = original.ShapeHexagon
	ShapeIsoscelesTriangle   Shape = original.ShapeIsoscelesTriangle
	ShapeLine                Shape = original.ShapeLine
	ShapeParallelogram       Shape = original.ShapeParallelogram
	ShapePentagon            Shape = original.ShapePentagon
	ShapePolyLine            Shape = original.ShapePolyLine
	ShapeQuadrilateral       Shape = original.ShapeQuadrilateral
	ShapeRectangle           Shape = original.ShapeRectangle
	ShapeRightTriangle       Shape = original.ShapeRightTriangle
	ShapeSquare              Shape = original.ShapeSquare
	ShapeStarCrossed         Shape = original.ShapeStarCrossed
	ShapeStarSimple          Shape = original.ShapeStarSimple
	ShapeTrapezoid           Shape = original.ShapeTrapezoid
	ShapeTriangle            Shape = original.ShapeTriangle
)

type Tip = original.Tip

const (
	Ellipse   Tip = original.Ellipse
	Rectangle Tip = original.Rectangle
)

type Unit = original.Unit

const (
	Cm Unit = original.Cm
	In Unit = original.In
	Mm Unit = original.Mm
)

type AlternatePatternItem = original.AlternatePatternItem
type AnalysisRequest = original.AnalysisRequest
type AnalysisResponse = original.AnalysisResponse
type BaseClient = original.BaseClient
type Client = original.Client
type DrawingAttributesPattern = original.DrawingAttributesPattern
type DrawingAttributesPatternColor = original.DrawingAttributesPatternColor
type ErrorModel = original.ErrorModel
type ErrorModelDetailsItem = original.ErrorModelDetailsItem
type InkPoint = original.InkPoint
type InkPointValueAttribute = original.InkPointValueAttribute
type PointDetailsPattern = original.PointDetailsPattern
type RecognitionUnitItem = original.RecognitionUnitItem
type RecognitionUnitItemBoundingRectangle = original.RecognitionUnitItemBoundingRectangle
type Stroke = original.Stroke

func New(endpoint string) BaseClient {
	return original.New(endpoint)
}
func NewClient(endpoint string) Client {
	return original.NewClient(endpoint)
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func PossibleApplicationValues() []Application {
	return original.PossibleApplicationValues()
}
func PossibleCategoryValues() []Category {
	return original.PossibleCategoryValues()
}
func PossibleClassValues() []Class {
	return original.PossibleClassValues()
}
func PossibleContainerValues() []Container {
	return original.PossibleContainerValues()
}
func PossibleInputDeviceValues() []InputDevice {
	return original.PossibleInputDeviceValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleLeafValues() []Leaf {
	return original.PossibleLeafValues()
}
func PossibleRasterOpValues() []RasterOp {
	return original.PossibleRasterOpValues()
}
func PossibleShapeValues() []Shape {
	return original.PossibleShapeValues()
}
func PossibleTipValues() []Tip {
	return original.PossibleTipValues()
}
func PossibleUnitValues() []Unit {
	return original.PossibleUnitValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
