package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GradeCabService invokes the cloudcallcenter.GradeCabService API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gradecabservice.html
func (client *Client) GradeCabService(request *GradeCabServiceRequest) (response *GradeCabServiceResponse, err error) {
	response = CreateGradeCabServiceResponse()
	err = client.DoAction(request, response)
	return
}

// GradeCabServiceWithChan invokes the cloudcallcenter.GradeCabService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gradecabservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GradeCabServiceWithChan(request *GradeCabServiceRequest) (<-chan *GradeCabServiceResponse, <-chan error) {
	responseChan := make(chan *GradeCabServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GradeCabService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GradeCabServiceWithCallback invokes the cloudcallcenter.GradeCabService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gradecabservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GradeCabServiceWithCallback(request *GradeCabServiceRequest, callback func(response *GradeCabServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GradeCabServiceResponse
		var err error
		defer close(result)
		response, err = client.GradeCabService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GradeCabServiceRequest is the request struct for api GradeCabService
type GradeCabServiceRequest struct {
	*requests.RpcRequest
	Components string           `position:"Query" name:"Components"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// GradeCabServiceResponse is the response struct for api GradeCabService
type GradeCabServiceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateGradeCabServiceRequest creates a request to invoke GradeCabService API
func CreateGradeCabServiceRequest() (request *GradeCabServiceRequest) {
	request = &GradeCabServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GradeCabService", "", "")
	request.Method = requests.POST
	return
}

// CreateGradeCabServiceResponse creates a response to parse from GradeCabService response
func CreateGradeCabServiceResponse() (response *GradeCabServiceResponse) {
	response = &GradeCabServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
