package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRecordingsByContactId invokes the cloudcallcenter.ListRecordingsByContactId API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingsbycontactid.html
func (client *Client) ListRecordingsByContactId(request *ListRecordingsByContactIdRequest) (response *ListRecordingsByContactIdResponse, err error) {
	response = CreateListRecordingsByContactIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListRecordingsByContactIdWithChan invokes the cloudcallcenter.ListRecordingsByContactId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingsbycontactid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordingsByContactIdWithChan(request *ListRecordingsByContactIdRequest) (<-chan *ListRecordingsByContactIdResponse, <-chan error) {
	responseChan := make(chan *ListRecordingsByContactIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRecordingsByContactId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRecordingsByContactIdWithCallback invokes the cloudcallcenter.ListRecordingsByContactId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingsbycontactid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordingsByContactIdWithCallback(request *ListRecordingsByContactIdRequest, callback func(response *ListRecordingsByContactIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRecordingsByContactIdResponse
		var err error
		defer close(result)
		response, err = client.ListRecordingsByContactId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRecordingsByContactIdRequest is the request struct for api ListRecordingsByContactId
type ListRecordingsByContactIdRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ContactId  string `position:"Query" name:"ContactId"`
}

// ListRecordingsByContactIdResponse is the response struct for api ListRecordingsByContactId
type ListRecordingsByContactIdResponse struct {
	*responses.BaseResponse
	RequestId      string                                `json:"RequestId" xml:"RequestId"`
	Success        bool                                  `json:"Success" xml:"Success"`
	Code           string                                `json:"Code" xml:"Code"`
	Message        string                                `json:"Message" xml:"Message"`
	HttpStatusCode int                                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Recordings     RecordingsInListRecordingsByContactId `json:"Recordings" xml:"Recordings"`
}

// CreateListRecordingsByContactIdRequest creates a request to invoke ListRecordingsByContactId API
func CreateListRecordingsByContactIdRequest() (request *ListRecordingsByContactIdRequest) {
	request = &ListRecordingsByContactIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListRecordingsByContactId", "", "")
	request.Method = requests.POST
	return
}

// CreateListRecordingsByContactIdResponse creates a response to parse from ListRecordingsByContactId response
func CreateListRecordingsByContactIdResponse() (response *ListRecordingsByContactIdResponse) {
	response = &ListRecordingsByContactIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
